/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.db;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nullable;
import java.util.concurrent.ConcurrentHashMap;
import ru.tinkoff.kora.database.common.QueryContext;
import ru.tinkoff.kora.database.common.telemetry.DataBaseMetricWriter;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class Opentelemetry120DataBaseMetricWriter
implements DataBaseMetricWriter {
    private final String poolName;
    private final ConcurrentHashMap<DbKey, DbMetrics> metrics = new ConcurrentHashMap();
    private final MeterRegistry meterRegistry;
    private final TelemetryConfig.MetricsConfig config;

    public Opentelemetry120DataBaseMetricWriter(MeterRegistry meterRegistry, TelemetryConfig.MetricsConfig config, String poolName) {
        this.poolName = poolName;
        this.meterRegistry = meterRegistry;
        this.config = config;
    }

    public void recordQuery(long queryBegin, QueryContext queryContext, @Nullable Throwable exception) {
        long duration = System.nanoTime() - queryBegin;
        DbKey key = new DbKey(queryContext.queryId(), queryContext.operation(), exception == null ? null : exception.getClass());
        DbMetrics metrics = this.metrics.computeIfAbsent(key, this::metrics);
        metrics.duration().record((double)duration / 1000000.0);
    }

    public Object getMetricRegistry() {
        return this.meterRegistry;
    }

    private DbMetrics metrics(DbKey key) {
        DistributionSummary.Builder builder = DistributionSummary.builder((String)"database.client.request.duration").serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120)).baseUnit("milliseconds").tag("pool", this.poolName).tag("query.id", key.queryId()).tag("query.operation", key.operation());
        if (key.error != null) {
            builder.tag("error", key.error.getCanonicalName());
        } else {
            builder.tag("error", "");
        }
        return new DbMetrics(builder.register(this.meterRegistry));
    }

    private record DbKey(String queryId, String operation, @Nullable Class<? extends Throwable> error) {
    }

    private record DbMetrics(DistributionSummary duration) {
    }
}

