/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.db;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.incubating.DbIncubatingAttributes;
import io.opentelemetry.semconv.incubating.PoolIncubatingAttributes;
import jakarta.annotation.Nullable;
import java.util.concurrent.ConcurrentHashMap;
import ru.tinkoff.kora.database.common.QueryContext;
import ru.tinkoff.kora.database.common.telemetry.DataBaseMetricWriter;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class Opentelemetry123DataBaseMetricWriter
implements DataBaseMetricWriter {
    private final String poolName;
    private final ConcurrentHashMap<DbKey, DbMetrics> metrics = new ConcurrentHashMap();
    private final MeterRegistry meterRegistry;
    private final TelemetryConfig.MetricsConfig config;

    public Opentelemetry123DataBaseMetricWriter(MeterRegistry meterRegistry, TelemetryConfig.MetricsConfig config, String poolName) {
        this.poolName = poolName;
        this.meterRegistry = meterRegistry;
        this.config = config;
    }

    public void recordQuery(long queryBegin, QueryContext queryContext, @Nullable Throwable exception) {
        long duration = System.nanoTime() - queryBegin;
        DbKey key = new DbKey(queryContext.queryId(), queryContext.operation(), exception == null ? null : exception.getClass());
        DbMetrics metrics = this.metrics.computeIfAbsent(key, this::metrics);
        metrics.duration().record((double)duration / 1.0E9);
    }

    public Object getMetricRegistry() {
        return this.meterRegistry;
    }

    private DbMetrics metrics(DbKey key) {
        DistributionSummary.Builder builder = DistributionSummary.builder((String)"db.client.request.duration").serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123)).baseUnit("s").tag(PoolIncubatingAttributes.POOL_NAME.getKey(), this.poolName).tag(DbIncubatingAttributes.DB_STATEMENT.getKey(), key.queryId()).tag(DbIncubatingAttributes.DB_OPERATION.getKey(), key.operation());
        if (key.error != null) {
            builder.tag(ErrorAttributes.ERROR_TYPE.getKey(), key.error.getCanonicalName());
        } else {
            builder.tag(ErrorAttributes.ERROR_TYPE.getKey(), "");
        }
        return new DbMetrics(builder.register(this.meterRegistry));
    }

    private record DbKey(String queryId, String operation, @Nullable Class<? extends Throwable> error) {
    }

    private record DbMetrics(DistributionSummary duration) {
    }
}

