/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.grpc.client;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import ru.tinkoff.grpc.client.telemetry.GrpcClientMetrics;
import ru.tinkoff.kora.micrometer.module.grpc.client.tag.MessageReceivedKey;
import ru.tinkoff.kora.micrometer.module.grpc.client.tag.MessageSendKey;
import ru.tinkoff.kora.micrometer.module.grpc.client.tag.MethodDurationKey;
import ru.tinkoff.kora.micrometer.module.grpc.client.tag.MicrometerGrpcClientTagsProvider;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class Opentelemetry120GrpcClientMetrics
implements GrpcClientMetrics {
    private final ConcurrentHashMap<MethodDurationKey, DistributionSummary> durationMetrics = new ConcurrentHashMap();
    private final ConcurrentHashMap<MessageSendKey, Counter> requestsByRpcMetrics = new ConcurrentHashMap();
    private final ConcurrentHashMap<MessageReceivedKey, Counter> responsesByRpcMetrics = new ConcurrentHashMap();
    private final MeterRegistry registry;
    private final ServiceDescriptor service;
    private final TelemetryConfig.MetricsConfig config;
    private final URI uri;
    private final MicrometerGrpcClientTagsProvider tagsProvider;

    public Opentelemetry120GrpcClientMetrics(MeterRegistry registry, ServiceDescriptor service, TelemetryConfig.MetricsConfig config, URI uri, MicrometerGrpcClientTagsProvider tagsProvider) {
        this.registry = registry;
        this.service = service;
        this.config = config;
        this.uri = uri;
        this.tagsProvider = tagsProvider;
    }

    public <RespT, ReqT> void recordEnd(MethodDescriptor<ReqT, RespT> method, long startTime, Exception e) {
        Metadata metadata;
        Integer code;
        if (e instanceof StatusException) {
            StatusException se = (StatusException)e;
            code = se.getStatus().getCode().value();
            metadata = se.getTrailers();
        } else if (e instanceof StatusRuntimeException) {
            StatusRuntimeException sre = (StatusRuntimeException)e;
            code = sre.getStatus().getCode().value();
            metadata = sre.getTrailers();
        } else {
            code = null;
            metadata = null;
        }
        MethodDurationKey key = new MethodDurationKey(this.service.getName(), method.getBareMethodName(), code, e.getClass());
        DistributionSummary metrics = this.durationMetrics.computeIfAbsent(key, k -> this.buildDurationMetrics((MethodDurationKey)k, metadata));
        double processingTime = (double)(System.nanoTime() - startTime) / 1000000.0;
        metrics.record(processingTime);
    }

    public <RespT, ReqT> void recordEnd(MethodDescriptor<ReqT, RespT> method, long startTime, Status status, Metadata trailers) {
        Integer code = status == null ? null : Integer.valueOf(status.getCode().value());
        MethodDurationKey key = new MethodDurationKey(this.service.getName(), method.getBareMethodName(), code, null);
        DistributionSummary metrics = this.durationMetrics.computeIfAbsent(key, k -> this.buildDurationMetrics((MethodDurationKey)k, trailers));
        double processingTime = (double)(System.nanoTime() - startTime) / 1000000.0;
        metrics.record(processingTime);
    }

    public <RespT, ReqT> void recordSendMessage(MethodDescriptor<ReqT, RespT> method, ReqT message) {
        MessageSendKey key = new MessageSendKey(this.service.getName(), method.getBareMethodName());
        Counter metrics = this.requestsByRpcMetrics.computeIfAbsent(key, k -> this.buildSendMetrics((MessageSendKey)k, message));
        metrics.increment();
    }

    public <RespT, ReqT> void recordReceiveMessage(MethodDescriptor<ReqT, RespT> method, RespT message) {
        MessageReceivedKey key = new MessageReceivedKey(this.service.getName(), method.getBareMethodName());
        Counter metrics = this.responsesByRpcMetrics.computeIfAbsent(key, k -> this.buildReceivedMetrics((MessageReceivedKey)k, message));
        metrics.increment();
    }

    private DistributionSummary buildDurationMetrics(MethodDurationKey method, @Nullable Metadata metadata) {
        DistributionSummary duration = DistributionSummary.builder((String)"rpc.client.duration").tags(this.tagsProvider.getMethodDurationTags(this.uri, method, metadata)).serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120)).register(this.registry);
        return duration;
    }

    private Counter buildSendMetrics(MessageSendKey key, Object request) {
        Counter requestsByRpc = Counter.builder((String)"rpc.client.requests_per_rpc").tags(this.tagsProvider.getMessageSendTags(this.uri, key, request)).register(this.registry);
        return requestsByRpc;
    }

    private Counter buildReceivedMetrics(MessageReceivedKey key, Object response) {
        Counter responsesByRpc = Counter.builder((String)"rpc.client.responses_per_rpc").tags(this.tagsProvider.getMessageReceivedTags(this.uri, key, response)).register(this.registry);
        return responsesByRpc;
    }
}

