/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.grpc.client.tag;

import io.grpc.Metadata;
import io.micrometer.core.instrument.Tag;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.incubating.RpcIncubatingAttributes;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.tinkoff.kora.micrometer.module.grpc.client.tag.MessageReceivedKey;
import ru.tinkoff.kora.micrometer.module.grpc.client.tag.MessageSendKey;
import ru.tinkoff.kora.micrometer.module.grpc.client.tag.MethodDurationKey;
import ru.tinkoff.kora.micrometer.module.grpc.client.tag.MicrometerGrpcClientTagsProvider;

public class DefaultMicrometerGrpcClientTagsProvider
implements MicrometerGrpcClientTagsProvider {
    @Override
    public List<Tag> getMethodDurationTags(URI uri, MethodDurationKey key, @Nullable Metadata metadata) {
        String rpcService = Objects.requireNonNullElse(key.serviceName(), "GrpcService");
        String serverAddress = uri.getHost();
        int serverPort = uri.getPort();
        if (serverPort == -1) {
            serverPort = 80;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(7);
        tags.add(Tag.of((String)RpcIncubatingAttributes.RPC_METHOD.getKey(), (String)key.methodName()));
        tags.add(Tag.of((String)RpcIncubatingAttributes.RPC_SERVICE.getKey(), (String)rpcService));
        tags.add(Tag.of((String)RpcIncubatingAttributes.RPC_SYSTEM.getKey(), (String)"grpc"));
        tags.add(Tag.of((String)ServerAttributes.SERVER_ADDRESS.getKey(), (String)serverAddress));
        tags.add(Tag.of((String)ServerAttributes.SERVER_PORT.getKey(), (String)String.valueOf(serverPort)));
        if (key.code() != null) {
            tags.add(Tag.of((String)RpcIncubatingAttributes.RPC_GRPC_STATUS_CODE.getKey(), (String)String.valueOf(key.code())));
        } else {
            tags.add(Tag.of((String)RpcIncubatingAttributes.RPC_GRPC_STATUS_CODE.getKey(), (String)""));
        }
        if (key.errorType() != null) {
            tags.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)key.errorType().getCanonicalName()));
        } else {
            tags.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)""));
        }
        return tags;
    }

    @Override
    public List<Tag> getMessageSendTags(URI uri, MessageSendKey key, Object request) {
        String rpcService = Objects.requireNonNullElse(key.serviceName(), "GrpcService");
        String serverAddress = uri.getHost();
        int serverPort = uri.getPort();
        if (serverPort == -1) {
            serverPort = 80;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(5);
        tags.add(Tag.of((String)RpcIncubatingAttributes.RPC_METHOD.getKey(), (String)key.methodName()));
        tags.add(Tag.of((String)RpcIncubatingAttributes.RPC_SERVICE.getKey(), (String)rpcService));
        tags.add(Tag.of((String)RpcIncubatingAttributes.RPC_SYSTEM.getKey(), (String)"grpc"));
        tags.add(Tag.of((String)ServerAttributes.SERVER_ADDRESS.getKey(), (String)serverAddress));
        tags.add(Tag.of((String)ServerAttributes.SERVER_PORT.getKey(), (String)String.valueOf(serverPort)));
        return tags;
    }

    @Override
    public List<Tag> getMessageReceivedTags(URI uri, MessageReceivedKey key, Object response) {
        String rpcService = Objects.requireNonNullElse(key.serviceName(), "GrpcService");
        String serverAddress = uri.getHost();
        int serverPort = uri.getPort();
        if (serverPort == -1) {
            serverPort = 80;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(5);
        tags.add(Tag.of((String)RpcIncubatingAttributes.RPC_METHOD.getKey(), (String)key.methodName()));
        tags.add(Tag.of((String)RpcIncubatingAttributes.RPC_SERVICE.getKey(), (String)rpcService));
        tags.add(Tag.of((String)RpcIncubatingAttributes.RPC_SYSTEM.getKey(), (String)"grpc"));
        tags.add(Tag.of((String)ServerAttributes.SERVER_ADDRESS.getKey(), (String)serverAddress));
        tags.add(Tag.of((String)ServerAttributes.SERVER_PORT.getKey(), (String)String.valueOf(serverPort)));
        return tags;
    }
}

