/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.grpc.server;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerMetrics;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerMetricsFactory;
import ru.tinkoff.kora.micrometer.module.MetricsConfig;
import ru.tinkoff.kora.micrometer.module.grpc.server.Opentelemetry120GrpcServerMetrics;
import ru.tinkoff.kora.micrometer.module.grpc.server.Opentelemetry123GrpcServerMetrics;
import ru.tinkoff.kora.micrometer.module.grpc.server.tag.MetricsKey;
import ru.tinkoff.kora.micrometer.module.grpc.server.tag.MicrometerGrpcServerTagsProvider;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class MicrometerGrpcServerMetricsFactory
implements GrpcServerMetricsFactory {
    private final ConcurrentHashMap<MetricsKey, GrpcServerMetrics> metrics = new ConcurrentHashMap();
    private final MeterRegistry meterRegistry;
    private final MetricsConfig metricsConfig;
    private final MicrometerGrpcServerTagsProvider grpcServerTagsProvider;

    public MicrometerGrpcServerMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig, MicrometerGrpcServerTagsProvider grpcServerTagsProvider) {
        this.meterRegistry = meterRegistry;
        this.metricsConfig = metricsConfig;
        this.grpcServerTagsProvider = grpcServerTagsProvider;
    }

    public GrpcServerMetrics get(TelemetryConfig.MetricsConfig config, ServerCall<?, ?> call, Metadata headers, String serviceName, String methodName) {
        return this.metrics.computeIfAbsent(new MetricsKey(serviceName, methodName), key -> this.buildMetrics(config, (MetricsKey)key));
    }

    private GrpcServerMetrics buildMetrics(TelemetryConfig.MetricsConfig config, MetricsKey metricsKey) {
        Function<Integer, DistributionSummary> duration = code -> {
            DistributionSummary.Builder builder = DistributionSummary.builder((String)"rpc.server.duration").serviceLevelObjectives(config.slo(this.metricsConfig.opentelemetrySpec()));
            return builder.baseUnit(switch (this.metricsConfig.opentelemetrySpec()) {
                default -> throw new IncompatibleClassChangeError();
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> "milliseconds";
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> "s";
            }).tags(this.grpcServerTagsProvider.getDurationTags((Integer)code, metricsKey)).register(this.meterRegistry);
        };
        Counter requestsPerRpc = Counter.builder((String)"rpc.server.requests_per_rpc").baseUnit("messages").tags(this.grpcServerTagsProvider.getRequestsTags(metricsKey)).register(this.meterRegistry);
        Counter responsesPerRpc = Counter.builder((String)"rpc.server.responses_per_rpc").baseUnit("messages").tags(this.grpcServerTagsProvider.getResponsesTags(metricsKey)).register(this.meterRegistry);
        return switch (this.metricsConfig.opentelemetrySpec()) {
            default -> throw new IncompatibleClassChangeError();
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Opentelemetry120GrpcServerMetrics(duration, requestsPerRpc, responsesPerRpc);
            case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Opentelemetry123GrpcServerMetrics(duration, requestsPerRpc, responsesPerRpc);
        };
    }
}

