/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.http.client;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nullable;
import java.util.concurrent.ConcurrentHashMap;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientMetrics;
import ru.tinkoff.kora.http.common.HttpResultCode;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.micrometer.module.http.client.tag.DurationKey;
import ru.tinkoff.kora.micrometer.module.http.client.tag.MicrometerHttpClientTagsProvider;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class Opentelemetry123HttpClientMetrics
implements HttpClientMetrics {
    private final ConcurrentHashMap<DurationKey, DistributionSummary> duration = new ConcurrentHashMap();
    private final MeterRegistry meterRegistry;
    private final TelemetryConfig.MetricsConfig config;
    private final MicrometerHttpClientTagsProvider tagsProvider;

    public Opentelemetry123HttpClientMetrics(MeterRegistry meterRegistry, TelemetryConfig.MetricsConfig config, MicrometerHttpClientTagsProvider tagsProvider) {
        this.meterRegistry = meterRegistry;
        this.config = config;
        this.tagsProvider = tagsProvider;
    }

    public void record(@Nullable Integer statusCode, HttpResultCode resultCode, String scheme, String host, String method, String pathTemplate, HttpHeaders headers, long processingTimeNanos, @Nullable Throwable exception) {
        int code = statusCode == null ? -1 : statusCode;
        Class<?> errorType = exception != null ? exception.getClass() : null;
        DurationKey key = new DurationKey(code, method, host, scheme, pathTemplate, errorType);
        this.duration.computeIfAbsent(key, k -> this.buildMetrics((DurationKey)k, resultCode, headers)).record((double)processingTimeNanos / 1.0E9);
    }

    private DistributionSummary buildMetrics(DurationKey key, HttpResultCode resultCode, HttpHeaders headers) {
        DistributionSummary.Builder builder = DistributionSummary.builder((String)"http.client.request.duration").serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123)).baseUnit("s").tags(this.tagsProvider.getDurationTags(key, resultCode, headers));
        return builder.register(this.meterRegistry);
    }
}

