/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.http.client.tag;

import io.micrometer.core.instrument.Tag;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import java.util.ArrayList;
import java.util.List;
import ru.tinkoff.kora.http.common.HttpResultCode;
import ru.tinkoff.kora.http.common.header.HttpHeaders;
import ru.tinkoff.kora.micrometer.module.http.client.tag.DurationKey;
import ru.tinkoff.kora.micrometer.module.http.client.tag.MicrometerHttpClientTagsProvider;

public class Opentelemetry123MicrometerHttpClientTagsProvider
implements MicrometerHttpClientTagsProvider {
    @Override
    public List<Tag> getDurationTags(DurationKey key, HttpResultCode resultCode, HttpHeaders headers) {
        String statusCodeStr = Integer.toString(key.statusCode());
        ArrayList<Tag> tags = new ArrayList<Tag>(7);
        tags.add(Tag.of((String)HttpAttributes.HTTP_REQUEST_METHOD.getKey(), (String)key.method()));
        tags.add(Tag.of((String)HttpAttributes.HTTP_RESPONSE_STATUS_CODE.getKey(), (String)statusCodeStr));
        tags.add(Tag.of((String)ServerAttributes.SERVER_ADDRESS.getKey(), (String)key.host()));
        tags.add(Tag.of((String)UrlAttributes.URL_SCHEME.getKey(), (String)key.scheme()));
        tags.add(Tag.of((String)HttpAttributes.HTTP_ROUTE.getKey(), (String)key.target()));
        tags.add(Tag.of((String)"http.status_code", (String)statusCodeStr));
        if (key.errorType() != null) {
            tags.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)key.errorType().getCanonicalName()));
        } else {
            tags.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)""));
        }
        return tags;
    }
}

