/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.http.server.tag;

import io.micrometer.core.instrument.Tag;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import java.util.ArrayList;
import java.util.List;
import ru.tinkoff.kora.micrometer.module.http.server.tag.ActiveRequestsKey;
import ru.tinkoff.kora.micrometer.module.http.server.tag.DurationKey;
import ru.tinkoff.kora.micrometer.module.http.server.tag.MicrometerHttpServerTagsProvider;

public class Opentelemetry123MicrometerHttpServerTagsProvider
implements MicrometerHttpServerTagsProvider {
    @Override
    public Iterable<Tag> getActiveRequestsTags(ActiveRequestsKey key) {
        return List.of(Tag.of((String)HttpAttributes.HTTP_ROUTE.getKey(), (String)key.target()), Tag.of((String)HttpAttributes.HTTP_REQUEST_METHOD.getKey(), (String)key.method()), Tag.of((String)ServerAttributes.SERVER_ADDRESS.getKey(), (String)key.host()), Tag.of((String)UrlAttributes.URL_SCHEME.getKey(), (String)key.scheme()));
    }

    @Override
    public Iterable<Tag> getDurationTags(DurationKey key) {
        ArrayList<Tag> list = new ArrayList<Tag>(6);
        if (key.errorType() != null) {
            list.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)key.errorType().getCanonicalName()));
        } else {
            list.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)""));
        }
        list.add(Tag.of((String)HttpAttributes.HTTP_REQUEST_METHOD.getKey(), (String)key.method()));
        list.add(Tag.of((String)HttpAttributes.HTTP_RESPONSE_STATUS_CODE.getKey(), (String)Integer.toString(key.statusCode())));
        list.add(Tag.of((String)HttpAttributes.HTTP_ROUTE.getKey(), (String)key.route()));
        list.add(Tag.of((String)UrlAttributes.URL_SCHEME.getKey(), (String)key.scheme()));
        list.add(Tag.of((String)ServerAttributes.SERVER_ADDRESS.getKey(), (String)key.host()));
        return list;
    }
}

