/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.kafka.consumer;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import jakarta.annotation.Nullable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.kafka.common.consumer.telemetry.KafkaConsumerMetrics;
import ru.tinkoff.kora.micrometer.module.kafka.consumer.tag.MicrometerKafkaConsumerTagsProvider;
import ru.tinkoff.kora.micrometer.module.kafka.consumer.tag.RecordDurationKey;
import ru.tinkoff.kora.micrometer.module.kafka.consumer.tag.RecordsDurationKey;
import ru.tinkoff.kora.micrometer.module.kafka.consumer.tag.TopicLagKey;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class Opentelemetry120KafkaConsumerMetrics
implements KafkaConsumerMetrics,
Lifecycle {
    private final ConcurrentHashMap<RecordDurationKey, DistributionSummary> metrics = new ConcurrentHashMap();
    private final ConcurrentHashMap<RecordsDurationKey, DistributionSummary> metricsBatch = new ConcurrentHashMap();
    private final ConcurrentHashMap<TopicLagKey, LagGauge> lagMetrics = new ConcurrentHashMap();
    private final Properties driverProperties;
    private final MeterRegistry meterRegistry;
    private final TelemetryConfig.MetricsConfig config;
    private final MicrometerKafkaConsumerTagsProvider tagsProvider;
    @Nullable
    private final String clientId;
    @Nullable
    private final String groupId;

    public Opentelemetry120KafkaConsumerMetrics(MeterRegistry meterRegistry, Properties driverProperties, TelemetryConfig.MetricsConfig config, MicrometerKafkaConsumerTagsProvider tagsProvider) {
        String s;
        this.tagsProvider = tagsProvider;
        this.meterRegistry = meterRegistry;
        this.config = config;
        this.driverProperties = driverProperties;
        Object clientIdObj = driverProperties.get("client.id");
        Object groupIdObj = driverProperties.get("group.id");
        this.clientId = clientIdObj instanceof String ? (s = (String)clientIdObj) : null;
        this.groupId = groupIdObj instanceof String ? (s = (String)groupIdObj) : null;
    }

    private DistributionSummary metrics(RecordDurationKey key) {
        DistributionSummary.Builder builder = DistributionSummary.builder((String)"messaging.receive.duration").serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120)).baseUnit("milliseconds").tags(this.tagsProvider.getRecordDurationTags(this.clientId, this.groupId, this.driverProperties, key));
        return builder.register(this.meterRegistry);
    }

    private DistributionSummary metricBatch(RecordsDurationKey key) {
        DistributionSummary.Builder builder = DistributionSummary.builder((String)"messaging.process.batch.duration").serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120)).baseUnit("milliseconds").tags(this.tagsProvider.getRecordsDurationTags(this.clientId, this.groupId, this.driverProperties, key));
        return builder.register(this.meterRegistry);
    }

    public void onRecordsReceived(ConsumerRecords<?, ?> records) {
    }

    public void onRecordProcessed(String consumerName, ConsumerRecord<?, ?> record, long duration, @Nullable Throwable ex) {
        double durationDouble = (double)duration / 1000000.0;
        RecordDurationKey key = new RecordDurationKey(consumerName, record.topic(), record.partition(), ex != null ? ex.getClass() : null);
        this.metrics.computeIfAbsent(key, this::metrics).record(durationDouble);
    }

    public void reportLag(String consumerName, TopicPartition partition, long lag) {
        TopicLagKey key = new TopicLagKey(consumerName, partition.topic(), partition.partition());
        this.lagMetrics.computeIfAbsent((TopicLagKey)key, (Function<TopicLagKey, LagGauge>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$reportLag$0(ru.tinkoff.kora.micrometer.module.kafka.consumer.tag.TopicLagKey ), (Lru/tinkoff/kora/micrometer/module/kafka/consumer/tag/TopicLagKey;)Lru/tinkoff/kora/micrometer/module/kafka/consumer/Opentelemetry120KafkaConsumerMetrics$LagGauge;)((Opentelemetry120KafkaConsumerMetrics)this)).offsetLag = lag;
    }

    public KafkaConsumerMetrics.KafkaConsumerMetricsContext get(Consumer<?, ?> consumer) {
        KafkaClientMetrics micrometerMetrics = new KafkaClientMetrics(consumer);
        micrometerMetrics.bindTo(this.meterRegistry);
        return () -> micrometerMetrics.close();
    }

    public void onRecordsProcessed(String consumerName, ConsumerRecords<?, ?> records, long duration, @Nullable Throwable ex) {
        double durationDouble = (double)duration / 1000000.0;
        RecordsDurationKey key = new RecordsDurationKey(consumerName, ex != null ? ex.getClass() : null);
        this.metricsBatch.computeIfAbsent(key, this::metricBatch).record(durationDouble);
    }

    public void init() {
    }

    public void release() {
        ArrayList<DistributionSummary> metrics = new ArrayList<DistributionSummary>(this.metrics.values());
        this.metrics.clear();
        for (DistributionSummary distributionSummary : metrics) {
            distributionSummary.close();
        }
        ArrayList<DistributionSummary> metricsBatch = new ArrayList<DistributionSummary>(this.metricsBatch.values());
        this.metricsBatch.clear();
        for (DistributionSummary metric : metricsBatch) {
            metric.close();
        }
        ArrayList<LagGauge> arrayList = new ArrayList<LagGauge>(this.lagMetrics.values());
        this.lagMetrics.clear();
        for (LagGauge lagMetric : arrayList) {
            lagMetric.gauge.close();
        }
    }

    private /* synthetic */ LagGauge lambda$reportLag$0(TopicLagKey k) {
        return new LagGauge(k, this.clientId, this.driverProperties, this.tagsProvider, this.meterRegistry);
    }

    private static class LagGauge {
        private final Gauge gauge;
        private volatile long offsetLag;

        private LagGauge(TopicLagKey key, @Nullable String clientId, Properties driverProperties, MicrometerKafkaConsumerTagsProvider consumerTagsProvider, MeterRegistry meterRegistry) {
            this.gauge = Gauge.builder((String)"messaging.kafka.consumer.lag", () -> this.offsetLag).tags(consumerTagsProvider.getTopicLagTags(clientId, driverProperties, key)).register(meterRegistry);
        }
    }
}

