/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.kafka.consumer.tag;

import io.micrometer.core.instrument.Tag;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.incubating.MessagingIncubatingAttributes;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import ru.tinkoff.kora.micrometer.module.kafka.consumer.tag.MicrometerKafkaConsumerTagsProvider;
import ru.tinkoff.kora.micrometer.module.kafka.consumer.tag.RecordDurationKey;
import ru.tinkoff.kora.micrometer.module.kafka.consumer.tag.RecordsDurationKey;
import ru.tinkoff.kora.micrometer.module.kafka.consumer.tag.TopicLagKey;

public class Opentelemetry120KafkaConsumerTagsProvider
implements MicrometerKafkaConsumerTagsProvider {
    protected static final AttributeKey<String> MESSAGING_KAFKA_CONSUMER_NAME = AttributeKey.stringKey((String)"messaging.kafka.consumer.name");

    @Override
    public List<Tag> getRecordDurationTags(@Nullable String clientId, @Nullable String groupId, Properties driverProperties, RecordDurationKey key) {
        String partitionString = Integer.toString(key.partition());
        ArrayList<Tag> tags = new ArrayList<Tag>(6);
        if (key.errorType() != null) {
            tags.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)key.errorType().getCanonicalName()));
        } else {
            tags.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)""));
        }
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_SYSTEM.getKey(), (String)"kafka"));
        tags.add(Tag.of((String)MESSAGING_KAFKA_CONSUMER_NAME.getKey(), (String)key.consumerName()));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_DESTINATION_NAME.getKey(), (String)key.topic()));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_KAFKA_DESTINATION_PARTITION.getKey(), (String)partitionString));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_DESTINATION_PARTITION_ID.getKey(), (String)partitionString));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_CLIENT_ID.getKey(), (String)Objects.requireNonNullElse(clientId, "").toString()));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_KAFKA_CONSUMER_GROUP.getKey(), (String)Objects.requireNonNullElse(groupId, "").toString()));
        return tags;
    }

    @Override
    public List<Tag> getRecordsDurationTags(@Nullable String clientId, @Nullable String groupId, Properties driverProperties, RecordsDurationKey key) {
        ArrayList<Tag> tags = new ArrayList<Tag>(6);
        if (key.errorType() != null) {
            tags.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)key.errorType().getCanonicalName()));
        } else {
            tags.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)""));
        }
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_SYSTEM.getKey(), (String)"kafka"));
        tags.add(Tag.of((String)MESSAGING_KAFKA_CONSUMER_NAME.getKey(), (String)key.consumerName()));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_OPERATION.getKey(), (String)key.consumerName()));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_CLIENT_ID.getKey(), (String)Objects.requireNonNullElse(clientId, "").toString()));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_KAFKA_CONSUMER_GROUP.getKey(), (String)Objects.requireNonNullElse(groupId, "").toString()));
        return tags;
    }

    @Override
    public List<Tag> getTopicLagTags(@Nullable String clientId, Properties driverProperties, TopicLagKey key) {
        ArrayList<Tag> tags = new ArrayList<Tag>(6);
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_SYSTEM.getKey(), (String)"kafka"));
        tags.add(Tag.of((String)MESSAGING_KAFKA_CONSUMER_NAME.getKey(), (String)key.consumerName()));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_DESTINATION_NAME.getKey(), (String)key.topic()));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_KAFKA_DESTINATION_PARTITION.getKey(), (String)Objects.toString(key.partition())));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_CLIENT_ID.getKey(), (String)Objects.requireNonNullElse(clientId, "").toString()));
        return tags;
    }
}

