/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.kafka.producer;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import jakarta.annotation.Nullable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerMetrics;
import ru.tinkoff.kora.micrometer.module.kafka.producer.tag.MicrometerKafkaProducerTagsProvider;
import ru.tinkoff.kora.micrometer.module.kafka.producer.tag.RecordDurationKey;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public class Opentelemetry123KafkaProducerMetrics
implements KafkaProducerMetrics,
AutoCloseable {
    private final ConcurrentHashMap<RecordDurationKey, DistributionSummary> metrics = new ConcurrentHashMap();
    private final KafkaClientMetrics micrometerMetrics;
    private final Properties driverProperties;
    private final TelemetryConfig.MetricsConfig config;
    private final MeterRegistry meterRegistry;
    private final MicrometerKafkaProducerTagsProvider tagsProvider;
    @Nullable
    private final String clientId;

    public Opentelemetry123KafkaProducerMetrics(MeterRegistry meterRegistry, TelemetryConfig.MetricsConfig config, Producer<?, ?> producer, Properties driverProperties, MicrometerKafkaProducerTagsProvider tagsProvider) {
        String s;
        this.micrometerMetrics = new KafkaClientMetrics(producer);
        this.tagsProvider = tagsProvider;
        this.micrometerMetrics.bindTo(meterRegistry);
        this.driverProperties = driverProperties;
        this.config = config;
        this.meterRegistry = meterRegistry;
        Object clientIdObj = driverProperties.get("client.id");
        this.clientId = clientIdObj instanceof String ? (s = (String)clientIdObj) : null;
    }

    public KafkaProducerMetrics.KafkaProducerTxMetrics tx() {
        return new KafkaProducerMetrics.KafkaProducerTxMetrics(){

            public void commit() {
            }

            public void rollback(@Nullable Throwable e) {
            }
        };
    }

    public void sendEnd(ProducerRecord<?, ?> record, long durationNanos, Throwable e) {
        RecordDurationKey key = new RecordDurationKey(record.topic(), Objects.requireNonNullElse(record.partition(), -1), e.getClass());
        DistributionSummary m = this.metrics.computeIfAbsent(key, this::metrics);
        m.record((double)durationNanos / 1.0E9);
    }

    public void sendEnd(ProducerRecord<?, ?> record, long durationNanos, RecordMetadata metadata) {
        RecordDurationKey key = new RecordDurationKey(record.topic(), Objects.requireNonNullElse(record.partition(), -1), null);
        DistributionSummary m = this.metrics.computeIfAbsent(key, this::metrics);
        m.record((double)durationNanos / 1.0E9);
    }

    @Override
    public void close() {
        this.micrometerMetrics.close();
        Iterator<Map.Entry<RecordDurationKey, DistributionSummary>> i = this.metrics.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<RecordDurationKey, DistributionSummary> entry = i.next();
            i.remove();
            try {
                entry.getValue().close();
            }
            catch (Throwable throwable) {}
        }
    }

    private DistributionSummary metrics(RecordDurationKey key) {
        DistributionSummary.Builder builder = DistributionSummary.builder((String)"messaging.publish.duration").serviceLevelObjectives(this.config.slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123)).baseUnit("s").tags(this.tagsProvider.getTopicPartitionTags(this.clientId, this.driverProperties, key));
        return builder.register(this.meterRegistry);
    }
}

