/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.kafka.producer.tag;

import io.micrometer.core.instrument.Tag;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.incubating.MessagingIncubatingAttributes;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import ru.tinkoff.kora.micrometer.module.kafka.producer.tag.MicrometerKafkaProducerTagsProvider;
import ru.tinkoff.kora.micrometer.module.kafka.producer.tag.RecordDurationKey;

public class Opentelemetry123KafkaProviderTagsProvider
implements MicrometerKafkaProducerTagsProvider {
    @Override
    public List<Tag> getTopicPartitionTags(@Nullable String clientId, Properties driverProperties, RecordDurationKey key) {
        ArrayList<Tag> tags = new ArrayList<Tag>(6);
        if (key.errorType() != null) {
            tags.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)key.errorType().getCanonicalName()));
        } else {
            tags.add(Tag.of((String)ErrorAttributes.ERROR_TYPE.getKey(), (String)""));
        }
        if (key.partition() == -1) {
            tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_KAFKA_DESTINATION_PARTITION.getKey(), (String)""));
            tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_DESTINATION_PARTITION_ID.getKey(), (String)""));
        } else {
            String partitionString = Integer.toString(key.partition());
            tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_KAFKA_DESTINATION_PARTITION.getKey(), (String)partitionString));
            tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_DESTINATION_PARTITION_ID.getKey(), (String)partitionString));
        }
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_SYSTEM.getKey(), (String)"kafka"));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_DESTINATION_NAME.getKey(), (String)key.topic()));
        tags.add(Tag.of((String)MessagingIncubatingAttributes.MESSAGING_CLIENT_ID.getKey(), (String)Objects.requireNonNullElse(clientId, "").toString()));
        return tags;
    }
}

