/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.resilient;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreaker;
import ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreakerMetrics;

public final class MicrometerCircuitBreakerMetrics
implements CircuitBreakerMetrics {
    private final Map<String, StateMetrics> metrics = new ConcurrentHashMap<String, StateMetrics>();
    private final MeterRegistry registry;

    public MicrometerCircuitBreakerMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public void recordCallAcquire(@Nonnull String name, @Nonnull CircuitBreakerMetrics.CallAcquireStatus callStatus) {
        StateMetrics stateMetrics = this.getCircuitBreakerMetrics(name, CircuitBreaker.State.CLOSED);
        switch (stateMetrics.stateValue.get()) {
            case 1: {
                if (callStatus == CircuitBreakerMetrics.CallAcquireStatus.PERMITTED) {
                    stateMetrics.acquireHalfOpenPermitted.increment();
                } else {
                    stateMetrics.acquireHalfOpenRejected.increment();
                }
            }
            case 2: {
                if (callStatus != CircuitBreakerMetrics.CallAcquireStatus.REJECTED) break;
                stateMetrics.acquireOpenRejected.increment();
            }
        }
    }

    public void recordState(@Nonnull String name, @Nonnull CircuitBreaker.State newState) {
        StateMetrics stateMetrics = this.getCircuitBreakerMetrics(name, newState);
        stateMetrics.stateValue().set(this.asIntState(newState));
        if (newState == CircuitBreaker.State.OPEN) {
            stateMetrics.transitionOpen().increment();
        } else if (newState == CircuitBreaker.State.HALF_OPEN) {
            stateMetrics.transitionHalfOpen().increment();
        }
    }

    private StateMetrics getCircuitBreakerMetrics(@Nonnull String name, @Nonnull CircuitBreaker.State initiaState) {
        return this.metrics.computeIfAbsent(name, k -> {
            AtomicInteger gaugeState = new AtomicInteger(this.asIntState(initiaState));
            Gauge state = Gauge.builder((String)"resilient.circuitbreaker.state", gaugeState::get).tag("name", name).description("Circuit Breaker state metrics, where 0 -> CLOSED, 1 -> HALF_OPEN, 2 -> OPEN").register(this.registry);
            Counter transOpen = Counter.builder((String)"resilient.circuitbreaker.transition").baseUnit("operations").tag("name", name).tag("state", CircuitBreaker.State.OPEN.name()).register(this.registry);
            Counter transHalfOpen = Counter.builder((String)"resilient.circuitbreaker.transition").baseUnit("operations").tag("name", name).tag("state", CircuitBreaker.State.HALF_OPEN.name()).register(this.registry);
            Counter acquireHalfOpenPermitted = Counter.builder((String)"resilient.circuitbreaker.call.acquire").baseUnit("operations").tag("name", name).tag("state", CircuitBreaker.State.HALF_OPEN.name()).tag("status", CircuitBreakerMetrics.CallAcquireStatus.PERMITTED.name()).register(this.registry);
            Counter acquireHalfOpenRejected = Counter.builder((String)"resilient.circuitbreaker.call.acquire").baseUnit("operations").tag("name", name).tag("state", CircuitBreaker.State.HALF_OPEN.name()).tag("status", CircuitBreakerMetrics.CallAcquireStatus.REJECTED.name()).register(this.registry);
            Counter acquireOpenRejected = Counter.builder((String)"resilient.circuitbreaker.call.acquire").baseUnit("operations").tag("name", name).tag("state", CircuitBreaker.State.OPEN.name()).tag("status", CircuitBreakerMetrics.CallAcquireStatus.REJECTED.name()).register(this.registry);
            return new StateMetrics(gaugeState, state, transOpen, transHalfOpen, acquireHalfOpenPermitted, acquireHalfOpenRejected, acquireOpenRejected);
        });
    }

    private int asIntState(CircuitBreaker.State state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case CircuitBreaker.State.CLOSED -> 0;
            case CircuitBreaker.State.HALF_OPEN -> 1;
            case CircuitBreaker.State.OPEN -> 2;
        };
    }

    private record StateMetrics(AtomicInteger stateValue, Gauge state, Counter transitionOpen, Counter transitionHalfOpen, Counter acquireHalfOpenPermitted, Counter acquireHalfOpenRejected, Counter acquireOpenRejected) {
    }
}

