/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.resilient;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nonnull;
import java.util.concurrent.ConcurrentHashMap;
import ru.tinkoff.kora.resilient.fallback.FallbackMetrics;

public final class MicrometerFallbackMetrics
implements FallbackMetrics {
    private final ConcurrentHashMap<String, Metrics> metrics = new ConcurrentHashMap();
    private final MeterRegistry registry;

    public MicrometerFallbackMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public void recordExecute(@Nonnull String name, @Nonnull Throwable throwable) {
        Metrics metrics = this.metrics.computeIfAbsent(name, k -> this.build(name));
        metrics.attempts().increment();
    }

    private Metrics build(String name) {
        Counter attempts = Counter.builder((String)"resilient.fallback.attempts").baseUnit("operations").tag("type", "executed").tag("name", name).register(this.registry);
        return new Metrics(attempts);
    }

    private record Metrics(Counter attempts) {
    }
}

