/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.resilient;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nonnull;
import java.util.concurrent.ConcurrentHashMap;
import ru.tinkoff.kora.resilient.retry.RetryMetrics;

public final class MicrometerRetryMetrics
implements RetryMetrics {
    private final ConcurrentHashMap<String, Metrics> metrics = new ConcurrentHashMap();
    private final MeterRegistry registry;

    public MicrometerRetryMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public void recordAttempt(@Nonnull String name, long delayInNanos) {
        Metrics metrics = this.metrics.computeIfAbsent(name, k -> this.build(name));
        metrics.attempts().increment();
    }

    public void recordExhaustedAttempts(@Nonnull String name, int totalAttempts) {
        Metrics metrics = this.metrics.computeIfAbsent(name, k -> this.build(name));
        metrics.exhausted().increment();
    }

    private Metrics build(String name) {
        Counter attempts = Counter.builder((String)"resilient.retry.attempts").baseUnit("operations").tag("name", name).register(this.registry);
        Counter exhausted = Counter.builder((String)"resilient.retry.exhausted").baseUnit("operations").tag("name", name).register(this.registry);
        return new Metrics(attempts, exhausted);
    }

    private record Metrics(Counter exhausted, Counter attempts) {
    }
}

