/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.micrometer.module.scheduling;

import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nullable;
import java.util.Objects;
import ru.tinkoff.kora.micrometer.module.MetricsConfig;
import ru.tinkoff.kora.micrometer.module.scheduling.Opentelemetry120SchedulingMetrics;
import ru.tinkoff.kora.micrometer.module.scheduling.Opentelemetry123SchedulingMetrics;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingMetrics;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingMetricsFactory;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public class MicrometerSchedulingMetricsFactory
implements SchedulingMetricsFactory {
    private final MetricsConfig metricsConfig;
    private final MeterRegistry meterRegistry;

    public MicrometerSchedulingMetricsFactory(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
        this.meterRegistry = meterRegistry;
    }

    @Nullable
    public SchedulingMetrics get(TelemetryConfig.MetricsConfig config, Class<?> jobClass, String jobMethod) {
        if (Objects.requireNonNullElse(config.enabled(), true).booleanValue()) {
            return switch (this.metricsConfig.opentelemetrySpec()) {
                default -> throw new IncompatibleClassChangeError();
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V120 -> new Opentelemetry120SchedulingMetrics(this.meterRegistry, config, jobClass.getCanonicalName(), jobMethod);
                case TelemetryConfig.MetricsConfig.OpentelemetrySpec.V123 -> new Opentelemetry123SchedulingMetrics(this.meterRegistry, config, jobClass.getCanonicalName(), jobMethod);
            };
        }
        return null;
    }
}

