/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.openapi.generator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import io.swagger.v3.parser.util.SchemaTypeUtil;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenMediaType;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.IJsonSchemaValidationProperties;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KoraCodegen
extends DefaultCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(KoraCodegen.class);
    public static final String CODEGEN_MODE = "mode";
    public static final String JSON_ANNOTATION = "jsonAnnotation";
    public static final String ENABLE_VALIDATION = "enableServerValidation";
    public static final String OBJECT_TYPE = "objectType";
    public static final String DISABLE_HTML_ESCAPING = "disableHtmlEscaping";
    public static final String IGNORE_ANYOF_IN_ENUM = "ignoreAnyOfInEnum";
    public static final String ADDITIONAL_MODEL_TYPE_ANNOTATIONS = "additionalModelTypeAnnotations";
    public static final String ADDITIONAL_ENUM_TYPE_ANNOTATIONS = "additionalEnumTypeAnnotations";
    public static final String DISCRIMINATOR_CASE_SENSITIVE = "discriminatorCaseSensitive";
    public static final String PRIMARY_AUTH = "primaryAuth";
    public static final String CLIENT_CONFIG_PREFIX = "clientConfigPrefix";
    public static final String SECURITY_CONFIG_PREFIX = "securityConfigPrefix";
    public static final String CLIENT_TAGS = "tags";
    public static final String REQUEST_DELEGATE_PARAMS = "requestInDelegateParams";
    public static final String INTERCEPTORS = "interceptors";
    public static final String ADDITIONAL_CONTRACT_ANNOTATIONS = "additionalContractAnnotations";
    public static final String AUTH_AS_METHOD_ARGUMENT = "authAsMethodArgument";
    public static final String ENABLE_JSON_NULLABLE = "enableJsonNullable";
    protected String invokerPackage = "org.openapitools";
    protected boolean fullJavaUtil;
    protected boolean discriminatorCaseSensitive = true;
    protected boolean disableHtmlEscaping = false;
    protected String booleanGetterPrefix = "get";
    protected boolean ignoreAnyOfInEnum = false;
    private String objectType = "java.lang.Object";
    protected List<String> additionalModelTypeAnnotations = new LinkedList<String>();
    protected List<String> additionalEnumTypeAnnotations = new LinkedList<String>();
    private CodegenParams params;

    public String getName() {
        return "kora";
    }

    public KoraCodegen() {
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.invokerPackage = "org.openapitools.api";
        this.modifyFeatureSet(features -> features.wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.OAuth2_AuthorizationCode)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.supportsInheritance = true;
        this.hideGenerationTimestamp = true;
        this.setReservedWordsLowerCase(Arrays.asList("object", "error", "localVarPath", "localVarQueryParams", "localVarCollectionQueryParams", "localVarHeaderParams", "localVarCookieParams", "localVarFormParams", "localVarPostBody", "localVarAccepts", "localVarAccept", "localVarContentTypes", "localVarContentType", "localVarAuthNames", "localReturnType", "abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null"));
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("set", "LinkedHashSet");
        this.instantiationTypes.put("map", "HashMap");
        this.typeMapping.put("date", "java.time.LocalDate");
        this.typeMapping.put("time", "java.time.OffsetTime");
        this.typeMapping.put("duration", "java.time.Duration");
        this.typeMapping.put("DateTime", "java.time.OffsetDateTime");
        this.typeMapping.put("UUID", "java.util.UUID");
        this.typeMapping.put("URI", "java.net.URI");
        this.typeMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("URI", "java.net.URI");
        this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        this.importMapping.put("Map", "java.util.Map");
        this.importMapping.put("Array", "java.util.List");
        this.importMapping.put("HashMap", "java.util.HashMap");
        this.importMapping.put("ArrayList", "java.util.ArrayList");
        this.importMapping.put("List", "java.util.*");
        this.importMapping.put("Set", "java.util.*");
        this.importMapping.put("LinkedHashSet", "java.util.LinkedHashSet");
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(CliOption.newBoolean((String)DISABLE_HTML_ESCAPING, (String)"Disable HTML escaping of JSON strings when using gson (needed to avoid problems with byte[] fields)", (boolean)this.disableHtmlEscaping));
        this.cliOptions.add(CliOption.newBoolean((String)IGNORE_ANYOF_IN_ENUM, (String)"Ignore anyOf keyword in enum", (boolean)this.ignoreAnyOfInEnum));
        this.cliOptions.add(CliOption.newString((String)ADDITIONAL_MODEL_TYPE_ANNOTATIONS, (String)"Additional annotations for model type(class level annotations)"));
        this.cliOptions.add(CliOption.newString((String)ADDITIONAL_ENUM_TYPE_ANNOTATIONS, (String)"Additional annotations for enum type(class level annotations)"));
        this.cliOptions.addAll(CodegenParams.cliOptions());
    }

    public void processOpts() {
        String additionalAnnotationsList;
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("JAVA_POST_PROCESS_FILE"))) {
            LOGGER.info("Environment variable JAVA_POST_PROCESS_FILE not defined so the Java code may not be properly formatted. To define it, try 'export JAVA_POST_PROCESS_FILE=\"/usr/local/bin/clang-format -i\"' (Linux/Mac)");
            LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(OBJECT_TYPE)) {
            this.objectType = this.additionalProperties.get(OBJECT_TYPE).toString();
        }
        this.params = CodegenParams.parse(this.additionalProperties);
        this.params.processAdditionalProperties(this.additionalProperties);
        switch (this.params.codegenMode) {
            case JAVA_CLIENT: {
                this.modelTemplateFiles.put("javaModel.mustache", ".java");
                this.apiTemplateFiles.put("javaClientApi.mustache", ".java");
                this.apiTemplateFiles.put("javaApiResponses.mustache", "Responses.java");
                this.apiTemplateFiles.put("javaClientResponseMappers.mustache", "ClientResponseMappers.java");
                this.apiTemplateFiles.put("javaClientRequestMappers.mustache", "ClientRequestMappers.java");
                break;
            }
            case JAVA_ASYNC_CLIENT: 
            case JAVA_REACTIVE_CLIENT: {
                this.modelTemplateFiles.put("javaModel.mustache", ".java");
                this.apiTemplateFiles.put("javaClientApi.mustache", ".java");
                this.apiTemplateFiles.put("javaApiResponses.mustache", "Responses.java");
                this.apiTemplateFiles.put("javaClientAsyncResponseMappers.mustache", "ClientResponseMappers.java");
                this.apiTemplateFiles.put("javaClientRequestMappers.mustache", "ClientRequestMappers.java");
                break;
            }
            case JAVA_SERVER: {
                this.apiTemplateFiles.put("javaServerApi.mustache", "Controller.java");
                this.apiTemplateFiles.put("javaServerApiDelegate.mustache", "Delegate.java");
                this.apiTemplateFiles.put("javaApiResponses.mustache", "Responses.java");
                this.apiTemplateFiles.put("javaServerRequestMappers.mustache", "ServerRequestMappers.java");
                this.apiTemplateFiles.put("javaServerResponseMappers.mustache", "ServerResponseMappers.java");
                this.modelTemplateFiles.put("javaModel.mustache", ".java");
                break;
            }
            case JAVA_ASYNC_SERVER: 
            case JAVA_REACTIVE_SERVER: {
                this.apiTemplateFiles.put("javaAsyncServerApi.mustache", "Controller.java");
                this.apiTemplateFiles.put("javaAsyncServerApiDelegate.mustache", "Delegate.java");
                this.apiTemplateFiles.put("javaApiResponses.mustache", "Responses.java");
                this.apiTemplateFiles.put("javaServerRequestMappers.mustache", "ServerRequestMappers.java");
                this.apiTemplateFiles.put("javaServerResponseMappers.mustache", "ServerResponseMappers.java");
                this.modelTemplateFiles.put("javaModel.mustache", ".java");
                break;
            }
            case KOTLIN_CLIENT: 
            case KOTLIN_SUSPEND_CLIENT: {
                this.modelTemplateFiles.put("kotlinModel.mustache", ".kt");
                this.apiTemplateFiles.put("kotlinClientApi.mustache", ".kt");
                this.apiTemplateFiles.put("kotlinApiResponses.mustache", "Responses.kt");
                if (this.params.codegenMode == Mode.KOTLIN_SUSPEND_CLIENT) {
                    this.apiTemplateFiles.put("kotlinClientAsyncResponseMappers.mustache", "ClientResponseMappers.kt");
                } else {
                    this.apiTemplateFiles.put("kotlinClientResponseMappers.mustache", "ClientResponseMappers.kt");
                }
                this.apiTemplateFiles.put("kotlinClientRequestMappers.mustache", "ClientRequestMappers.kt");
                break;
            }
            case KOTLIN_SERVER: 
            case KOTLIN_SUSPEND_SERVER: {
                this.modelTemplateFiles.put("kotlinModel.mustache", ".kt");
                this.apiTemplateFiles.put("kotlinServerApi.mustache", "Controller.kt");
                this.apiTemplateFiles.put("kotlinServerApiDelegate.mustache", "Delegate.kt");
                this.apiTemplateFiles.put("kotlinApiResponses.mustache", "Responses.kt");
                this.apiTemplateFiles.put("kotlinServerRequestMappers.mustache", "ServerRequestMappers.kt");
                this.apiTemplateFiles.put("kotlinServerResponseMappers.mustache", "ServerResponseMappers.kt");
            }
        }
        this.vendorExtensions.put("allowAspects", this.params.enableValidation() || !this.params.additionalContractAnnotations.isEmpty());
        this.templateDir = "openapi/templates/kora";
        this.embeddedTemplateDir = "openapi/templates/kora";
        if (!this.params.codegenMode.isJava()) {
            this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("ByteArray", "String", "boolean", "Boolean", "Double", "Int", "Long", "Float", "Object"));
            this.typeMapping.put("file", "ByteArray");
            if (this.additionalProperties.containsKey(OBJECT_TYPE)) {
                this.typeMapping.put("AnyType", this.objectType);
                this.typeMapping.put("object", this.objectType);
            } else {
                this.typeMapping.put("AnyType", "kotlin.Any");
                this.typeMapping.put("object", "kotlin.Any");
            }
            this.typeMapping.put("array", "List");
            this.typeMapping.put("set", "Set");
            this.typeMapping.put("map", "Map");
            this.typeMapping.put("int", "Int");
            this.typeMapping.put("integer", "Int");
            this.typeMapping.put("ByteArray", "ByteArray");
        } else {
            this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "double", "Double", "int", "Integer", "long", "Long", "float", "Float", "Object", "byte[]"));
            this.typeMapping.put("AnyType", this.objectType);
            this.typeMapping.put("object", this.objectType);
            this.typeMapping.put("array", "java.util.List");
            this.typeMapping.put("set", "java.util.Set");
            this.typeMapping.put("map", "java.util.Map");
            this.typeMapping.put("file", "byte[]");
        }
        if (this.additionalProperties.containsKey(DISABLE_HTML_ESCAPING)) {
            this.setDisableHtmlEscaping(Boolean.parseBoolean(this.additionalProperties.get(DISABLE_HTML_ESCAPING).toString()));
        }
        this.additionalProperties.put(DISABLE_HTML_ESCAPING, this.disableHtmlEscaping);
        if (this.additionalProperties.containsKey(IGNORE_ANYOF_IN_ENUM)) {
            this.setIgnoreAnyOfInEnum(Boolean.parseBoolean(this.additionalProperties.get(IGNORE_ANYOF_IN_ENUM).toString()));
        }
        this.additionalProperties.put(IGNORE_ANYOF_IN_ENUM, this.ignoreAnyOfInEnum);
        if (this.additionalProperties.containsKey(ADDITIONAL_MODEL_TYPE_ANNOTATIONS)) {
            additionalAnnotationsList = this.additionalProperties.get(ADDITIONAL_MODEL_TYPE_ANNOTATIONS).toString();
            this.setAdditionalModelTypeAnnotations(Arrays.asList(additionalAnnotationsList.split(";")));
        }
        if (this.additionalProperties.containsKey(ADDITIONAL_ENUM_TYPE_ANNOTATIONS)) {
            additionalAnnotationsList = this.additionalProperties.get(ADDITIONAL_ENUM_TYPE_ANNOTATIONS).toString();
            this.setAdditionalEnumTypeAnnotations(Arrays.asList(additionalAnnotationsList.split(";")));
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            derivedInvokerPackage = this.deriveInvokerPackageName((String)this.additionalProperties.get("apiPackage"));
            this.additionalProperties.put("invokerPackage", derivedInvokerPackage);
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            LOGGER.info("Invoker Package Name, originally not set, is now derived from api package name: {}", (Object)derivedInvokerPackage);
        } else if (this.additionalProperties.containsKey("modelPackage")) {
            derivedInvokerPackage = this.deriveInvokerPackageName((String)this.additionalProperties.get("modelPackage"));
            this.additionalProperties.put("invokerPackage", derivedInvokerPackage);
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            LOGGER.info("Invoker Package Name, originally not set, is now derived from model package name: {}", (Object)derivedInvokerPackage);
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (!this.additionalProperties.containsKey("modelPackage")) {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        if (!this.additionalProperties.containsKey("apiPackage")) {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (this.additionalProperties.containsKey(DISCRIMINATOR_CASE_SENSITIVE)) {
            this.setDiscriminatorCaseSensitive(Boolean.parseBoolean(this.additionalProperties.get(DISCRIMINATOR_CASE_SENSITIVE).toString()));
        } else {
            this.setDiscriminatorCaseSensitive(Boolean.TRUE);
        }
        this.additionalProperties.put(DISCRIMINATOR_CASE_SENSITIVE, this.discriminatorCaseSensitive);
        this.importMapping.put("List", "java.util.List");
        this.importMapping.put("Set", "java.util.Set");
        this.sanitizeConfig();
        this.importMapping.put("Arrays", "java.util.Arrays");
        this.importMapping.put("Objects", "java.util.Objects");
    }

    public Map<String, ModelsMap> updateAllModels(Map<String, ModelsMap> objs) {
        objs = super.updateAllModels(objs);
        Map allModels = this.getAllModels(objs);
        for (CodegenModel model : allModels.values()) {
            CodegenModel variableModelField;
            model.vendorExtensions.put("x-enable-validation", this.params.enableValidation);
            for (CodegenProperty variable : model.allVars) {
                if (this.params.enableValidation) {
                    if (variable.getRef() != null && (variableModelField = (CodegenModel)allModels.get(variable.openApiType)) != null) {
                        variable.vendorExtensions.put("x-has-valid-model", true);
                    }
                    this.visitVariableValidation(variable, variable.openApiType, variable.dataFormat, variable.vendorExtensions);
                }
                if (!variable.isNullable || variable.required) continue;
                if (this.params.enableJsonNullable) {
                    variable.vendorExtensions.put("x-json-nullable", true);
                    continue;
                }
                variable.vendorExtensions.put("x-json-include-always", true);
                LOGGER.warn("Detected isNullable and NonRequired field: {}#{}\nYou may want add option '{}' in configOptions to treat it as JsonNullable<T>, this will be default behavior in 2.0", new Object[]{model.name, variable.name, ENABLE_JSON_NULLABLE});
            }
            for (CodegenProperty variable : model.optionalVars) {
                if (this.params.enableValidation) {
                    if (variable.getRef() != null && (variableModelField = (CodegenModel)allModels.get(variable.openApiType)) != null) {
                        variable.vendorExtensions.put("x-has-valid-model", true);
                    }
                    this.visitVariableValidation(variable, variable.openApiType, variable.dataFormat, variable.vendorExtensions);
                }
                if (!variable.isNullable || variable.required) continue;
                if (this.params.enableJsonNullable) {
                    variable.vendorExtensions.put("x-json-nullable", true);
                    continue;
                }
                variable.vendorExtensions.put("x-json-include-always", true);
                LOGGER.warn("Detected isNullable and NonRequired field: {}#{}\nYou may want add option '{}' in configOptions to treat it as JsonNullable<T>, this will be default behavior in 2.0", new Object[]{model.name, variable.name, ENABLE_JSON_NULLABLE});
            }
            if (model.discriminator != null) {
                Map<String, List> map = model.discriminator.getMappedModels().stream().collect(Collectors.toMap(CodegenDiscriminator.MappedModel::getModelName, m -> List.of(m.getMappingName()), (l1, l2) -> {
                    ArrayList l = new ArrayList(l1.size() + l2.size());
                    l.addAll(l1);
                    l.addAll(l2);
                    return l;
                }));
                Set uniqueMappedModels = model.discriminator.getMappedModels().stream().map(CodegenDiscriminator.MappedModel::getModelName).collect(Collectors.toSet());
                model.vendorExtensions.put("x-unique-mapped-models", uniqueMappedModels);
                model.discriminator.getVendorExtensions().put("x-unique-mapped-models", uniqueMappedModels);
                if (!model.discriminator.getVendorExtensions().containsKey("x-discriminator-property")) {
                    String propertyName = model.getDiscriminator().getPropertyName();
                    LinkedHashMap<String, CodegenProperty> propertyTypeToProp = new LinkedHashMap<String, CodegenProperty>();
                    Boolean allSameType = null;
                    for (CodegenDiscriminator.MappedModel mappedModel : model.discriminator.getMappedModels()) {
                        CodegenModel childModel = (CodegenModel)allModels.get(mappedModel.getModelName());
                        Optional<CodegenProperty> discrProp = childModel.allVars.stream().filter(p -> p.name.equals(propertyName)).findFirst();
                        if (allSameType == null) {
                            allSameType = discrProp.isPresent();
                        }
                        if (discrProp.isPresent()) {
                            propertyTypeToProp.computeIfAbsent(discrProp.get().dataType, k -> (CodegenProperty)discrProp.get());
                            continue;
                        }
                        if (!allSameType.booleanValue()) continue;
                        allSameType = false;
                    }
                    if (allSameType != null && allSameType.booleanValue() && propertyTypeToProp.size() == 1) {
                        if (model.allVars.stream().noneMatch(p -> !p.isDiscriminator && p.name.equals(model.discriminator.getPropertyName()))) {
                            CodegenProperty property = (CodegenProperty)propertyTypeToProp.values().iterator().next();
                            property.required = true;
                            property.isNullable = false;
                            model.discriminator.getVendorExtensions().put("x-discriminator-property", property);
                        }
                    } else if (propertyTypeToProp.isEmpty()) {
                        CodegenProperty p2 = this.getFakeCodegenPropertyString(model.discriminator.getPropertyBaseName());
                        model.discriminator.getVendorExtensions().put("x-discriminator-property", p2);
                        model.discriminator.getVendorExtensions().put("x-discriminator-property-all-empty", true);
                    }
                }
                for (CodegenDiscriminator.MappedModel mappedModel : model.discriminator.getMappedModels()) {
                    String[] stringArray;
                    CodegenModel childModel = (CodegenModel)allModels.get(mappedModel.getModelName());
                    childModel.parentModel = model;
                    childModel.parent = model.classname;
                    List mappings = map.get(mappedModel.getModelName());
                    if (mappings.size() == 1) {
                        property = childModel.allVars.stream().filter(prop -> org.apache.commons.lang3.StringUtils.equals((CharSequence)model.discriminator.getPropertyBaseName(), (CharSequence)prop.baseName)).findFirst();
                        property.ifPresent(p -> {
                            if (!p.required) {
                                p.setRequired(true);
                            }
                            p.isNullable = false;
                            childModel.vendorExtensions.put("x-discriminator-property", p);
                            if (p.isString) {
                                p.vendorExtensions.put("x-discriminator-property-value", "DISCRIMINATOR");
                            } else if (p.isEnum || p.isEnumRef || p.isInnerEnum) {
                                p.vendorExtensions.put("x-discriminator-property-value", p.dataType + "." + (String)mappings.get(0));
                            } else {
                                p.vendorExtensions.put("x-discriminator-property-value", p.dataType + ".valueOf(DISCRIMINATOR)");
                            }
                        });
                        if (property.isEmpty() && model.discriminator.getVendorExtensions().containsKey("x-discriminator-property-all-empty")) {
                            CodegenProperty p3 = this.getFakeCodegenPropertyString(model.discriminator.getPropertyBaseName());
                            childModel.vendorExtensions.put("x-discriminator-property", p3);
                            p3.vendorExtensions.put("x-discriminator-property-value", "DISCRIMINATOR");
                        }
                        childModel.vars.removeIf(prop -> org.apache.commons.lang3.StringUtils.equals((CharSequence)model.discriminator.getPropertyBaseName(), (CharSequence)prop.baseName));
                        childModel.allVars.removeIf(prop -> org.apache.commons.lang3.StringUtils.equals((CharSequence)model.discriminator.getPropertyBaseName(), (CharSequence)prop.baseName));
                        childModel.requiredVars.removeIf(prop -> org.apache.commons.lang3.StringUtils.equals((CharSequence)model.discriminator.getPropertyBaseName(), (CharSequence)prop.baseName));
                        childModel.optionalVars.removeIf(prop -> org.apache.commons.lang3.StringUtils.equals((CharSequence)model.discriminator.getPropertyBaseName(), (CharSequence)prop.baseName));
                        childModel.hasVars = !childModel.allVars.isEmpty();
                        childModel.emptyVars = childModel.allVars.isEmpty();
                    } else {
                        property = childModel.allVars.stream().filter(prop -> org.apache.commons.lang3.StringUtils.equals((CharSequence)model.discriminator.getPropertyBaseName(), (CharSequence)prop.baseName)).findFirst().orElseThrow(() -> new IllegalStateException("Discriminator must be described as property in schema: " + model.name));
                        property.isNullable = false;
                        property.setRequired(true);
                        childModel.setHasRequired(true);
                        childModel.requiredVars.removeIf(p -> Objects.equals(p.baseName, property.baseName));
                        childModel.optionalVars.removeIf(p -> Objects.equals(p.baseName, property.baseName));
                        childModel.requiredVars.add(property);
                        if (model.discriminator.getPropertyBaseName().equals(property.baseName)) {
                            property.isDiscriminator = true;
                        }
                        if (this.params.codegenMode().isKotlin()) {
                            childModel.vendorExtensions.put("x-discriminator-property", property);
                            property.vendorExtensions.put("x-discriminator-property-value", property.name);
                        }
                        StringBuilder sb = new StringBuilder().append("(");
                        for (int i = 0; i < mappings.size(); ++i) {
                            String mapping = (String)mappings.get(i);
                            if (i > 0) {
                                sb.append(" && ");
                            }
                            if (this.params.codegenMode.isJava()) {
                                sb.append("!String.valueOf(").append(property.name).append(").equals(\"").append(mapping).append("\")");
                                continue;
                            }
                            sb.append(property.name).append("?.toString() != \"").append(mapping).append("\"");
                        }
                        childModel.vendorExtensions.put("x-discriminator-values-check", sb.append(")").toString());
                        childModel.vendorExtensions.put("x-discriminator-constant", mappings.get(0));
                    }
                    if (this.params.codegenMode.isJava()) {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = "{\"";
                        stringArray = stringArray2;
                        stringArray2[1] = "\"}";
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = "[\"";
                        stringArray = stringArray3;
                        stringArray3[1] = "\"]";
                    }
                    String[] separators = stringArray;
                    String discriminatorValues = mappings.stream().collect(Collectors.joining("\", \"", separators[0], separators[1]));
                    childModel.vendorExtensions.put("x-discriminator-value", discriminatorValues);
                    if (mappings.size() == 1) {
                        childModel.vendorExtensions.put("x-discriminator-constant", "\"" + (String)mappings.get(0) + "\"");
                        String field = this.getUpperSnakeCase((String)mappings.get(0));
                        childModel.vendorExtensions.put("x-discriminator-constant-field", field);
                        continue;
                    }
                    String discriminatorConsts = mappings.stream().collect(Collectors.joining("\", \"", "\"", "\""));
                    childModel.vendorExtensions.put("x-discriminator-constants", discriminatorConsts);
                    childModel.vendorExtensions.remove("x-discriminator-constant");
                    List mappingValues = mappings.stream().map(m -> {
                        String fieldOld;
                        String field = this.getUpperSnakeCase((String)m);
                        if (field.equals(fieldOld = Arrays.stream(m.split("[^a-zA-Z0-9]")).map(String::strip).map(String::toUpperCase).collect(Collectors.joining("_")))) {
                            return Map.of("discriminatorField", field, "discriminatorValue", "\"" + m + "\"");
                        }
                        return Map.of("discriminatorField", field, "discriminatorFieldOld", fieldOld, "discriminatorValue", "\"" + m + "\"");
                    }).collect(Collectors.toList());
                    childModel.vendorExtensions.put("x-discriminator-constant-fields", mappingValues);
                }
            }
            if (!this.params.codegenMode.isJava()) continue;
            for (CodegenProperty requiredVar : model.allVars) {
                if (!requiredVar.required) continue;
                if (requiredVar.isInteger) {
                    requiredVar.dataType = "int";
                    requiredVar.datatypeWithEnum = "int";
                }
                if (requiredVar.isLong) {
                    requiredVar.dataType = "long";
                    requiredVar.datatypeWithEnum = "long";
                }
                if (requiredVar.isFloat) {
                    requiredVar.dataType = "float";
                    requiredVar.datatypeWithEnum = "float";
                }
                if (requiredVar.isDouble) {
                    requiredVar.dataType = "double";
                    requiredVar.datatypeWithEnum = "double";
                }
                if (!requiredVar.isBoolean) continue;
                requiredVar.dataType = "boolean";
                requiredVar.datatypeWithEnum = "boolean";
            }
        }
        return objs;
    }

    private String getUpperSnakeCase(String value) {
        return Arrays.stream(value.split("[^a-zA-Z0-9]")).map(String::strip).flatMap(s -> Arrays.stream(s.split("(?<=[a-z])(?=[A-Z])|(?<=[A-Z])(?=[A-Z][a-z])|( +)"))).map(String::strip).map(String::toUpperCase).collect(Collectors.joining("_"));
    }

    private <T extends IJsonSchemaValidationProperties> void visitVariableValidation(T variable, @Nullable String type, @Nullable String dataFormat, Map<String, Object> vendorExtensions) {
        dataFormat = Objects.requireNonNullElse(dataFormat, "");
        if (variable.getMinimum() != null || variable.getMaximum() != null) {
            vendorExtensions.put("x-has-min-max", true);
            if (variable.getMinimum() != null) {
                if (!variable.getMinimum().contains(".")) {
                    variable.setMinimum(variable.getMinimum() + ".0");
                }
            } else {
                block4 : switch (type) {
                    case "integer": {
                        switch (dataFormat) {
                            case "int64": 
                            case "": {
                                variable.setMinimum("-9223372036854775808.0");
                                break;
                            }
                            case "int32": {
                                variable.setMinimum("-2147483648.0");
                            }
                        }
                        break;
                    }
                    case "number": {
                        switch (dataFormat) {
                            case "double": 
                            case "": {
                                variable.setMinimum("Double.MIN_VALUE");
                                break block4;
                            }
                            case "float": {
                                variable.setMinimum("Float.MIN_VALUE");
                            }
                        }
                    }
                }
            }
            if (variable.getMaximum() != null) {
                if (!variable.getMaximum().contains(".")) {
                    variable.setMaximum(variable.getMaximum() + ".0");
                }
            } else {
                block30 : switch (type) {
                    case "integer": {
                        switch (dataFormat) {
                            case "int64": 
                            case "": {
                                variable.setMaximum("9223372036854775807.0");
                                break;
                            }
                            case "int32": {
                                variable.setMaximum("2147483647.0");
                            }
                        }
                        break;
                    }
                    case "number": {
                        switch (dataFormat) {
                            case "double": 
                            case "": {
                                variable.setMaximum("Double.MAX_VALUE");
                                break block30;
                            }
                            case "float": {
                                variable.setMaximum("Float.MAX_VALUE");
                            }
                        }
                    }
                }
            }
        }
        if (variable.getMinLength() != null || variable.getMaxLength() != null) {
            vendorExtensions.put("x-has-min-max-length", true);
            if (variable.getMinLength() == null) {
                variable.setMinLength(Integer.valueOf(0));
            }
            if (variable.getMaxLength() == null) {
                variable.setMaxLength(Integer.valueOf(Integer.MAX_VALUE));
            }
        }
        if (variable.getMaxItems() != null || variable.getMinItems() != null) {
            vendorExtensions.put("x-has-min-max-items", true);
            if (variable.getMinItems() == null) {
                variable.setMinItems(Integer.valueOf(0));
            }
            if (variable.getMaxItems() == null) {
                variable.setMaxItems(Integer.valueOf(Integer.MAX_VALUE));
            }
        }
        if (variable.getPattern() != null) {
            vendorExtensions.put("x-has-pattern", true);
        }
    }

    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map models;
        objs = super.postProcessAllModels(objs);
        objs = this.updateAllModels(objs);
        if (!this.additionalModelTypeAnnotations.isEmpty()) {
            for (String modelName : objs.keySet()) {
                models = (Map)objs.get(modelName);
                models.put(ADDITIONAL_MODEL_TYPE_ANNOTATIONS, this.additionalModelTypeAnnotations);
            }
        }
        if (!this.additionalEnumTypeAnnotations.isEmpty()) {
            for (String modelName : objs.keySet()) {
                models = (Map)objs.get(modelName);
                models.put(ADDITIONAL_ENUM_TYPE_ANNOTATIONS, this.additionalEnumTypeAnnotations);
            }
        }
        for (ModelsMap obj : objs.values()) {
            ModelsMap model = obj;
            List models2 = (List)model.get("models");
            CodegenModel codegenModel = (CodegenModel)((Map)models2.get(0)).get("model");
            boolean additionalConstructor = codegenModel.getHasVars() && !codegenModel.getVars().isEmpty() && !codegenModel.getAllVars().isEmpty() && codegenModel.getVars().size() != codegenModel.getRequiredVars().size();
            for (CodegenProperty requiredVar : codegenModel.requiredVars) {
                codegenModel.optionalVars.removeIf(p -> Objects.equals(p.name, requiredVar.name));
                if (codegenModel.parentModel == null || codegenModel.parentModel.discriminator == null || !Objects.equals(requiredVar.name, codegenModel.parentModel.discriminator.getPropertyName())) continue;
                requiredVar.isOverridden = false;
            }
            model.put("additionalConstructor", additionalConstructor);
        }
        return objs;
    }

    private void sanitizeConfig() {
        this.setApiPackage(KoraCodegen.sanitizePackageName(this.apiPackage));
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        this.setModelPackage(KoraCodegen.sanitizePackageName(this.modelPackage));
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        this.setInvokerPackage(KoraCodegen.sanitizePackageName(this.invokerPackage));
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
    }

    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return (String)this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    public String apiFileFolder() {
        return (this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    public String apiTestFileFolder() {
        return (this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    public String modelTestFileFolder() {
        return (this.outputFolder + File.separator + this.modelPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    public String modelFileFolder() {
        return (this.outputFolder + File.separator + this.modelPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    public String apiDocFileFolder() {
        return this.outputFolder.replace('/', File.separatorChar);
    }

    public String modelDocFileFolder() {
        return this.outputFolder.replace('/', File.separatorChar);
    }

    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Test";
    }

    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    public String toVarName(String name) {
        if (((String)(name = this.sanitizeName((String)name, "\\W-[\\$]"))).toLowerCase(Locale.ROOT).matches("^_*class$")) {
            return "propertyClass";
        }
        if ("_".equals(name)) {
            name = "_u";
        }
        if (((String)name).matches("^\\d.*")) {
            name = "_" + (String)name;
        }
        if (((String)name).matches("^[A-Z0-9_]*$")) {
            return name;
        }
        if (this.startsWithTwoUppercaseLetters((String)name)) {
            name = ((String)name).substring(0, 2).toLowerCase(Locale.ROOT) + ((String)name).substring(2);
        }
        if (((String)name).chars().anyMatch(character -> this.specialCharReplacements.keySet().contains("" + (char)character))) {
            ArrayList<String> allowedCharacters = new ArrayList<String>();
            allowedCharacters.add("_");
            allowedCharacters.add("$");
            name = StringUtils.escape((String)name, (Map)this.specialCharReplacements, allowedCharacters, (String)"_");
        }
        if (this.isReservedWord((String)(name = StringUtils.camelize((String)name, (CamelizeOption)CamelizeOption.LOWERCASE_FIRST_CHAR))) || ((String)name).matches("^\\d.*")) {
            name = this.escapeReservedWord((String)name);
        }
        return name;
    }

    private boolean startsWithTwoUppercaseLetters(String name) {
        boolean startsWithTwoUppercaseLetters = false;
        if (name.length() > 1) {
            startsWithTwoUppercaseLetters = name.substring(0, 2).equals(name.substring(0, 2).toUpperCase(Locale.ROOT));
        }
        return startsWithTwoUppercaseLetters;
    }

    public String toParamName(String name) {
        if ("callback".equals(name)) {
            return "paramCallback";
        }
        return this.toVarName(name);
    }

    public String toModelName(String name) {
        String camelizedName;
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        Object nameWithPrefixSuffix = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + (String)nameWithPrefixSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = (String)nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(camelizedName = StringUtils.camelize((String)nameWithPrefixSuffix))) {
            String modelName = "Model" + camelizedName;
            return modelName;
        }
        if (camelizedName.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            return modelName;
        }
        return camelizedName;
    }

    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    public String getTypeDeclaration(Schema p) {
        Schema target;
        Schema schema = ModelUtils.unaliasSchema((OpenAPI)this.openAPI, (Schema)p, (Map)this.importMapping);
        Schema schema2 = target = ModelUtils.isGenerateAliasAsModel() ? p : schema;
        if (ModelUtils.isArraySchema((Schema)target)) {
            Schema items = this.getSchemaItems((ArraySchema)schema);
            return this.getSchemaType(target) + "<" + this.getTypeDeclaration(items) + ">";
        }
        if (ModelUtils.isMapSchema((Schema)target)) {
            Schema inner = ModelUtils.getAdditionalProperties((Schema)target);
            if (inner == null) {
                LOGGER.error("`{}` (map property) does not have a proper inner type defined. Default to type:string", (Object)p.getName());
                inner = new StringSchema().description("TODO default missing map inner type to string");
                p.setAdditionalProperties((Object)inner);
            }
            return this.getSchemaType(target) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(target);
    }

    public String getAlias(String name) {
        if (this.typeAliases != null && this.typeAliases.containsKey(name)) {
            return (String)this.typeAliases.get(name);
        }
        return name;
    }

    public String toDefaultValue(Schema originalSchema) {
        Schema schema = ModelUtils.getReferencedSchema((OpenAPI)this.openAPI, (Schema)originalSchema);
        Object defaultValue = schema.getDefault();
        return this.toDefaultSchemaValue(originalSchema, schema, defaultValue);
    }

    private String toDefaultSchemaValue(Schema originalSchema, Schema schema, Object defaultValue) {
        if (ModelUtils.isArraySchema((Schema)schema)) {
            Boolean java8;
            Object def = defaultValue;
            if (!(def instanceof ArrayNode)) {
                return null;
            }
            ArrayNode an = (ArrayNode)def;
            String pattern = ModelUtils.isSet((Schema)schema) ? (this.params.codegenMode.isKotlin() ? "kotlin.collections.setOf<%s>(" : "java.util.Set.<%s>of(") : (this.params.codegenMode.isKotlin() ? "kotlin.collections.listOf<%s>(" : "java.util.List.<%s>of(");
            Schema itemOriginal = this.getSchemaItems((ArraySchema)schema);
            Schema itemSchema = ModelUtils.getReferencedSchema((OpenAPI)this.openAPI, (Schema)itemOriginal);
            String typeDeclaration = this.getTypeDeclaration(ModelUtils.unaliasSchema((OpenAPI)this.openAPI, (Schema)itemOriginal));
            Object java8obj = this.additionalProperties.get("java8");
            if (java8obj != null && (java8 = Boolean.valueOf(java8obj.toString())) != null && java8.booleanValue()) {
                typeDeclaration = "";
            }
            StringBuilder builder = new StringBuilder(String.format(Locale.ROOT, pattern, typeDeclaration));
            int items = 0;
            int i = 1;
            for (JsonNode node : an) {
                String itemValue = this.toDefaultSchemaValue(itemOriginal, itemSchema, node.asText());
                if (itemValue == null) continue;
                builder.append(itemValue);
                ++items;
                if (i == an.size()) continue;
                builder.append(", ");
                ++i;
            }
            if (items == 0) {
                return null;
            }
            return builder.append(")").toString();
        }
        if (ModelUtils.isMapSchema((Schema)schema) && !(schema instanceof ComposedSchema)) {
            Boolean java8;
            if (defaultValue == null) {
                return null;
            }
            if (schema.getProperties() != null && schema.getProperties().size() > 0) {
                if (defaultValue != null) {
                    return super.toDefaultValue(schema);
                }
                return null;
            }
            String mapInstantiationType = this.instantiationTypes().getOrDefault("map", "HashMap");
            String pattern = "new " + mapInstantiationType + "<%s>()";
            Schema schemaProperties = ModelUtils.getAdditionalProperties((Schema)schema);
            if (schemaProperties == null) {
                return null;
            }
            String typeDeclaration = String.format(Locale.ROOT, "String, %s", this.getTypeDeclaration(schemaProperties));
            Object java8obj = this.additionalProperties.get("java8");
            if (java8obj != null && (java8 = Boolean.valueOf(java8obj.toString())) != null && java8.booleanValue()) {
                typeDeclaration = "";
            }
            return String.format(Locale.ROOT, pattern, typeDeclaration);
        }
        if (ModelUtils.isIntegerSchema((Schema)schema)) {
            if (defaultValue != null) {
                if ("int64".equals(schema.getFormat())) {
                    return defaultValue + "L";
                }
                return defaultValue.toString();
            }
            return null;
        }
        if (ModelUtils.isNumberSchema((Schema)schema)) {
            if (defaultValue != null) {
                if ("float".equals(schema.getFormat())) {
                    return defaultValue + "f";
                }
                if ("double".equals(schema.getFormat())) {
                    return this.params.codegenMode.isKotlin() ? defaultValue.toString() : defaultValue + "d";
                }
                return this.params.codegenMode.isKotlin() ? "BigDecimal(\"" + defaultValue + "\")" : "new BigDecimal(\"" + defaultValue + "\")";
            }
            return null;
        }
        if (ModelUtils.isBooleanSchema((Schema)schema)) {
            if (defaultValue != null) {
                return defaultValue.toString();
            }
            return null;
        }
        if (ModelUtils.isURISchema((Schema)schema)) {
            if (defaultValue != null) {
                String uriValue = this.escapeText((String)defaultValue);
                return "java.net.URI.create(\"" + uriValue + "\")";
            }
            return null;
        }
        if (ModelUtils.isStringSchema((Schema)schema)) {
            if (defaultValue != null) {
                String _default;
                if (defaultValue instanceof Date) {
                    Date date = (Date)defaultValue;
                    String dateDef = LocalDate.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_DATE);
                    return "java.time.LocalDate.parse(\"" + dateDef + "\", java.time.format.DateTimeFormatter.ISO_DATE)";
                }
                if (ModelUtils.isDateSchema((Schema)schema) && defaultValue instanceof String) {
                    String ds = (String)defaultValue;
                    return "java.time.LocalDate.parse(\"" + ds + "\", java.time.format.DateTimeFormatter.ISO_DATE)";
                }
                if (ModelUtils.isDateSchema((Schema)schema) && defaultValue instanceof Number) {
                    Number dn = (Number)defaultValue;
                    return "java.time.LocalDate.ofInstant(java.time.Instant.ofEpochMilli(" + dn.longValue() + "L), java.time.ZoneId.systemDefault())";
                }
                if (defaultValue instanceof OffsetDateTime || ModelUtils.isDateTimeSchema((Schema)schema)) {
                    String def;
                    if (defaultValue instanceof OffsetDateTime) {
                        OffsetDateTime offsetDateTime = (OffsetDateTime)defaultValue;
                        String dateTimeValue = String.format(Locale.ROOT, offsetDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME), "");
                        def = "java.time.OffsetDateTime.parse(\"" + dateTimeValue + "\", java.time.format.DateTimeFormatter.ISO_OFFSET_DATE_TIME)";
                    } else if (defaultValue instanceof String) {
                        String ds = (String)defaultValue;
                        def = "java.time.OffsetDateTime.parse(\"" + ds + "\", java.time.format.DateTimeFormatter.ISO_OFFSET_DATE_TIME)";
                    } else if (defaultValue instanceof Number) {
                        Number dn = (Number)defaultValue;
                        def = "java.time.OffsetDateTime.ofInstant(java.time.Instant.ofEpochMilli(" + dn.longValue() + "L), java.time.ZoneId.systemDefault())";
                    } else {
                        return null;
                    }
                    String dateTimeFormat = this.typeMapping.getOrDefault("date-time", (String)this.typeMapping.get("DateTime"));
                    if (OffsetDateTime.class.getCanonicalName().equals(dateTimeFormat) || OffsetDateTime.class.getSimpleName().equals(dateTimeFormat)) {
                        return def;
                    }
                    if (Instant.class.getCanonicalName().equals(dateTimeFormat) || Instant.class.getSimpleName().equals(dateTimeFormat)) {
                        return def + ".toInstant()";
                    }
                    if (ZonedDateTime.class.getCanonicalName().equals(dateTimeFormat) || ZonedDateTime.class.getSimpleName().equals(dateTimeFormat)) {
                        return def + ".toZonedDateTime()";
                    }
                    if (LocalDateTime.class.getCanonicalName().equals(dateTimeFormat) || LocalDateTime.class.getSimpleName().equals(dateTimeFormat)) {
                        return def + ".toLocalDateTime()";
                    }
                    return null;
                }
                if (defaultValue instanceof byte[]) {
                    byte[] vb = (byte[])defaultValue;
                    _default = new String(vb);
                } else {
                    _default = (String)defaultValue;
                }
                if (schema.getEnum() == null) {
                    return "\"" + this.escapeText(_default) + "\"";
                }
                if (originalSchema == schema) {
                    return "\"" + this.escapeText(_default) + "\"";
                }
                return this.toModelName(ModelUtils.getSimpleRef((String)originalSchema.get$ref())) + "." + this.toEnumVarName(_default, schema.getType());
            }
            return null;
        }
        if (ModelUtils.isObjectSchema((Schema)schema)) {
            if (defaultValue != null) {
                return super.toDefaultValue(schema);
            }
            return null;
        }
        if (ModelUtils.isComposedSchema((Schema)schema)) {
            if (defaultValue != null) {
                return super.toDefaultValue(schema);
            }
            return null;
        }
        return super.toDefaultValue(schema);
    }

    public String toDefaultParameterValue(Schema<?> schema) {
        Object defaultValue = schema.getDefault();
        if (defaultValue == null) {
            return null;
        }
        return this.toDefaultValue(schema);
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        Schema schema;
        Example example;
        if (parameter.getExample() != null) {
            codegenParameter.example = parameter.getExample().toString();
        }
        if (parameter.getExamples() != null && !parameter.getExamples().isEmpty() && (example = (Example)parameter.getExamples().values().iterator().next()).getValue() != null) {
            codegenParameter.example = example.getValue().toString();
        }
        if ((schema = parameter.getSchema()) != null && schema.getExample() != null) {
            codegenParameter.example = schema.getExample().toString();
        }
        this.setParameterExampleValue(codegenParameter);
    }

    public void setParameterExampleValue(CodegenParameter codegenParameter, RequestBody requestBody) {
        Example example;
        MediaType mediaType;
        boolean isModel = codegenParameter.isModel || codegenParameter.isContainer && codegenParameter.getItems().isModel;
        Content content = requestBody.getContent();
        if (content.size() > 1) {
            LOGGER.warn("Multiple MediaTypes found, using only the first one");
        }
        if ((mediaType = (MediaType)content.values().iterator().next()).getExample() != null) {
            if (isModel) {
                LOGGER.warn("Ignoring complex example on request body");
            } else {
                codegenParameter.example = mediaType.getExample().toString();
                return;
            }
        }
        if (mediaType.getExamples() != null && !mediaType.getExamples().isEmpty() && (example = (Example)mediaType.getExamples().values().iterator().next()).getValue() != null) {
            if (isModel) {
                LOGGER.warn("Ignoring complex example on request body");
            } else {
                codegenParameter.example = example.getValue().toString();
                return;
            }
        }
        this.setParameterExampleValue(codegenParameter);
    }

    public void setParameterExampleValue(CodegenParameter p) {
        Object example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equals(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "\"" + this.escapeText((String)example) + "\"";
        } else if ("Integer".equals(type) || "Short".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Long".equals(type)) {
            if (example == null) {
                example = "56";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"L", (CharSequence[])new CharSequence[0]);
        } else if ("Float".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"F", (CharSequence[])new CharSequence[0]);
        } else if ("Double".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"D", (CharSequence[])new CharSequence[0]);
        } else if ("Boolean".equals(type)) {
            if (example == null) {
                example = "true";
            }
        } else if ("File".equals(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "new File(\"" + this.escapeText((String)example) + "\")";
        } else if ("Date".equals(type)) {
            example = "new Date()";
        } else if ("OffsetDateTime".equals(type)) {
            example = "OffsetDateTime.now()";
        } else if ("BigDecimal".equals(type)) {
            example = "new BigDecimal(78)";
        } else if (p.allowableValues != null && !p.allowableValues.isEmpty()) {
            Map allowableValues = p.allowableValues;
            List values = (List)allowableValues.get("values");
            example = type + ".fromValue(\"" + String.valueOf(values.get(0)) + "\")";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + type + "()";
        }
        if (example == null) {
            example = "null";
        } else if (Boolean.TRUE.equals(p.isArray)) {
            if (p.items.defaultValue != null) {
                Object innerExample = "String".equals(p.items.dataType) ? "\"" + p.items.defaultValue + "\"" : p.items.defaultValue;
                example = "Arrays.asList(" + (String)innerExample + ")";
            } else {
                example = "Arrays.asList()";
            }
        } else if (Boolean.TRUE.equals(p.isMap)) {
            example = "new HashMap()";
        }
        p.example = example;
    }

    public String toExampleValue(Schema p) {
        if (p.getExample() != null) {
            return this.escapeText(p.getExample().toString());
        }
        return null;
    }

    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        if (null == openAPIType) {
            LOGGER.error("No Type defined for Schema {}", (Object)p);
        }
        return this.toModelName(openAPIType);
    }

    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = StringUtils.camelize((String)this.sanitizeName(operationId), (CamelizeOption)CamelizeOption.LOWERCASE_FIRST_CHAR))) {
            String newOperationId = StringUtils.camelize((String)("call_" + operationId), (CamelizeOption)CamelizeOption.LOWERCASE_FIRST_CHAR);
            LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.camelize((String)("call_" + operationId)), (Object)true);
            operationId = StringUtils.camelize((String)("call_" + operationId), (CamelizeOption)CamelizeOption.LOWERCASE_FIRST_CHAR);
        }
        return operationId;
    }

    public CodegenModel fromModel(String name, Schema model) {
        Map allDefinitions = ModelUtils.getSchemas((OpenAPI)this.openAPI);
        CodegenModel codegenModel = super.fromModel(name, model);
        if (codegenModel.description != null) {
            codegenModel.imports.add("ApiModel");
        }
        if (allDefinitions != null && codegenModel.parentSchema != null && codegenModel.hasEnums) {
            Schema parentModel = (Schema)allDefinitions.get(codegenModel.parentSchema);
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel);
            codegenModel = KoraCodegen.reconcileInlineEnums(codegenModel, parentCodegenModel);
        }
        if ("BigDecimal".equals(codegenModel.dataType)) {
            codegenModel.imports.add("BigDecimal");
        }
        if (model.getOneOf() != null) {
            if (model.getProperties() == null || model.getProperties().isEmpty()) {
                codegenModel.vars.clear();
                codegenModel.allVars.clear();
                codegenModel.requiredVars.clear();
                codegenModel.optionalVars.clear();
            } else {
                codegenModel.vars.removeIf(p -> !model.getProperties().containsKey(p.name));
                codegenModel.allVars.removeIf(p -> !model.getProperties().containsKey(p.name));
                codegenModel.requiredVars.removeIf(p -> !model.getProperties().containsKey(p.name));
                codegenModel.optionalVars.removeIf(p -> !model.getProperties().containsKey(p.name));
            }
            codegenModel.hasVars = !codegenModel.vars.isEmpty();
            codegenModel.hasOptional = !codegenModel.optionalVars.isEmpty();
            codegenModel.hasRequired = !codegenModel.requiredVars.isEmpty();
        }
        return codegenModel;
    }

    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (!this.fullJavaUtil) {
            if ("array".equals(property.containerType)) {
                model.imports.add("ArrayList");
            } else if ("set".equals(property.containerType)) {
                model.imports.add("LinkedHashSet");
            } else if ("map".equals(property.containerType)) {
                model.imports.add("HashMap");
            }
        }
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            model.imports.add("ApiModelProperty");
            model.imports.add("ApiModel");
        }
    }

    public ModelsMap postProcessModels(ModelsMap objs) {
        List recursiveImports = (List)objs.get((Object)"imports");
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator listIterator = recursiveImports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            HashMap<String, String> newImportMap = new HashMap<String, String>();
            newImportMap.put("import", (String)this.importMapping.get(_import));
            listIterator.add(newImportMap);
        }
        return this.postProcessModelsEnum(objs);
    }

    /*
     * WARNING - void declaration
     */
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        List imports = (List)objs.get((Object)"imports");
        Pattern pattern = Pattern.compile("java\\.util\\.(List|ArrayList|Map|HashMap)");
        Iterator itr = imports.iterator();
        while (itr.hasNext()) {
            String itrImport = (String)((Map)itr.next()).get("import");
            if (!pattern.matcher(itrImport).matches()) continue;
            itr.remove();
        }
        HashMap<String, Object> httpClientAnnotationParams = new HashMap<String, Object>();
        List authMethods = (List)this.vendorExtensions.computeIfAbsent("authMethods", k -> new ArrayList());
        Set tags = (Set)this.vendorExtensions.computeIfAbsent(CLIENT_TAGS, k -> new TreeSet());
        Map operations = (Map)objs.get((Object)"operations");
        if (this.params.clientConfigPrefix != null) {
            httpClientAnnotationParams.put("configPath", "\"" + this.params.clientConfigPrefix + "." + operations.get("classname") + "\"");
        }
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            Object authName;
            Object response2;
            CodegenParameter param22;
            List<String> annotations;
            void var15_15;
            void var15_29;
            TreeSet<String> operationImports = new TreeSet<String>();
            for (Object p : op.allParams) {
                if (!this.importMapping.containsKey(((CodegenParameter)p).dataType)) continue;
                operationImports.add((String)this.importMapping.get(((CodegenParameter)p).dataType));
            }
            TagClient tagClient = null;
            for (Map.Entry entry : this.params.clientTags.entrySet()) {
                if (!op.tags.stream().anyMatch(t -> t.getName().equals(entry.getKey()))) continue;
                tagClient = (TagClient)entry.getValue();
                break;
            }
            if (tagClient == null) {
                tagClient = this.params.clientTags.get("*");
            }
            if (tagClient != null) {
                String suffix;
                String string = suffix = this.params.codegenMode.isKotlin() ? "::class" : ".class";
                if (tagClient.httpClientTag != null) {
                    String string2 = tagClient.httpClientTag.endsWith(suffix) ? tagClient.httpClientTag : tagClient.httpClientTag + suffix;
                    Object object = this.params.codegenMode.isKotlin() ? "[" + string2 + "]" : string2;
                    httpClientAnnotationParams.put("httpClientTag", object);
                }
                if (tagClient.telemetryTag != null) {
                    String string3 = tagClient.telemetryTag.endsWith(suffix) ? tagClient.telemetryTag : tagClient.telemetryTag + suffix;
                    Object object = this.params.codegenMode.isKotlin() ? "[" + string3 + "]" : string3;
                    httpClientAnnotationParams.put("telemetryTag", object);
                }
            }
            List<Interceptor> interceptors = null;
            for (Map.Entry<String, List<Interceptor>> entry : this.params.interceptors.entrySet()) {
                if (!op.tags.stream().anyMatch(t -> t.getName().equals(entry.getKey()))) continue;
                interceptors = entry.getValue();
                break;
            }
            if (interceptors == null) {
                interceptors = this.params.interceptors.get("*");
            }
            if (interceptors != null && !interceptors.isEmpty()) {
                String string = "ru.tinkoff.kora.http.server.common.HttpServerInterceptor";
                String clientDefault = "ru.tinkoff.kora.http.client.common.interceptor.HttpClientInterceptor";
                List<Map> list = interceptors.stream().filter(i -> i.type != null || i.tag != null).map(i -> {
                    List<Object> tag;
                    String impl;
                    String implValue = i.type() == null ? (this.params.codegenMode.isClient() ? "ru.tinkoff.kora.http.client.common.interceptor.HttpClientInterceptor" : "ru.tinkoff.kora.http.server.common.HttpServerInterceptor") : i.type();
                    String suffix = this.params.codegenMode.isKotlin() ? "::class" : ".class";
                    String string = impl = implValue.endsWith(suffix) ? implValue : implValue + suffix;
                    if (i.tag() == null) {
                        tag = null;
                    } else {
                        Object patt83875$temp = i.tag();
                        if (patt83875$temp instanceof String) {
                            String ts = (String)patt83875$temp;
                            tag = List.of(ts);
                        } else {
                            Object patt83989$temp = i.tag();
                            if (patt83989$temp instanceof List) {
                                List tls = (List)patt83989$temp;
                                tag = tls.stream().map(Object::toString).toList();
                            } else {
                                throw new IllegalArgumentException("Unknown interceptors tag value: " + i.tag());
                            }
                        }
                    }
                    if (tag == null || tag.isEmpty()) {
                        return Map.of("interceptorImpl", impl);
                    }
                    String interTags = tag.stream().map(t -> t.endsWith(suffix) ? t : t + suffix).collect(Collectors.joining(", "));
                    return Map.of("interceptorImpl", impl, "interceptorTags", interTags);
                }).toList();
                if (!list.isEmpty()) {
                    objs.put((Object)"koraInterceptors", list);
                }
            }
            Object var15_27 = null;
            for (Map.Entry entry : this.params.additionalContractAnnotations.entrySet()) {
                if (!op.tags.stream().anyMatch(t -> t.getName().equals(entry.getKey()))) continue;
                List list = (List)entry.getValue();
                break;
            }
            if (var15_29 == null) {
                List<AdditionalAnnotation> list = this.params.additionalContractAnnotations.get("*");
            }
            if (var15_15 != null && !var15_15.isEmpty() && !(annotations = var15_15.stream().map(AdditionalAnnotation::annotation).filter(a -> a != null && !a.isBlank()).toList()).isEmpty()) {
                objs.put((Object)"koraAdditionalContractAnnotations", annotations);
            }
            op.vendorExtensions.put(REQUEST_DELEGATE_PARAMS, this.params.requestInDelegateParams);
            op.vendorExtensions.put("x-java-import", operationImports);
            boolean multipartForm = op.consumes != null && op.consumes.stream().map(m -> (String)m.get("mediaType")).anyMatch("multipart/form-data"::equalsIgnoreCase);
            boolean bl = op.consumes != null && op.consumes.stream().map(m -> (String)m.get("mediaType")).anyMatch("application/x-www-form-urlencoded"::equalsIgnoreCase);
            op.vendorExtensions.put("multipartForm", multipartForm);
            op.vendorExtensions.put("urlEncodedForm", bl);
            for (CodegenResponse response2 : op.responses) {
                boolean hasData = response2.hasHeaders || response2.isDefault || response2.dataType != null;
                response2.vendorExtensions.put("jsonTag", this.params.jsonAnnotation);
                response2.vendorExtensions.put("hasData", hasData);
                if (!response2.isBinary || "byte[]".equals(response2.dataType) || "ByteBuffer".equals(response2.dataType) || "String".equals(response2.dataType)) continue;
                response2.vendorExtensions.put("isBinaryUnknownType", true);
            }
            if (op.bodyParam != null) {
                if (op.bodyParam.isBinary) {
                    op.bodyParam.vendorExtensions.put("hasMapperTag", false);
                } else if (KoraCodegen.isContentJson(op.bodyParam)) {
                    op.bodyParam.vendorExtensions.put("hasMapperTag", true);
                    op.bodyParam.vendorExtensions.put("mapperTag", this.params.jsonAnnotation);
                }
                for (CodegenParameter param22 : op.allParams) {
                    if (param22.isBodyParam && param22.isBinary) {
                        op.bodyParam.vendorExtensions.put("hasMapperTag", false);
                        continue;
                    }
                    if (!param22.isBodyParam || !KoraCodegen.isContentJson(param22)) continue;
                    param22.vendorExtensions.put("hasMapperTag", true);
                    param22.vendorExtensions.put("mapperTag", this.params.jsonAnnotation);
                }
            }
            ArrayList<HashMap<String, Boolean>> formParamsWithMappers = new ArrayList<HashMap<String, Boolean>>();
            for (CodegenParameter formParam : op.formParams) {
                if (!formParam.isModel) continue;
                formParam.vendorExtensions.put("requiresMapper", true);
                String type = allModels.stream().filter(m -> m.getModel().name.equals(formParam.dataType)).findFirst().map(m -> m.get((Object)"importPath").toString()).orElseThrow();
                if (KoraCodegen.isContentJson(formParam)) {
                    formParam.vendorExtensions.put("mapperTag", this.params.jsonAnnotation);
                    formParamsWithMappers.add(new HashMap<String, Boolean>(Map.of("paramName", formParam.paramName, "requireTag", true, "mapperTag", this.params.jsonAnnotation, "paramType", type, "last", false)));
                    continue;
                }
                formParamsWithMappers.add(new HashMap<String, Boolean>(Map.of("paramName", formParam.paramName, "requireTag", false, "paramType", type, "last", false)));
            }
            if (!formParamsWithMappers.isEmpty()) {
                ((Map)formParamsWithMappers.get(formParamsWithMappers.size() - 1)).put("last", true);
                op.vendorExtensions.put("requiresFormParamMappers", true);
                op.vendorExtensions.put("formParamMappers", formParamsWithMappers);
            }
            param22 = op.responses.iterator();
            while (param22.hasNext()) {
                CodegenResponse response3 = (CodegenResponse)param22.next();
                if (!KoraCodegen.isContentJson(response3.getContent())) continue;
                response3.vendorExtensions.put("hasMapperTag", true);
                response3.vendorExtensions.put("mapperTag", this.params.jsonAnnotation);
            }
            int lastIdx = 0;
            for (int i2 = op.responses.size() - 1; i2 >= 0; --i2) {
                CodegenResponse response4 = (CodegenResponse)op.responses.get(i2);
                if (response4.dataType == null) continue;
                lastIdx = i2;
                response4.vendorExtensions.put("hasMore", false);
                break;
            }
            for (int i2 = 0; i2 < lastIdx; ++i2) {
                response2 = (CodegenResponse)op.responses.get(i2);
                ((CodegenResponse)response2).vendorExtensions.put("hasMore", true);
            }
            for (Object response2 : op.responses) {
                if (!((CodegenResponse)response2).isBinary) continue;
                Iterator i3 = response2.getContent().keySet().iterator();
                if (i3.hasNext()) {
                    ((CodegenResponse)response2).vendorExtensions.put("contentType", i3.next());
                    continue;
                }
                ((CodegenResponse)response2).vendorExtensions.put("contentType", "application/octet-stream");
            }
            op.vendorExtensions.put("singleResponse", op.responses.size() == 1);
            for (Object response2 : op.responses) {
                ((CodegenResponse)response2).vendorExtensions.put("singleResponse", op.responses.size() == 1);
            }
            if (op.hasAuthMethods) {
                if (this.params.codegenMode.isServer()) {
                    TreeSet<void> operationAuthMethods = new TreeSet<void>();
                    response2 = op.authMethods.iterator();
                    while (response2.hasNext()) {
                        String authName2;
                        CodegenSecurity authMethod = (CodegenSecurity)response2.next();
                        tags.add(this.upperCase(this.toVarName(authMethod.name)));
                        if (authMethod.isApiKey.booleanValue() || authMethod.isBasic.booleanValue() || authMethod.isBasicBearer.booleanValue()) {
                            String authName22 = this.upperCase(this.toVarName(authMethod.name));
                        } else if (authMethod.isOAuth.booleanValue()) {
                            if (authMethod.scopes == null || authMethod.scopes.isEmpty()) {
                                authName2 = this.upperCase(this.toVarName(authMethod.name) + "NoScopes");
                            } else {
                                String scopes = authMethod.scopes.stream().map(it -> this.upperCase(this.toVarName(it.get("scope").toString()))).sorted().collect(Collectors.joining("With"));
                                authName2 = this.upperCase(this.toVarName(authMethod.name) + "With" + scopes);
                            }
                        } else {
                            throw new IllegalStateException();
                        }
                        operationAuthMethods.add((void)authName2);
                        tags.add(this.upperCase(authName2));
                    }
                    String authInterceptorTag = String.join((CharSequence)"With", operationAuthMethods);
                    ArrayList<CodegenSecurity> security = new ArrayList<CodegenSecurity>();
                    for (int i4 = 0; i4 < op.authMethods.size(); ++i4) {
                        CodegenSecurity source = (CodegenSecurity)op.authMethods.get(i4);
                        List<String> scopes = Objects.requireNonNullElse(source.scopes, List.of()).stream().map(m -> m.get("scope").toString()).toList();
                        CodegenSecurity copy = source.filterByScopeNames(scopes);
                        security.add(copy);
                        copy.vendorExtensions.put("isLast", i4 == op.authMethods.size() - 1);
                        copy.vendorExtensions.put("isFirst", i4 == 0);
                        copy.vendorExtensions.put("hasScopes", copy.scopes != null && !copy.scopes.isEmpty());
                    }
                    tags.add(authInterceptorTag);
                    record AuthMethodGroup(String name, List<CodegenSecurity> methods) {
                    }
                    if (authMethods.stream().noneMatch(a -> a.name.equals(authInterceptorTag))) {
                        authMethods.add(new AuthMethodGroup(authInterceptorTag, security));
                    }
                    op.vendorExtensions.put("authInterceptorTag", authInterceptorTag);
                } else if (op.authMethods.size() == 1 || this.params.primaryAuth == null) {
                    if (op.authMethods.size() > 1) {
                        Set secSchemes = op.authMethods.stream().map(s -> s.name).collect(Collectors.toSet());
                        LOGGER.warn("Found multiple securitySchemes {} for {} {} it is recommended to specify preferred securityScheme using `primaryAuth` property, or the first random will be used", new Object[]{secSchemes, op.httpMethod, op.path});
                    }
                    authMethod = (CodegenSecurity)op.authMethods.get(0);
                    if (this.params.authAsMethodArgument) {
                        fakeAuthParameter = this.getAuthArgumentParameter(authMethod, op.allParams);
                        op.allParams.add(fakeAuthParameter);
                    } else {
                        authName = StringUtils.camelize((String)this.toVarName(authMethod.name));
                        tags.add(this.upperCase((String)authName));
                        op.vendorExtensions.put("authInterceptorTag", authName);
                    }
                } else {
                    authMethod = op.authMethods.stream().filter(a -> a.name.equals(this.params.primaryAuth)).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't find OpenAPI securitySchema named: " + this.params.primaryAuth));
                    if (this.params.authAsMethodArgument) {
                        fakeAuthParameter = this.getAuthArgumentParameter(authMethod, op.allParams);
                        op.allParams.add(fakeAuthParameter);
                    } else {
                        authName = StringUtils.camelize((String)this.toVarName(authMethod.name));
                        tags.add(this.upperCase((String)authName));
                        op.vendorExtensions.put("authInterceptorTag", authName);
                    }
                }
            }
            if (this.params.enableValidation) {
                Tag tag;
                List<AdditionalAnnotation> additionalAnnotations = List.of();
                authName = op.tags.iterator();
                while (authName.hasNext() && (additionalAnnotations = this.params.additionalContractAnnotations.get((tag = (Tag)authName.next()).getName())) == null) {
                }
                if (additionalAnnotations == null) {
                    additionalAnnotations = this.params.additionalContractAnnotations.get("*");
                }
                op.vendorExtensions.put("allowAspects", this.params.enableValidation() || !additionalAnnotations.isEmpty());
                for (CodegenParameter p : op.allParams) {
                    boolean validation = false;
                    if (p.isModel) {
                        for (CodegenProperty variable : p.vars) {
                            if (!variable.hasValidation) continue;
                            validation = true;
                            break;
                        }
                        if (!validation) {
                            Optional<CodegenModel> model = allModels.stream().map(mm -> mm.get((Object)"model")).map(CodegenModel.class::cast).filter(m -> m.name.equals(p.dataType)).findFirst();
                            if (model.isPresent()) {
                                block19: for (CodegenModel child : Objects.requireNonNullElse(model.get().children, List.of())) {
                                    for (CodegenProperty variable : child.vars) {
                                        if (!variable.hasValidation) continue;
                                        validation = true;
                                        continue block19;
                                    }
                                }
                            }
                        }
                    } else if (p.isArray) {
                        if (p.hasValidation) {
                            validation = true;
                        }
                    } else if (p.hasValidation) {
                        validation = true;
                    }
                    if (!validation) continue;
                    p.vendorExtensions.put("x-validate", true);
                    op.vendorExtensions.put("x-validate", true);
                    String type = p.getSchema() != null ? p.getSchema().openApiType : null;
                    this.visitVariableValidation(p, type, p.dataFormat, p.vendorExtensions);
                }
            }
            if (this.params.codegenMode.isJava()) {
                for (CodegenParameter allParam : op.allParams) {
                    if (!allParam.required) continue;
                    if (allParam.isInteger) {
                        allParam.dataType = "int";
                    }
                    if (allParam.isLong) {
                        allParam.dataType = "long";
                    }
                    if (allParam.isFloat) {
                        allParam.dataType = "float";
                    }
                    if (allParam.isDouble) {
                        allParam.dataType = "double";
                    }
                    if (!allParam.isBoolean) continue;
                    allParam.dataType = "boolean";
                }
            }
            if (!this.params.codegenMode.isClient()) continue;
            ArrayList<CodegenParameter> requiredParams = new ArrayList<CodegenParameter>();
            ArrayList<CodegenParameter> optionalParams = new ArrayList<CodegenParameter>();
            for (CodegenParameter param3 : op.allParams) {
                if (param3.notRequiredOrIsNullable() && !param3.isPathParam) {
                    optionalParams.add(param3);
                    param3.vendorExtensions.put("x-optional-params", optionalParams);
                    op.vendorExtensions.put("x-have-optional", true);
                    continue;
                }
                requiredParams.add(param3);
                param3.vendorExtensions.put("x-required-params", requiredParams);
            }
            op.vendorExtensions.put("x-required-params", requiredParams);
            op.vendorExtensions.put("x-optional-params", optionalParams);
        }
        if (this.params.codegenMode.isClient()) {
            String annotationParams = httpClientAnnotationParams.entrySet().stream().map(e -> (String)e.getKey() + " = " + (String)e.getValue()).collect(Collectors.joining(", ", "(", ")"));
            objs.put((Object)"annotationParams", (Object)annotationParams);
        }
        return objs;
    }

    private static String getAuthName(String name, List<CodegenParameter> parameters) {
        for (CodegenParameter parameter : parameters) {
            if (!name.equals(parameter.paramName)) continue;
            return KoraCodegen.getAuthName("_" + name, parameters);
        }
        return name;
    }

    private CodegenParameter getAuthArgumentParameter(CodegenSecurity authMethod, List<CodegenParameter> parameters) {
        String authName;
        CodegenParameter fakeAuthParameter = new CodegenParameter();
        fakeAuthParameter.paramName = authName = KoraCodegen.getAuthName(authMethod.name, parameters);
        fakeAuthParameter.baseName = authName;
        fakeAuthParameter.nameInLowerCase = authName.toLowerCase(Locale.ROOT);
        if (authMethod.isKeyInQuery.booleanValue()) {
            fakeAuthParameter.isQueryParam = true;
        } else if (authMethod.isKeyInHeader.booleanValue()) {
            fakeAuthParameter.isHeaderParam = true;
        } else if (authMethod.isKeyInCookie.booleanValue()) {
            fakeAuthParameter.isCookieParam = true;
        } else if (authMethod.isOAuth.booleanValue() || authMethod.isOpenId.booleanValue() || authMethod.isBasicBearer.booleanValue() || authMethod.isBasic.booleanValue() || authMethod.isBasicBasic.booleanValue()) {
            fakeAuthParameter.isHeaderParam = true;
            for (CodegenParameter parameter : parameters) {
                if (!"Authorization".equalsIgnoreCase(parameter.paramName)) continue;
                throw new IllegalArgumentException("Authorization argument as method parameter can't be set, cause parameter named 'Authorization' already is present");
            }
            fakeAuthParameter.paramName = "Authorization";
            fakeAuthParameter.baseName = "Authorization";
            fakeAuthParameter.nameInLowerCase = "Authorization".toLowerCase(Locale.ROOT);
        } else {
            throw new IllegalStateException("Auth argument can be in Query, Header or Cookie, but wasn't unknown");
        }
        fakeAuthParameter.dataType = "String";
        fakeAuthParameter.baseType = "String";
        fakeAuthParameter.description = authMethod.description;
        fakeAuthParameter.unescapedDescription = authMethod.description;
        fakeAuthParameter.required = true;
        fakeAuthParameter.isString = true;
        fakeAuthParameter.isNull = false;
        fakeAuthParameter.isNullable = false;
        Schema schema = SchemaTypeUtil.createSchema((String)"String", null);
        CodegenProperty codegenProperty = this.fromProperty(authName, schema);
        fakeAuthParameter.setSchema(codegenProperty);
        return fakeAuthParameter;
    }

    private CodegenProperty getFakeCodegenPropertyString(String name) {
        CodegenProperty fakeProperty = new CodegenProperty();
        fakeProperty.name = name;
        fakeProperty.baseName = name;
        fakeProperty.baseType = "String";
        fakeProperty.dataType = "String";
        fakeProperty.datatypeWithEnum = "String";
        fakeProperty.nameInLowerCase = name.toLowerCase(Locale.ROOT);
        fakeProperty.required = true;
        fakeProperty.isString = true;
        fakeProperty.isNull = false;
        fakeProperty.isNullable = false;
        return fakeProperty;
    }

    public static boolean isContentJson(CodegenParameter parameter) {
        return parameter.containerType != null && (parameter.containerType.startsWith("application/json") || parameter.containerType.startsWith("text/json")) || KoraCodegen.isContentJson(parameter.getContent());
    }

    public static boolean isContentJson(@Nullable Map<String, CodegenMediaType> content) {
        if (content == null) {
            return false;
        }
        return content.keySet().stream().anyMatch(k -> k.startsWith("application/json") || k.startsWith("text/json"));
    }

    public String upperCase(String name) {
        return name.length() > 0 ? Character.toUpperCase(name.charAt(0)) + name.substring(1) : "";
    }

    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        objs.put("vendorExtensions", this.vendorExtensions);
        return objs;
    }

    public void preprocessOpenAPI(OpenAPI openAPI) {
        Map securitySchemas;
        super.preprocessOpenAPI(openAPI);
        if (openAPI == null) {
            return;
        }
        if (openAPI.getPaths() != null) {
            for (String pathname : openAPI.getPaths().keySet()) {
                PathItem path = (PathItem)openAPI.getPaths().get((Object)pathname);
                if (path.readOperations() == null) continue;
                for (Operation operation : path.readOperations()) {
                    LOGGER.info("Processing operation {}", (Object)operation.getOperationId());
                    if (this.hasBodyParameter(operation) || this.hasFormParameter(operation)) {
                        String defaultContentType = this.hasFormParameter(operation) ? "application/x-www-form-urlencoded" : "application/json";
                        ArrayList consumes = new ArrayList(KoraCodegen.getConsumesInfo((OpenAPI)openAPI, (Operation)operation));
                        String contentType = consumes == null || consumes.isEmpty() ? defaultContentType : (String)consumes.get(0);
                        operation.addExtension("x-contentType", (Object)contentType);
                    }
                    String accepts = KoraCodegen.getAccept(openAPI, operation);
                    operation.addExtension("x-accepts", (Object)accepts);
                }
            }
        }
        if (this.ignoreAnyOfInEnum) {
            Stream.concat(Stream.of(openAPI.getComponents().getSchemas()), openAPI.getComponents().getSchemas().values().stream().filter(schema -> schema.getProperties() != null).map(Schema::getProperties)).forEach(schemas -> schemas.replaceAll((name, s) -> Stream.of(s).filter(schema -> schema instanceof ComposedSchema).map(schema -> (ComposedSchema)schema).filter(schema -> Objects.nonNull(schema.getAnyOf())).flatMap(schema -> schema.getAnyOf().stream()).filter(schema -> Objects.nonNull(schema.getEnum())).findFirst().orElse((Schema)s)));
        }
        if (!Objects.requireNonNullElse(securitySchemas = openAPI.getComponents().getSecuritySchemes(), Map.of()).isEmpty()) {
            switch (this.params.codegenMode) {
                case JAVA_CLIENT: 
                case JAVA_ASYNC_CLIENT: 
                case JAVA_REACTIVE_CLIENT: {
                    String securitySchemaClass = this.apiFileFolder() + File.separator + "ApiSecurity.java";
                    this.supportingFiles.add(new SupportingFile("javaClientSecuritySchema.mustache", securitySchemaClass));
                    break;
                }
                case JAVA_SERVER: 
                case JAVA_ASYNC_SERVER: 
                case JAVA_REACTIVE_SERVER: {
                    String securitySchemaClass = this.apiFileFolder() + File.separator + "ApiSecurity.java";
                    this.supportingFiles.add(new SupportingFile("javaServerSecuritySchema.mustache", securitySchemaClass));
                    break;
                }
                case KOTLIN_CLIENT: 
                case KOTLIN_SUSPEND_CLIENT: {
                    String securitySchemaClass = this.apiFileFolder() + File.separator + "ApiSecurity.kt";
                    this.supportingFiles.add(new SupportingFile("kotlinClientSecuritySchema.mustache", securitySchemaClass));
                    break;
                }
                case KOTLIN_SERVER: 
                case KOTLIN_SUSPEND_SERVER: {
                    String securitySchemaClass = this.apiFileFolder() + File.separator + "ApiSecurity.kt";
                    this.supportingFiles.add(new SupportingFile("kotlinServerSecuritySchema.mustache", securitySchemaClass));
                }
            }
        }
    }

    private static String getAccept(OpenAPI openAPI, Operation operation) {
        String accepts = null;
        String defaultContentType = "application/json";
        Set producesInfo = KoraCodegen.getProducesInfo((OpenAPI)openAPI, (Operation)operation);
        if (producesInfo != null && !producesInfo.isEmpty()) {
            ArrayList produces = new ArrayList(producesInfo);
            StringBuilder sb = new StringBuilder();
            for (String produce : produces) {
                if (defaultContentType.equalsIgnoreCase(produce)) {
                    accepts = defaultContentType;
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(produce);
            }
            if (accepts == null) {
                accepts = sb.toString();
            }
        } else {
            accepts = defaultContentType;
        }
        return accepts;
    }

    protected boolean needToImport(String type) {
        return super.needToImport(type) && !type.contains(".");
    }

    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(StringUtils.camelize((String)property.name)) + "Enum";
    }

    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        if (this.getSymbolName(value) != null) {
            return this.getSymbolName(value).toUpperCase(Locale.ROOT);
        }
        if ("Integer".equals(datatype) || "Int".equals(datatype) || "Long".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype) || "BigDecimal".equals(datatype)) {
            Object varName = "NUMBER_" + value;
            varName = ((String)varName).replaceAll("-", "MINUS_");
            varName = ((String)varName).replaceAll("\\+", "PLUS_");
            varName = ((String)varName).replaceAll("\\.", "_DOT_");
            return varName;
        }
        String var = value.replaceAll("\\W+", "_").toUpperCase(Locale.ROOT);
        if (var.matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Int".equals(datatype) || "Double".equals(datatype)) {
            return value;
        }
        if ("Long".equals(datatype)) {
            return value + "l";
        }
        if ("Float".equals(datatype)) {
            return value + "f";
        }
        if ("BigDecimal".equals(datatype)) {
            return "new BigDecimal(\"" + value + "\")";
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        op.path = this.sanitizePath(op.path);
        return op;
    }

    public void postProcessParameter(CodegenParameter p) {
        if (p.defaultValue == null) {
            return;
        }
        Boolean fixLong = p.isLong && "l".equals(p.defaultValue.substring(p.defaultValue.length() - 1));
        Boolean fixDouble = p.isDouble && "d".equals(p.defaultValue.substring(p.defaultValue.length() - 1));
        Boolean fixFloat = p.isFloat && "f".equals(p.defaultValue.substring(p.defaultValue.length() - 1));
        if (fixLong.booleanValue() || fixDouble.booleanValue() || fixFloat.booleanValue()) {
            p.defaultValue = p.defaultValue.substring(0, p.defaultValue.length() - 1);
        }
    }

    private static CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (!parentCodegenModel.hasEnums) {
            return codegenModel;
        }
        List parentModelCodegenProperties = parentCodegenModel.vars;
        List codegenProperties = codegenModel.vars;
        boolean removedChildEnum = false;
        for (CodegenProperty parentModelCodegenPropery : parentModelCodegenProperties) {
            if (!parentModelCodegenPropery.isEnum) continue;
            Iterator iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = (CodegenProperty)iterator.next();
                if (!codegenProperty.isEnum || !codegenProperty.equals((Object)parentModelCodegenPropery)) continue;
                iterator.remove();
                removedChildEnum = true;
            }
        }
        if (removedChildEnum) {
            codegenModel.vars = codegenProperties;
        }
        return codegenModel;
    }

    private static String sanitizePackageName(String packageName) {
        packageName = packageName.trim();
        if (Strings.isNullOrEmpty((String)(packageName = packageName.replaceAll("[^a-zA-Z0-9_\\.]", "_")))) {
            return "invalidPackageName";
        }
        return packageName;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    private String sanitizePath(String p) {
        return p.replaceAll("\"", "%22");
    }

    public void setDiscriminatorCaseSensitive(boolean discriminatorCaseSensitive) {
        this.discriminatorCaseSensitive = discriminatorCaseSensitive;
    }

    public void setDisableHtmlEscaping(boolean disabled) {
        this.disableHtmlEscaping = disabled;
    }

    public void setIgnoreAnyOfInEnum(boolean ignoreAnyOfInEnum) {
        this.ignoreAnyOfInEnum = ignoreAnyOfInEnum;
    }

    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    private String deriveInvokerPackageName(String input) {
        String[] parts = input.split(Pattern.quote("."));
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (String p : Arrays.copyOf(parts, parts.length - 1)) {
            sb.append(delim).append(p);
            delim = ".";
        }
        return sb.toString();
    }

    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    public String toBooleanGetter(String name) {
        return this.booleanGetterPrefix + this.getterAndSetterCapitalize(name);
    }

    public String sanitizeTag(String tag) {
        if (((String)(tag = StringUtils.camelize((String)StringUtils.underscore((String)this.sanitizeName((String)tag))))).matches("^\\d.*")) {
            tag = "Class" + (String)tag;
        }
        return tag;
    }

    public String getterAndSetterCapitalize(String name) {
        CamelizeOption lowercaseFirstLetter = CamelizeOption.UPPERCASE_FIRST_CHAR;
        if (name == null || name.length() == 0) {
            return name;
        }
        if ((name = this.toVarName(name)).length() > 1 && Character.isLowerCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            lowercaseFirstLetter = CamelizeOption.LOWERCASE_FIRST_CHAR;
        }
        return StringUtils.camelize((String)name, (CamelizeOption)lowercaseFirstLetter);
    }

    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String javaPostProcessFile = System.getenv("JAVA_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)javaPostProcessFile)) {
            return;
        }
        if ("java".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = javaPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                p.waitFor();
                int exitValue = p.exitValue();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    public void setAdditionalModelTypeAnnotations(List<String> additionalModelTypeAnnotations) {
        this.additionalModelTypeAnnotations = additionalModelTypeAnnotations;
    }

    public void setAdditionalEnumTypeAnnotations(List<String> additionalEnumTypeAnnotations) {
        this.additionalEnumTypeAnnotations = additionalEnumTypeAnnotations;
    }

    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema s;
        if (!this.supportsAdditionalPropertiesWithComposedSchema) {
            super.addAdditionPropertiesToCodeGenModel(codegenModel, schema);
        }
        if ((s = ModelUtils.getAdditionalProperties((Schema)schema)) != null) {
            codegenModel.additionalPropertiesType = this.getSchemaType(s);
            this.addImport(codegenModel, codegenModel.additionalPropertiesType);
        }
    }

    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"trim", (fragment, out) -> {
            String text = fragment.execute();
            out.write(text.trim());
        }).put((Object)"classname", (fragment, out) -> {
            String text = fragment.execute();
            out.write(this.upperCase(this.toVarName(text)));
        });
    }

    public void postProcess() {
    }

    record CodegenParams(Mode codegenMode, String jsonAnnotation, boolean enableValidation, boolean authAsMethodArgument, String primaryAuth, String clientConfigPrefix, String securityConfigPrefix, Map<String, TagClient> clientTags, Map<String, List<Interceptor>> interceptors, Map<String, List<AdditionalAnnotation>> additionalContractAnnotations, boolean requestInDelegateParams, boolean enableJsonNullable) {
        static List<CliOption> cliOptions() {
            ArrayList<CliOption> cliOptions = new ArrayList<CliOption>();
            cliOptions.add(CliOption.newString((String)KoraCodegen.CODEGEN_MODE, (String)"Generation mode (one of java, reactive or kotlin)"));
            cliOptions.add(CliOption.newString((String)KoraCodegen.SECURITY_CONFIG_PREFIX, (String)"Config prefix for security config parsers"));
            cliOptions.add(CliOption.newString((String)KoraCodegen.PRIMARY_AUTH, (String)"Specify primary HTTP client securityScheme if multiple are available for method"));
            cliOptions.add(CliOption.newString((String)KoraCodegen.CLIENT_CONFIG_PREFIX, (String)"Generated client config prefix"));
            cliOptions.add(CliOption.newString((String)KoraCodegen.JSON_ANNOTATION, (String)"Json annotation tag to place on body and other json related params"));
            cliOptions.add(CliOption.newString((String)KoraCodegen.CLIENT_TAGS, (String)"Json containing http client tags configuration for apis"));
            cliOptions.add(CliOption.newString((String)KoraCodegen.INTERCEPTORS, (String)"Json containing interceptors for HTTP server/client"));
            cliOptions.add(CliOption.newBoolean((String)KoraCodegen.ENABLE_VALIDATION, (String)"Generate validation related annotation on models and controllers"));
            cliOptions.add(CliOption.newBoolean((String)KoraCodegen.REQUEST_DELEGATE_PARAMS, (String)"Generate HttpServerRequest parameter in delegate methods"));
            cliOptions.add(CliOption.newString((String)KoraCodegen.ADDITIONAL_CONTRACT_ANNOTATIONS, (String)"Additional annotations for HTTP client/server methods"));
            cliOptions.add(CliOption.newBoolean((String)KoraCodegen.AUTH_AS_METHOD_ARGUMENT, (String)"HTTP client authorization as method argument"));
            cliOptions.add(CliOption.newBoolean((String)KoraCodegen.ENABLE_JSON_NULLABLE, (String)"If enabled then wraps Nullable and NonRequired fields with JsonNullable type"));
            return cliOptions;
        }

        static CodegenParams parse(Map<String, Object> additionalProperties) {
            Mode codegenMode = Mode.JAVA_CLIENT;
            String jsonAnnotation = "ru.tinkoff.kora.json.common.annotation.Json";
            boolean enableServerValidation = false;
            boolean authAsMethodArgument = false;
            String primaryAuth = null;
            String clientConfigPrefix = null;
            String securityConfigPrefix = null;
            HashMap clientTags = new HashMap();
            HashMap interceptors = new HashMap();
            HashMap additionalContractAnnotations = new HashMap();
            boolean requestInDelegateParams = false;
            boolean enableJsonNullable = false;
            if (additionalProperties.containsKey(KoraCodegen.CODEGEN_MODE)) {
                codegenMode = Mode.ofMode(additionalProperties.get(KoraCodegen.CODEGEN_MODE).toString());
            }
            if (additionalProperties.containsKey(KoraCodegen.JSON_ANNOTATION)) {
                jsonAnnotation = additionalProperties.get(KoraCodegen.JSON_ANNOTATION).toString();
            }
            if (additionalProperties.containsKey(KoraCodegen.CLIENT_TAGS)) {
                String clientTagsJson = additionalProperties.get(KoraCodegen.CLIENT_TAGS).toString();
                try {
                    clientTags = (HashMap)new ObjectMapper().readerFor((JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, String.class, TagClient.class)).readValue(clientTagsJson);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            if (additionalProperties.containsKey(KoraCodegen.INTERCEPTORS)) {
                String interceptorJson = additionalProperties.get(KoraCodegen.INTERCEPTORS).toString();
                try {
                    interceptors = (HashMap)new ObjectMapper().readerFor(TypeFactory.defaultInstance().constructType((TypeReference)new TypeReference<Map<String, List<Interceptor>>>(){})).readValue(interceptorJson);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            if (additionalProperties.containsKey(KoraCodegen.ADDITIONAL_CONTRACT_ANNOTATIONS)) {
                String json = additionalProperties.get(KoraCodegen.ADDITIONAL_CONTRACT_ANNOTATIONS).toString();
                try {
                    additionalContractAnnotations = (HashMap)new ObjectMapper().readerFor(TypeFactory.defaultInstance().constructType((TypeReference)new TypeReference<Map<String, List<AdditionalAnnotation>>>(){})).readValue(json);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            if (additionalProperties.containsKey(KoraCodegen.PRIMARY_AUTH)) {
                primaryAuth = additionalProperties.get(KoraCodegen.PRIMARY_AUTH).toString();
            }
            if (additionalProperties.containsKey(KoraCodegen.AUTH_AS_METHOD_ARGUMENT)) {
                authAsMethodArgument = Boolean.parseBoolean(additionalProperties.get(KoraCodegen.AUTH_AS_METHOD_ARGUMENT).toString());
            }
            if (additionalProperties.containsKey(KoraCodegen.CLIENT_CONFIG_PREFIX)) {
                clientConfigPrefix = additionalProperties.get(KoraCodegen.CLIENT_CONFIG_PREFIX).toString();
            }
            if (additionalProperties.containsKey(KoraCodegen.SECURITY_CONFIG_PREFIX)) {
                securityConfigPrefix = additionalProperties.get(KoraCodegen.SECURITY_CONFIG_PREFIX).toString();
            }
            if (additionalProperties.containsKey(KoraCodegen.ENABLE_VALIDATION) && codegenMode.isServer()) {
                enableServerValidation = Boolean.parseBoolean(additionalProperties.get(KoraCodegen.ENABLE_VALIDATION).toString());
            }
            if (additionalProperties.containsKey(KoraCodegen.REQUEST_DELEGATE_PARAMS) && codegenMode.isServer()) {
                requestInDelegateParams = Boolean.parseBoolean(additionalProperties.get(KoraCodegen.REQUEST_DELEGATE_PARAMS).toString());
            }
            if (additionalProperties.containsKey(KoraCodegen.ENABLE_JSON_NULLABLE)) {
                enableJsonNullable = Boolean.parseBoolean(additionalProperties.get(KoraCodegen.ENABLE_JSON_NULLABLE).toString());
            }
            return new CodegenParams(codegenMode, jsonAnnotation, enableServerValidation, authAsMethodArgument, primaryAuth, clientConfigPrefix, securityConfigPrefix, clientTags, interceptors, additionalContractAnnotations, requestInDelegateParams, enableJsonNullable);
        }

        void processAdditionalProperties(Map<String, Object> additionalProperties) {
            additionalProperties.put("hasSecurityConfigPrefix", this.securityConfigPrefix != null);
            additionalProperties.put(KoraCodegen.REQUEST_DELEGATE_PARAMS, this.requestInDelegateParams);
            switch (this.codegenMode) {
                case JAVA_CLIENT: {
                    additionalProperties.put("isClient", true);
                    additionalProperties.put("isBlocking", true);
                    break;
                }
                case JAVA_ASYNC_CLIENT: 
                case JAVA_REACTIVE_CLIENT: {
                    additionalProperties.put("isClient", true);
                    additionalProperties.put("isAsync", this.codegenMode == Mode.JAVA_ASYNC_CLIENT);
                    additionalProperties.put("isReactive", this.codegenMode == Mode.JAVA_REACTIVE_CLIENT);
                    break;
                }
                case JAVA_SERVER: {
                    additionalProperties.put("isClient", false);
                    additionalProperties.put("isBlocking", true);
                    break;
                }
                case JAVA_ASYNC_SERVER: 
                case JAVA_REACTIVE_SERVER: {
                    additionalProperties.put("isClient", false);
                    additionalProperties.put("isAsync", this.codegenMode == Mode.JAVA_ASYNC_SERVER);
                    additionalProperties.put("isReactive", this.codegenMode == Mode.JAVA_REACTIVE_SERVER);
                    break;
                }
                case KOTLIN_CLIENT: 
                case KOTLIN_SUSPEND_CLIENT: {
                    additionalProperties.put("isClient", true);
                    additionalProperties.put("isSuspend", this.codegenMode == Mode.KOTLIN_SUSPEND_CLIENT);
                    break;
                }
                case KOTLIN_SERVER: 
                case KOTLIN_SUSPEND_SERVER: {
                    additionalProperties.put("isClient", false);
                    additionalProperties.put("isSuspend", this.codegenMode == Mode.KOTLIN_SUSPEND_SERVER);
                }
            }
        }
    }

    public static enum Mode {
        JAVA_CLIENT("java-client"),
        JAVA_SERVER("java-server"),
        JAVA_ASYNC_CLIENT("java-async-client"),
        JAVA_ASYNC_SERVER("java-async-server"),
        JAVA_REACTIVE_CLIENT("java-reactive-client"),
        JAVA_REACTIVE_SERVER("java-reactive-server"),
        KOTLIN_CLIENT("kotlin-client"),
        KOTLIN_SERVER("kotlin-server"),
        KOTLIN_SUSPEND_CLIENT("kotlin-suspend-client"),
        KOTLIN_SUSPEND_SERVER("kotlin-suspend-server");

        private final String mode;

        private Mode(String mode) {
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }

        public static Mode ofMode(String option) {
            for (Mode value : Mode.values()) {
                if (!value.getMode().equals(option)) continue;
                return value;
            }
            List<String> modes = Arrays.stream(Mode.values()).map(Mode::getMode).toList();
            throw new UnsupportedOperationException("Unknown Mode is provided: " + option + ", available modes: " + modes);
        }

        public boolean isServer() {
            return switch (this) {
                case JAVA_SERVER, JAVA_ASYNC_SERVER, JAVA_REACTIVE_SERVER, KOTLIN_SERVER, KOTLIN_SUSPEND_SERVER -> true;
                default -> false;
            };
        }

        public boolean isClient() {
            return switch (this) {
                case JAVA_CLIENT, JAVA_ASYNC_CLIENT, JAVA_REACTIVE_CLIENT, KOTLIN_CLIENT, KOTLIN_SUSPEND_CLIENT -> true;
                default -> false;
            };
        }

        public boolean isJava() {
            return this != KOTLIN_CLIENT && this != KOTLIN_SERVER && this != KOTLIN_SUSPEND_CLIENT && this != KOTLIN_SUSPEND_SERVER;
        }

        public boolean isKotlin() {
            return !this.isJava();
        }
    }

    record TagClient(@Nullable String httpClientTag, @Nullable String telemetryTag) {
    }

    record Interceptor(@Nullable String type, @Nullable Object tag) {
    }

    record AdditionalAnnotation(@Nullable String annotation) {
    }
}

