/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.openapi.management;

import java.util.concurrent.CompletableFuture;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandler;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandlerImpl;
import ru.tinkoff.kora.openapi.management.OpenApiHttpServerHandler;
import ru.tinkoff.kora.openapi.management.OpenApiManagementConfig;
import ru.tinkoff.kora.openapi.management.RapidocHttpServerHandler;
import ru.tinkoff.kora.openapi.management.SwaggerUIHttpServerHandler;

public interface OpenApiManagementModule {
    default public OpenApiManagementConfig openApiManagementConfig(Config config, ConfigValueExtractor<OpenApiManagementConfig> extractor) {
        return (OpenApiManagementConfig)extractor.extract(config.get("openapi.management"));
    }

    default public HttpServerRequestHandler openApiManagementController(OpenApiManagementConfig config) {
        Object path;
        Object object = path = config.file().size() == 1 ? config.endpoint() : config.endpoint() + "/{file}";
        if (!config.enabled()) {
            return HttpServerRequestHandlerImpl.get((String)path, (context, request) -> CompletableFuture.completedFuture(HttpServerResponse.of((int)404)));
        }
        OpenApiHttpServerHandler handler = new OpenApiHttpServerHandler(config.file(), f -> f);
        return HttpServerRequestHandlerImpl.get((String)path, (HttpServerRequestHandler.HandlerFunction)handler);
    }

    default public HttpServerRequestHandler swaggerUIManagementController(OpenApiManagementConfig config) {
        if (config.swaggerui() == null) {
            return HttpServerRequestHandlerImpl.get((String)"/swagger-ui", (context, request) -> CompletableFuture.completedFuture(HttpServerResponse.of((int)404)));
        }
        if (!config.enabled() || !config.swaggerui().enabled()) {
            return HttpServerRequestHandlerImpl.get((String)config.swaggerui().endpoint(), (context, request) -> CompletableFuture.completedFuture(HttpServerResponse.of((int)404)));
        }
        SwaggerUIHttpServerHandler handler = new SwaggerUIHttpServerHandler(config.endpoint(), config.swaggerui().endpoint(), config.file());
        return HttpServerRequestHandlerImpl.get((String)config.swaggerui().endpoint(), (HttpServerRequestHandler.HandlerFunction)handler);
    }

    default public HttpServerRequestHandler rapidocManagementController(OpenApiManagementConfig config) {
        if (config.rapidoc() == null) {
            return HttpServerRequestHandlerImpl.get((String)"/rapidoc", (context, request) -> CompletableFuture.completedFuture(HttpServerResponse.of((int)404)));
        }
        if (!config.enabled() || !config.rapidoc().enabled()) {
            return HttpServerRequestHandlerImpl.get((String)config.rapidoc().endpoint(), (context, request) -> CompletableFuture.completedFuture(HttpServerResponse.of((int)404)));
        }
        RapidocHttpServerHandler handler = new RapidocHttpServerHandler(config.endpoint(), config.rapidoc().endpoint(), config.file());
        return HttpServerRequestHandlerImpl.get((String)config.rapidoc().endpoint(), (HttpServerRequestHandler.HandlerFunction)handler);
    }
}

