/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.openapi.management;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandler;
import ru.tinkoff.kora.openapi.management.OpenApiManagementConfig;
import ru.tinkoff.kora.openapi.management.ResourceUtils;

final class OpenApiHttpServerHandler
implements HttpServerRequestHandler.HandlerFunction {
    private final String contentType;
    private final byte[] openapi;

    OpenApiHttpServerHandler(OpenApiManagementConfig config) {
        this.contentType = config.file().endsWith(".json") ? "text/json; charset=utf-8" : "text/x-yaml; charset=utf-8";
        this.openapi = OpenApiHttpServerHandler.loadOpenapi(config);
    }

    public CompletionStage<HttpServerResponse> apply(Context context, HttpServerRequest request) throws Exception {
        return CompletableFuture.completedFuture(HttpServerResponse.of((int)200, (HttpBodyOutput)HttpBody.of((String)this.contentType, (byte[])this.openapi)));
    }

    private static byte[] loadOpenapi(OpenApiManagementConfig config) {
        try {
            InputStream openapiAsStream = ResourceUtils.getFileAsStream(config.file());
            if (openapiAsStream == null) {
                throw HttpServerResponseException.of((int)404, (String)("Can't read direct OpenAPI file: " + config.file()));
            }
            return openapiAsStream.readAllBytes();
        }
        catch (IOException e) {
            throw HttpServerResponseException.of((int)500, (String)("Can't read direct OpenAPI file: " + config.file()));
        }
    }
}

