/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.openapi.management;

import java.util.concurrent.CompletableFuture;
import ru.tinkoff.kora.config.common.Config;
import ru.tinkoff.kora.config.common.extractor.ConfigValueExtractor;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandler;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandlerImpl;
import ru.tinkoff.kora.openapi.management.OpenApiHttpServerHandler;
import ru.tinkoff.kora.openapi.management.OpenApiManagementConfig;
import ru.tinkoff.kora.openapi.management.RapidocHttpServerHandler;
import ru.tinkoff.kora.openapi.management.SwaggerUIHttpServerHandler;

public interface OpenApiManagementModule {
    default public OpenApiManagementConfig openApiManagementConfig(Config config, ConfigValueExtractor<OpenApiManagementConfig> extractor) {
        return (OpenApiManagementConfig)extractor.extract(config.get("openapi.management"));
    }

    default public HttpServerRequestHandler openApiManagementController(OpenApiManagementConfig config) {
        if (!config.enabled()) {
            return HttpServerRequestHandlerImpl.of((String)"GET", (String)config.endpoint(), (context, request) -> CompletableFuture.completedFuture(HttpServerResponse.of((int)404)));
        }
        OpenApiHttpServerHandler handler = new OpenApiHttpServerHandler(config);
        return HttpServerRequestHandlerImpl.of((String)"GET", (String)config.endpoint(), (HttpServerRequestHandler.HandlerFunction)handler);
    }

    default public HttpServerRequestHandler swaggerUIManagementController(OpenApiManagementConfig config) {
        if (config.swaggerui() == null) {
            return HttpServerRequestHandlerImpl.of((String)"GET", (String)"/swagger-ui", (context, request) -> CompletableFuture.completedFuture(HttpServerResponse.of((int)404)));
        }
        if (!config.enabled() || !config.swaggerui().enabled()) {
            return HttpServerRequestHandlerImpl.of((String)"GET", (String)config.swaggerui().endpoint(), (context, request) -> CompletableFuture.completedFuture(HttpServerResponse.of((int)404)));
        }
        SwaggerUIHttpServerHandler handler = new SwaggerUIHttpServerHandler(config);
        return HttpServerRequestHandlerImpl.of((String)"GET", (String)config.swaggerui().endpoint(), (HttpServerRequestHandler.HandlerFunction)handler);
    }

    default public HttpServerRequestHandler rapidocManagementController(OpenApiManagementConfig config) {
        if (config.rapidoc() == null) {
            return HttpServerRequestHandlerImpl.of((String)"GET", (String)"/rapidoc", (context, request) -> CompletableFuture.completedFuture(HttpServerResponse.of((int)404)));
        }
        if (!config.enabled() || !config.rapidoc().enabled()) {
            return HttpServerRequestHandlerImpl.of((String)"GET", (String)config.rapidoc().endpoint(), (context, request) -> CompletableFuture.completedFuture(HttpServerResponse.of((int)404)));
        }
        RapidocHttpServerHandler handler = new RapidocHttpServerHandler(config);
        return HttpServerRequestHandlerImpl.of((String)"GET", (String)config.rapidoc().endpoint(), (HttpServerRequestHandler.HandlerFunction)handler);
    }
}

