/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.openapi.management;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.http.server.common.HttpServerRequest;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.HttpServerResponseException;
import ru.tinkoff.kora.http.server.common.handler.HttpServerRequestHandler;
import ru.tinkoff.kora.openapi.management.ResourceUtils;

public final class SwaggerUIHttpServerHandler
implements HttpServerRequestHandler.HandlerFunction {
    private static final String FILE_PATH = "kora/openapi/management/swagger-ui/index.html";
    private static final String HTML_CONTENT_TYPE = "text/html; charset=utf-8";
    private final AtomicReference<byte[]> content = new AtomicReference();
    private final String openapiPath;
    private final String swaggeruiPath;
    private final List<String> openapiFiles;

    public SwaggerUIHttpServerHandler(String openapiPath, String swaggeruiPath, List<String> openapiFiles) {
        this.openapiPath = openapiPath;
        this.swaggeruiPath = swaggeruiPath;
        this.openapiFiles = openapiFiles;
    }

    public CompletionStage<HttpServerResponse> apply(Context context, HttpServerRequest request) {
        byte[] bytes = this.content.get();
        if (bytes != null) {
            return CompletableFuture.completedFuture(HttpServerResponse.of((int)200, (HttpBodyOutput)HttpBody.of((String)HTML_CONTENT_TYPE, (byte[])bytes)));
        }
        return CompletableFuture.supplyAsync(() -> {
            byte[] loadedBytes = this.loadSwagger();
            this.content.set(loadedBytes);
            return HttpServerResponse.of((int)200, (HttpBodyOutput)HttpBody.of((String)HTML_CONTENT_TYPE, (byte[])loadedBytes));
        });
    }

    private byte[] loadSwagger() {
        return ResourceUtils.getFileAsString(FILE_PATH).map(file -> {
            if (this.openapiFiles.size() == 1) {
                String replacement = "url: window.location.href.substring(0, window.location.href.lastIndexOf(\"#\") === -1 ? window.location.href.length : window.location.href.lastIndexOf(\"#\")).replace(\"%s\", \"%s\")\n".formatted(this.swaggeruiPath, this.openapiPath);
                String tagSwagger = "${swaggerUrls}";
                int ri = file.lastIndexOf(tagSwagger);
                return file.substring(0, ri) + replacement + file.substring(ri + tagSwagger.length());
            }
            StringBuilder replacement = new StringBuilder("urls: [");
            for (String filePath : this.openapiFiles) {
                String fileName = ResourceUtils.getFileName(filePath);
                replacement.append("{ url: window.location.href.substring(0, window.location.href.lastIndexOf(\"#\") === -1 ? window.location.href.length : window.location.href.lastIndexOf(\"#\")).replace(\"%s\", \"%s\"),\n  name: \"%s\" },\n".formatted(this.swaggeruiPath, this.openapiPath + "/" + fileName, fileName));
            }
            replacement.append("]");
            String tagSwagger = "${swaggerUrls}";
            int ri = file.lastIndexOf(tagSwagger);
            return file.substring(0, ri) + String.valueOf(replacement) + file.substring(ri + tagSwagger.length());
        }).map(file -> file.getBytes(StandardCharsets.UTF_8)).orElseThrow(() -> HttpServerResponseException.of((int)404, (String)"Swagger UI file not found"));
    }
}

