/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.opentelemetry.module.cache;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.ImplicitContextKeyed;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import ru.tinkoff.kora.cache.telemetry.CacheTelemetryOperation;
import ru.tinkoff.kora.cache.telemetry.CacheTracer;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.opentelemetry.common.OpentelemetryContext;

public final class OpentelementryCacheTracer
implements CacheTracer {
    private static final String TAG_OPERATION = "operation";
    private static final String TAG_CACHE_NAME = "cache";
    private static final String TAG_ORIGIN = "origin";
    private final Tracer tracer;

    public OpentelementryCacheTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public CacheTracer.CacheSpan trace(@Nonnull CacheTelemetryOperation operation) {
        Context context = Context.current();
        OpentelemetryContext traceContext = OpentelemetryContext.get((Context)context);
        Span span = this.tracer.spanBuilder("cache.call").setSpanKind(SpanKind.INTERNAL).setParent(traceContext.getContext()).setAttribute(TAG_OPERATION, operation.name()).setAttribute(TAG_CACHE_NAME, operation.cacheName()).setAttribute(TAG_ORIGIN, operation.origin()).startSpan();
        OpentelemetryContext.set((Context)context, (OpentelemetryContext)traceContext.add((ImplicitContextKeyed)span));
        return new OpentelemetryCacheSpan(span, context, traceContext);
    }

    record OpentelemetryCacheSpan(Span span, Context currentContext, OpentelemetryContext context) implements CacheTracer.CacheSpan
    {
        public void recordSuccess() {
            this.span.setStatus(StatusCode.OK);
            this.span.end();
            OpentelemetryContext.set((Context)this.currentContext, (OpentelemetryContext)this.context);
        }

        public void recordFailure(@Nullable Throwable throwable) {
            if (throwable != null) {
                this.span.recordException(throwable);
            }
            this.span.setStatus(StatusCode.ERROR);
            this.span.end();
            OpentelemetryContext.set((Context)this.currentContext, (OpentelemetryContext)this.context);
        }
    }
}

