/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.opentelemetry.module.db;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.annotation.Nullable;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.database.common.QueryContext;
import ru.tinkoff.kora.database.common.telemetry.DataBaseTracer;
import ru.tinkoff.kora.opentelemetry.common.OpentelemetryContext;

public final class OpentelemetryDataBaseTracer
implements DataBaseTracer {
    private final Tracer tracer;
    private final String dbSystem;
    @Nullable
    private final String connectionString;
    private final String user;

    public OpentelemetryDataBaseTracer(Tracer tracer, String dbType, @Nullable String connectionString, String user) {
        this.tracer = tracer;
        this.dbSystem = OpentelemetryDataBaseTracer.toDbSystem(dbType);
        this.connectionString = connectionString;
        this.user = user;
    }

    private static String toDbSystem(String type) {
        return switch (type) {
            case "as400", "db2" -> "db2";
            case "derby" -> "derby";
            case "h2" -> "h2";
            case "hsqldb" -> "hsqldb";
            case "mariadb" -> "mariadb";
            case "mysql" -> "mysql";
            case "oracle" -> "oracle";
            case "postgresql", "postgres" -> "postgresql";
            case "jtds", "microsoft", "sqlserver" -> "mssql";
            default -> "other_sql";
        };
    }

    public DataBaseTracer.DataBaseSpan createQuerySpan(Context ctx, QueryContext queryContext) {
        OpentelemetryContext otctx = OpentelemetryContext.get((Context)ctx);
        SpanBuilder builder = this.tracer.spanBuilder(queryContext.operation()).setSpanKind(SpanKind.CLIENT).setParent(otctx.getContext()).setAttribute(SemanticAttributes.DB_SYSTEM, (Object)this.dbSystem).setAttribute(SemanticAttributes.DB_USER, (Object)this.user).setAttribute(SemanticAttributes.DB_STATEMENT, (Object)queryContext.queryId());
        if (this.connectionString != null) {
            builder.setAttribute(SemanticAttributes.DB_CONNECTION_STRING, (Object)this.connectionString);
        }
        Span span = builder.startSpan();
        OpentelemetryContext.set((Context)ctx, (OpentelemetryContext)otctx.add((ImplicitContextKeyed)span));
        return ex -> {
            if (ex != null) {
                span.recordException(ex);
                span.setStatus(StatusCode.ERROR);
            }
            span.end();
            OpentelemetryContext.set((Context)ctx, (OpentelemetryContext)otctx);
        };
    }

    public DataBaseTracer.DataBaseSpan createCallSpan(QueryContext queryContext) {
        Context ctx = Context.current();
        OpentelemetryContext otctx = OpentelemetryContext.get((Context)ctx);
        SpanBuilder builder = this.tracer.spanBuilder(queryContext.operation()).setSpanKind(SpanKind.CLIENT).setParent(otctx.getContext()).setAttribute(SemanticAttributes.DB_SYSTEM, (Object)this.dbSystem).setAttribute(SemanticAttributes.DB_USER, (Object)this.user).setAttribute(SemanticAttributes.DB_STATEMENT, (Object)queryContext.queryId());
        if (this.connectionString != null) {
            builder.setAttribute(SemanticAttributes.DB_CONNECTION_STRING, (Object)this.connectionString);
        }
        Span span = builder.startSpan();
        OpentelemetryContext.set((Context)ctx, (OpentelemetryContext)otctx.add((ImplicitContextKeyed)span));
        return ex -> {
            if (ex != null) {
                span.recordException(ex);
                span.setStatus(StatusCode.ERROR);
            }
            span.end();
            OpentelemetryContext.set((Context)ctx, (OpentelemetryContext)otctx);
        };
    }
}

