/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.opentelemetry.module.grpc.server;

import io.grpc.Status;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.annotation.Nullable;
import java.util.concurrent.atomic.AtomicLong;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerTracer;

public final class OpentelemetryGrpcServerSpan
implements GrpcServerTracer.GrpcServerSpan {
    private final Span span;
    private final AtomicLong sentCounter = new AtomicLong(0L);
    private final AtomicLong receivedCounter = new AtomicLong(0L);

    public OpentelemetryGrpcServerSpan(Span span) {
        this.span = span;
    }

    public void close(Status status, @Nullable Throwable exception) {
        if (exception != null) {
            this.span.recordException(exception);
            this.span.setStatus(StatusCode.ERROR);
        }
        this.span.end();
    }

    public void addSend(Object message) {
        this.span.addEvent("message", Attributes.of((AttributeKey)SemanticAttributes.MESSAGE_TYPE, (Object)"SENT", (AttributeKey)SemanticAttributes.MESSAGE_ID, (Object)this.sentCounter.incrementAndGet()));
    }

    public void addReceive(Object message) {
        this.span.addEvent("message", Attributes.of((AttributeKey)SemanticAttributes.MESSAGE_TYPE, (Object)"RECEIVED", (AttributeKey)SemanticAttributes.MESSAGE_ID, (Object)this.receivedCounter.incrementAndGet()));
    }
}

