/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.opentelemetry.module.grpc.server;

import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.annotation.Nullable;
import java.net.SocketAddress;
import ru.tinkoff.kora.grpc.server.telemetry.GrpcServerTracer;
import ru.tinkoff.kora.opentelemetry.common.OpentelemetryContext;
import ru.tinkoff.kora.opentelemetry.module.grpc.server.OpentelemetryGrpcServerSpan;

public final class OpentelemetryGrpcServerTracer
implements GrpcServerTracer {
    private final Tracer tracer;

    public OpentelemetryGrpcServerTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public GrpcServerTracer.GrpcServerSpan createSpan(ServerCall<?, ?> call, Metadata headers, String serviceName, String methodName) {
        String ipAddress = ((SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR)).toString();
        ru.tinkoff.kora.common.Context context = ru.tinkoff.kora.common.Context.current();
        Context parentCtx = W3CTraceContextPropagator.getInstance().extract(Context.root(), (Object)headers, (TextMapGetter)GrpcHeaderMapGetter.INSTANCE);
        Span span = this.tracer.spanBuilder(serviceName + "/" + methodName).setSpanKind(SpanKind.SERVER).setParent(parentCtx).setAttribute(SemanticAttributes.RPC_SYSTEM, (Object)"grpc").setAttribute(SemanticAttributes.RPC_SERVICE, (Object)serviceName).setAttribute(SemanticAttributes.RPC_METHOD, (Object)methodName).setAttribute(SemanticAttributes.NET_SOCK_PEER_ADDR, (Object)ipAddress).startSpan();
        OpentelemetryContext.set((ru.tinkoff.kora.common.Context)context, (OpentelemetryContext)OpentelemetryContext.get((ru.tinkoff.kora.common.Context)context).add((ImplicitContextKeyed)span));
        return new OpentelemetryGrpcServerSpan(span);
    }

    private static enum GrpcHeaderMapGetter implements TextMapGetter<Metadata>
    {
        INSTANCE;


        public Iterable<String> keys(Metadata carrier) {
            return carrier.keys();
        }

        @Nullable
        public String get(@Nullable Metadata carrier, String key) {
            return (String)carrier.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        }
    }
}

