/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.opentelemetry.module.http.client;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.semconv.SemanticAttributes;
import java.net.URI;
import java.net.URISyntaxException;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.telemetry.HttpClientTracer;
import ru.tinkoff.kora.http.common.header.MutableHttpHeaders;
import ru.tinkoff.kora.opentelemetry.common.OpentelemetryContext;

public final class OpentelemetryHttpClientTracer
implements HttpClientTracer {
    private final Tracer tracer;

    public OpentelemetryHttpClientTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public HttpClientTracer.HttpClientSpan createSpan(Context ctx, HttpClientRequest request) {
        OpentelemetryContext otctx = OpentelemetryContext.get((Context)ctx);
        SpanBuilder builder = this.tracer.spanBuilder(OpentelemetryHttpClientTracer.operation(request.method(), request.uriTemplate(), request.uri())).setSpanKind(SpanKind.CLIENT).setParent(otctx.getContext());
        URI targetUri = request.uri();
        if (targetUri.getRawUserInfo() != null || targetUri.getRawQuery() != null) {
            try {
                targetUri = new URI(targetUri.getScheme(), null, targetUri.getHost(), targetUri.getPort(), targetUri.getPath(), null, targetUri.getFragment());
            }
            catch (URISyntaxException e) {
                targetUri = null;
            }
        }
        builder.setAttribute(SemanticAttributes.HTTP_REQUEST_METHOD, (Object)request.method());
        if (targetUri != null) {
            builder.setAttribute(SemanticAttributes.SERVER_ADDRESS, (Object)targetUri.getHost());
            builder.setAttribute(SemanticAttributes.SERVER_PORT, (Object)targetUri.getPort());
            builder.setAttribute(SemanticAttributes.URL_SCHEME, (Object)targetUri.getScheme());
            builder.setAttribute(SemanticAttributes.URL_FULL, (Object)targetUri.toString());
        }
        Span span = builder.startSpan();
        OpentelemetryContext newCtx = otctx.add((ImplicitContextKeyed)span);
        OpentelemetryContext.set((Context)ctx, (OpentelemetryContext)newCtx);
        W3CTraceContextPropagator.getInstance().inject(newCtx.getContext(), (Object)request.headers(), MutableHttpHeaders::set);
        return (code, exception) -> {
            span.setAttribute(SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, code);
            if (exception != null) {
                span.recordException(exception);
                span.setStatus(StatusCode.ERROR);
            }
            span.end();
        };
    }

    private static String operation(String method, String uriTemplate, URI uri) {
        int questionMark;
        if (uri.getAuthority() != null && uri.getScheme() != null) {
            uriTemplate = uriTemplate.replace(uri.getScheme() + "://" + uri.getAuthority(), "");
        }
        if ((questionMark = uriTemplate.indexOf(63)) >= 0) {
            uriTemplate = uriTemplate.substring(0, questionMark);
        }
        return method + " " + uriTemplate;
    }
}

