/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.opentelemetry.module.http.server;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.tinkoff.kora.http.common.HttpResultCode;
import ru.tinkoff.kora.http.server.common.HttpServerResponse;
import ru.tinkoff.kora.http.server.common.router.PublicApiRequest;
import ru.tinkoff.kora.http.server.common.telemetry.HttpServerTracer;
import ru.tinkoff.kora.opentelemetry.common.OpentelemetryContext;

public final class OpentelemetryHttpServerTracer
implements HttpServerTracer {
    private final Tracer tracer;

    public OpentelemetryHttpServerTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public <T> void inject(ru.tinkoff.kora.common.Context context, T headers, HttpServerTracer.HeadersSetter<T> headersSetter) {
        W3CTraceContextPropagator.getInstance().inject(OpentelemetryContext.get((ru.tinkoff.kora.common.Context)context).getContext(), headers, (arg_0, arg_1, arg_2) -> headersSetter.set(arg_0, arg_1, arg_2));
    }

    public HttpServerTracer.HttpServerSpan createSpan(String template, PublicApiRequest routerRequest) {
        ru.tinkoff.kora.common.Context context = ru.tinkoff.kora.common.Context.current();
        Context parentCtx = W3CTraceContextPropagator.getInstance().extract(Context.root(), (Object)routerRequest, (TextMapGetter)PublicApiRequestTextMapGetter.INSTANCE);
        Span span = this.tracer.spanBuilder(routerRequest.method() + " " + template).setSpanKind(SpanKind.SERVER).setParent(parentCtx).setAttribute(SemanticAttributes.HTTP_REQUEST_METHOD, (Object)routerRequest.method()).setAttribute(SemanticAttributes.URL_SCHEME, (Object)routerRequest.scheme()).setAttribute(SemanticAttributes.SERVER_ADDRESS, (Object)routerRequest.hostName()).setAttribute(SemanticAttributes.URL_PATH, (Object)routerRequest.path()).setAttribute(SemanticAttributes.HTTP_ROUTE, (Object)template).startSpan();
        OpentelemetryContext.set((ru.tinkoff.kora.common.Context)context, (OpentelemetryContext)OpentelemetryContext.get((ru.tinkoff.kora.common.Context)context).add((ImplicitContextKeyed)span));
        return (statusCode, resultCode, exception) -> {
            if (statusCode >= 500 || resultCode == HttpResultCode.CONNECTION_ERROR || exception != null && !(exception instanceof HttpServerResponse)) {
                span.setStatus(StatusCode.ERROR);
            }
            if (exception != null) {
                span.recordException(exception);
            }
            if (statusCode >= 0) {
                span.setAttribute(SemanticAttributes.HTTP_RESPONSE_STATUS_CODE, statusCode);
            }
            span.end();
        };
    }

    private static class PublicApiRequestTextMapGetter
    implements TextMapGetter<PublicApiRequest> {
        private static final PublicApiRequestTextMapGetter INSTANCE = new PublicApiRequestTextMapGetter();

        private PublicApiRequestTextMapGetter() {
        }

        public Iterable<String> keys(final PublicApiRequest carrier) {
            return () -> new Iterator<String>(){
                final Iterator<Map.Entry<String, List<String>>> i;
                {
                    this.i = carrier.headers().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public String next() {
                    return this.i.next().getKey();
                }
            };
        }

        public String get(PublicApiRequest carrier, String key) {
            return carrier.headers().getFirst(key);
        }
    }
}

