/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.opentelemetry.module.jms.consumer;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import ru.tinkoff.kora.jms.telemetry.JmsConsumerTracer;
import ru.tinkoff.kora.opentelemetry.common.OpentelemetryContext;

public class OpentelemetryJmsConsumerTracer
implements JmsConsumerTracer {
    private final Tracer tracer;

    public OpentelemetryJmsConsumerTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public JmsConsumerTracer.JmsConsumerSpan get(Message message) throws JMSException {
        Destination destination = message.getJMSDestination();
        String destinationString = "unknown";
        String destinationKind = "unknown";
        if (destination instanceof Queue) {
            Queue queue = (Queue)destination;
            destinationString = queue.getQueueName();
            destinationKind = "queue";
        } else if (destination instanceof Topic) {
            Topic topic = (Topic)destination;
            destinationString = topic.getTopicName();
            destinationKind = "topic";
        }
        Context root = Context.root();
        Context parent = W3CTraceContextPropagator.getInstance().extract(root, (Object)message, (TextMapGetter)MessageTextMapGetter.INSTANCE);
        ru.tinkoff.kora.common.Context context = ru.tinkoff.kora.common.Context.current();
        SpanBuilder recordSpanBuilder = this.tracer.spanBuilder(destinationString + " receive").setSpanKind(SpanKind.CONSUMER).setAttribute(SemanticAttributes.MESSAGING_SYSTEM, (Object)"jms").setAttribute(SemanticAttributes.MESSAGING_DESTINATION_NAME, (Object)destinationString).setAttribute(SemanticAttributes.MESSAGING_DESTINATION_KIND, (Object)destinationKind).setAttribute(SemanticAttributes.MESSAGING_MESSAGE_ID, (Object)message.getJMSMessageID());
        if (parent != root) {
            recordSpanBuilder.setParent(parent);
        }
        Span span = recordSpanBuilder.startSpan();
        OpentelemetryContext.set((ru.tinkoff.kora.common.Context)context, (OpentelemetryContext)OpentelemetryContext.get((ru.tinkoff.kora.common.Context)context).add((ImplicitContextKeyed)span));
        return e -> {
            if (e != null) {
                span.recordException((Throwable)e);
                span.setStatus(StatusCode.ERROR);
            }
            span.end();
        };
    }

    private static enum MessageTextMapGetter implements TextMapGetter<Message>
    {
        INSTANCE;


        public Iterable<String> keys(Message carrier) {
            try {
                Enumeration enumeration = carrier.getPropertyNames();
                ArrayList<String> headers = new ArrayList<String>();
                while (enumeration.hasMoreElements()) {
                    String nextElement = (String)enumeration.nextElement();
                    headers.add(nextElement);
                }
                return headers;
            }
            catch (JMSException e) {
                return List.of();
            }
        }

        @Nullable
        public String get(@Nullable Message carrier, String key) {
            try {
                return carrier.getStringProperty(key);
            }
            catch (JMSException e) {
                return null;
            }
        }
    }
}

