/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.opentelemetry.module.kafka.consumer;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.kafka.common.producer.telemetry.KafkaProducerTracer;
import ru.tinkoff.kora.opentelemetry.common.OpentelemetryContext;

public class OpentelemetryKafkaProducerTracer
implements KafkaProducerTracer {
    private final Tracer tracer;

    public OpentelemetryKafkaProducerTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public KafkaProducerTracer.KafkaProducerRecordSpan get(ProducerRecord<?, ?> record) {
        Context ctx = Context.current();
        OpentelemetryContext otctx = OpentelemetryContext.get((Context)ctx);
        Span span = this.tracer.spanBuilder(record.topic() + " send").setSpanKind(SpanKind.PRODUCER).setParent(otctx.getContext()).setAttribute(SemanticAttributes.MESSAGING_SYSTEM, (Object)"kafka").setAttribute(SemanticAttributes.MESSAGING_OPERATION, (Object)"publish").setAttribute(SemanticAttributes.MESSAGING_DESTINATION_NAME, (Object)record.topic()).startSpan();
        W3CTraceContextPropagator.getInstance().inject(otctx.getContext().with((ImplicitContextKeyed)span), record, (TextMapSetter)ProducerRecordTextMapSetter.INSTANCE);
        return new OpentelemetryKafkaProducerRecordSpan(span);
    }

    public KafkaProducerTracer.KafkaProducerTxSpan tx() {
        Context ctx = Context.current();
        OpentelemetryContext otctx = OpentelemetryContext.get((Context)ctx);
        Span span = this.tracer.spanBuilder("producer transaction").setSpanKind(SpanKind.INTERNAL).setParent(otctx.getContext()).setAttribute(SemanticAttributes.MESSAGING_SYSTEM, (Object)"kafka").startSpan();
        OpentelemetryContext.set((Context)ctx, (OpentelemetryContext)otctx.add((ImplicitContextKeyed)span));
        return new OpentelemetryKafkaProducerTxSpan(ctx, otctx, span);
    }

    private static enum ProducerRecordTextMapSetter implements TextMapSetter<ProducerRecord<?, ?>>
    {
        INSTANCE;


        public void set(@Nullable ProducerRecord<?, ?> carrier, String key, String value) {
            carrier.headers().add(key, value.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static final class OpentelemetryKafkaProducerRecordSpan
    implements KafkaProducerTracer.KafkaProducerRecordSpan {
        private final Span span;

        private OpentelemetryKafkaProducerRecordSpan(Span span) {
            this.span = span;
        }

        public void close(RecordMetadata metadata) {
            this.span.setAttribute(SemanticAttributes.MESSAGING_KAFKA_DESTINATION_PARTITION, metadata.partition());
            this.span.setAttribute(SemanticAttributes.MESSAGING_KAFKA_MESSAGE_OFFSET, (Object)metadata.offset());
            this.span.end();
        }

        public void close(Throwable e) {
            this.span.setAttribute(SemanticAttributes.ERROR_TYPE, (Object)e.getClass().getName());
            this.span.setStatus(StatusCode.ERROR);
            this.span.recordException(e);
            this.span.end();
        }
    }

    private static final class OpentelemetryKafkaProducerTxSpan
    implements KafkaProducerTracer.KafkaProducerTxSpan {
        private final Context context;
        private final OpentelemetryContext ctx;
        private final Span span;

        private OpentelemetryKafkaProducerTxSpan(Context context, OpentelemetryContext ctx, Span span) {
            this.context = context;
            this.ctx = ctx;
            this.span = span;
        }

        public void commit() {
            this.span.end();
            OpentelemetryContext.set((Context)this.context, (OpentelemetryContext)this.ctx);
        }

        public void rollback(Throwable e) {
            this.span.recordException(e);
            this.span.setStatus(StatusCode.ERROR);
            this.span.end();
            OpentelemetryContext.set((Context)this.context, (OpentelemetryContext)this.ctx);
        }
    }
}

