/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.opentelemetry.module.scheduling;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.semconv.SemanticAttributes;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.opentelemetry.common.OpentelemetryContext;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingTracer;

public class OpentelemetrySchedulingTracer
implements SchedulingTracer {
    private final Tracer tracer;
    private final String className;
    private final String methodName;

    public OpentelemetrySchedulingTracer(Tracer tracer, String className, String methodName) {
        this.tracer = tracer;
        this.className = className;
        this.methodName = methodName;
    }

    public SchedulingTracer.SchedulingSpan createSpan(Context ctx) {
        Context context = Context.current();
        Span span = this.tracer.spanBuilder(this.className + " " + this.methodName).setSpanKind(SpanKind.INTERNAL).setAttribute(SemanticAttributes.CODE_FUNCTION, (Object)this.methodName).setAttribute(SemanticAttributes.CODE_FILEPATH, (Object)this.className).startSpan();
        OpentelemetryContext.set((Context)context, (OpentelemetryContext)OpentelemetryContext.get((Context)context).add((ImplicitContextKeyed)span));
        return exception -> {
            if (exception != null) {
                span.recordException(exception);
            }
            span.end();
        };
    }
}

