/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.opentelemetry.module.scheduling;

import io.opentelemetry.api.trace.Tracer;
import jakarta.annotation.Nullable;
import java.util.Objects;
import ru.tinkoff.kora.opentelemetry.module.scheduling.OpentelemetrySchedulingTracer;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingTracer;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingTracerFactory;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public class OpentelemetrySchedulingTracerFactory
implements SchedulingTracerFactory {
    private final Tracer tracer;

    public OpentelemetrySchedulingTracerFactory(Tracer tracer) {
        this.tracer = tracer;
    }

    @Nullable
    public SchedulingTracer get(TelemetryConfig.TracingConfig tracing, Class<?> jobClass, String jobMethod) {
        if (Objects.requireNonNullElse(tracing.enabled(), true).booleanValue()) {
            return new OpentelemetrySchedulingTracer(this.tracer, jobClass.getCanonicalName(), jobMethod);
        }
        return null;
    }
}

