/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.annotation.processor.aop;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;

public class CircuitBreakerKoraAspect
implements KoraAspect {
    private static final String ANNOTATION_TYPE = "ru.tinkoff.kora.resilient.circuitbreaker.annotation.CircuitBreaker";
    private static final ClassName PERMITTED_EXCEPTION = ClassName.get((String)"ru.tinkoff.kora.resilient.circuitbreaker", (String)"CallNotPermittedException", (String[])new String[0]);
    private final ProcessingEnvironment env;

    public CircuitBreakerKoraAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ANNOTATION_TYPE);
    }

    public KoraAspect.ApplyResult apply(ExecutableElement method, String superCall, KoraAspect.AspectContext aspectContext) {
        Optional<AnnotationMirror> mirror = method.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(ANNOTATION_TYPE)).findFirst();
        String circuitBreakerName = (String)mirror.flatMap(a -> a.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("value")).map(e -> String.valueOf(((AnnotationValue)e.getValue()).getValue())).findFirst()).orElseThrow();
        DeclaredType managerType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement("ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreakerManager"), new TypeMirror[0]);
        String fieldManager = aspectContext.fieldFactory().constructorParam((TypeMirror)managerType, List.of());
        DeclaredType circuitType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement("ru.tinkoff.kora.resilient.circuitbreaker.CircuitBreaker"), new TypeMirror[0]);
        String fieldCircuit = aspectContext.fieldFactory().constructorInitialized((TypeMirror)circuitType, CodeBlock.of((String)"$L.get($S)", (Object[])new Object[]{fieldManager, circuitBreakerName}));
        CodeBlock body = MethodUtils.isMono((ExecutableElement)method) ? this.buildBodyMono(method, superCall, fieldCircuit) : (MethodUtils.isFlux((ExecutableElement)method) ? this.buildBodyFlux(method, superCall, fieldCircuit) : (MethodUtils.isFuture((ExecutableElement)method) ? this.buildBodyFuture(method, superCall, fieldCircuit) : this.buildBodySync(method, superCall, fieldCircuit)));
        return new KoraAspect.ApplyResult.MethodBody(body);
    }

    private CodeBlock buildBodySync(ExecutableElement method, String superCall, String cbField) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        CodeBlock methodCall = MethodUtils.isVoid((ExecutableElement)method) ? superMethod : CodeBlock.of((String)"var _result = $L", (Object[])new Object[]{superMethod.toString()});
        CodeBlock returnCall = MethodUtils.isVoid((ExecutableElement)method) ? CodeBlock.of((String)"return", (Object[])new Object[0]) : CodeBlock.of((String)"return _result", (Object[])new Object[]{superMethod.toString()});
        return CodeBlock.builder().add("try {\n    $L.acquire();\n    $L;\n    $L.releaseOnSuccess();\n    $L;\n} catch ($T _e) {\n    throw _e;\n} catch (Exception _e) {\n    $L.releaseOnError(_e);\n    throw _e;\n}\n", new Object[]{cbField, methodCall.toString(), cbField, returnCall.toString(), PERMITTED_EXCEPTION, cbField}).build();
    }

    private CodeBlock buildBodyFuture(ExecutableElement method, String superCall, String cbField) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        return CodeBlock.builder().add("try {\n    $L.acquire();\n    return $L.thenApply(_result -> {\n                $L.releaseOnSuccess();\n                return _result;\n            })\n            .exceptionally(_e -> {\n                if (_e instanceof $T ce) {\n                    _e = ce.getCause();\n                }\n                $L.releaseOnError(_e);\n                if(_e instanceof $T _ex) {\n                    throw _ex;\n                }\n                throw new $T(_e);\n            });\n} catch ($T _e) {\n    return $T.failedFuture(_e);\n} catch (Exception _e) {\n    $L.releaseOnError(_e);\n    throw _e;\n}\n", new Object[]{cbField, superMethod, cbField, CompletionException.class, cbField, RuntimeException.class, CompletionException.class, PERMITTED_EXCEPTION, CompletableFuture.class, cbField}).build();
    }

    private CodeBlock buildBodyMono(ExecutableElement method, String superCall, String cbField) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        return CodeBlock.builder().add("return $T.defer(() -> {\n      $L.acquire();\n      return $L\n          .doOnSuccess(r -> $L.releaseOnSuccess())\n          .doOnCancel($L::releaseOnSuccess)\n          .doOnError($L::releaseOnError);\n});\n", new Object[]{CommonClassNames.mono, cbField, superMethod.toString(), cbField, cbField, cbField}).build();
    }

    private CodeBlock buildBodyFlux(ExecutableElement method, String superCall, String cbField) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        return CodeBlock.builder().add("return $T.defer(() -> {\n      $L.acquire();\n      return $L\n          .doOnComplete($L::releaseOnSuccess)\n          .doOnCancel($L::releaseOnSuccess)\n          .doOnError($L::releaseOnError);\n});\n", new Object[]{CommonClassNames.flux, cbField, superMethod.toString(), cbField, cbField, cbField}).build();
    }

    private CodeBlock buildMethodCall(ExecutableElement method, String call) {
        return (CodeBlock)method.getParameters().stream().map(p -> CodeBlock.of((String)"$L", (Object[])new Object[]{p})).collect(CodeBlock.joining((String)", ", (String)(call + "("), (String)")"));
    }
}

