/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.annotation.processor.aop;

import com.squareup.javapoet.CodeBlock;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;
import ru.tinkoff.kora.resilient.annotation.processor.aop.FallbackMeta;

public class FallbackKoraAspect
implements KoraAspect {
    private static final String ANNOTATION_TYPE = "ru.tinkoff.kora.resilient.fallback.annotation.Fallback";
    private final ProcessingEnvironment env;

    public FallbackKoraAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ANNOTATION_TYPE);
    }

    public KoraAspect.ApplyResult apply(ExecutableElement method, String superCall, KoraAspect.AspectContext aspectContext) {
        Optional<AnnotationMirror> mirror = method.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(ANNOTATION_TYPE)).findFirst();
        FallbackMeta fallback = mirror.flatMap(a -> a.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("method")).map(e -> String.valueOf(((AnnotationValue)e.getValue()).getValue())).findFirst().filter(v -> !v.isBlank())).map(v -> FallbackMeta.ofFallbackMethod(v, method)).orElseThrow(() -> new IllegalStateException("Method argument for @Fallback is mandatory!"));
        String name = (String)mirror.flatMap(a -> a.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("value")).map(e -> String.valueOf(((AnnotationValue)e.getValue()).getValue())).findFirst()).orElseThrow();
        DeclaredType managerType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement("ru.tinkoff.kora.resilient.fallback.FallbackManager"), new TypeMirror[0]);
        String fieldManager = aspectContext.fieldFactory().constructorParam((TypeMirror)managerType, List.of());
        DeclaredType fallbackType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement("ru.tinkoff.kora.resilient.fallback.Fallback"), new TypeMirror[0]);
        String fieldFallback = aspectContext.fieldFactory().constructorInitialized((TypeMirror)fallbackType, CodeBlock.of((String)"$L.get($S)", (Object[])new Object[]{fieldManager, name}));
        CodeBlock body = MethodUtils.isMono((ExecutableElement)method) ? this.buildBodyMono(method, fallback, superCall, fieldFallback) : (MethodUtils.isFlux((ExecutableElement)method) ? this.buildBodyFlux(method, fallback, superCall, fieldFallback) : (MethodUtils.isFuture((ExecutableElement)method) ? this.buildBodyFuture(method, fallback, superCall, fieldFallback) : this.buildBodySync(method, fallback, superCall, fieldFallback)));
        return new KoraAspect.ApplyResult.MethodBody(body);
    }

    private CodeBlock buildBodySync(ExecutableElement method, FallbackMeta fallbackCall, String superCall, String fieldFallback) {
        String fallbackMethod = fallbackCall.call();
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            CodeBlock superMethod = this.buildMethodCall(method, superCall);
            return CodeBlock.builder().add("try {\n    $L;\n} catch (Exception _e) {\n    if ($L.canFallback(_e)) {\n        $L;\n    } else {\n        throw _e;\n    }\n}\n", new Object[]{superMethod.toString(), fieldFallback, fallbackMethod}).build();
        }
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        return CodeBlock.builder().add("try {\n    return $L;\n} catch (Exception _e) {\n    if ($L.canFallback(_e)) {\n        return $L;\n    } else {\n        throw _e;\n    }\n}\n", new Object[]{superMethod.toString(), fieldFallback, fallbackMethod}).build();
    }

    private CodeBlock buildBodyFuture(ExecutableElement method, FallbackMeta fallbackCall, String superCall, String fieldFallback) {
        String fallbackMethod = fallbackCall.call();
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        return CodeBlock.builder().add("return $L.exceptionallyCompose(_e -> {\n    if (_e instanceof $T ce) {\n        _e = ce.getCause();\n    }\n    if ($L.canFallback(_e)) {\n        return $L;\n    }\n    return $T.failedFuture(new $T(_e));\n});", new Object[]{superMethod.toString(), CompletionException.class, fieldFallback, fallbackMethod, CompletableFuture.class, CompletionException.class}).build();
    }

    private CodeBlock buildBodyMono(ExecutableElement method, FallbackMeta fallbackCall, String superCall, String fieldFallback) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        String fallbackMethod = fallbackCall.call();
        return CodeBlock.builder().add("return $L.onErrorResume($L::canFallback, _e -> $L);\n", new Object[]{superMethod.toString(), fieldFallback, fallbackMethod}).build();
    }

    private CodeBlock buildBodyFlux(ExecutableElement method, FallbackMeta fallbackCall, String superCall, String fieldFallback) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        String fallbackMethod = fallbackCall.call();
        return CodeBlock.builder().add("return $L.onErrorResume($L::canFallback, _e -> $L);\n", new Object[]{superMethod.toString(), fieldFallback, fallbackMethod}).build();
    }

    private CodeBlock buildMethodCall(ExecutableElement method, String call) {
        return (CodeBlock)method.getParameters().stream().map(p -> CodeBlock.of((String)"$L", (Object[])new Object[]{p})).collect(CodeBlock.joining((String)", ", (String)(call + "("), (String)")"));
    }
}

