/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.annotation.processor.aop;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import ru.tinkoff.kora.annotation.processor.common.ProcessingError;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;

record FallbackMeta(String method, List<String> arguments) {
    static FallbackMeta ofFallbackMethod(@Nonnull String fallbackSignature, @Nonnull ExecutableElement sourceMethod) {
        List<String> illegalArgs;
        int argStarted = fallbackSignature.indexOf(40);
        int argEnd = fallbackSignature.indexOf(41);
        if (argStarted == -1 || argEnd == -1) {
            throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, "Fallback method doesn't have proper signature like 'myMethod()' or 'myMethod(arg1, arg2)' but was: " + fallbackSignature, (Element)sourceMethod));
        }
        Set sourceArgs = sourceMethod.getParameters().stream().map(p -> p.getSimpleName().toString()).collect(Collectors.toSet());
        List<String> fallbackArgs = Arrays.stream(fallbackSignature.substring(argStarted + 1, fallbackSignature.length() - 1).split(",")).map(String::trim).filter(a -> !a.isEmpty()).toList();
        if (!fallbackArgs.isEmpty() && !(illegalArgs = fallbackArgs.stream().filter(a -> !sourceArgs.contains(a)).toList()).isEmpty()) {
            throw new ProcessingErrorException(new ProcessingError(Diagnostic.Kind.ERROR, "Fallback method specifies illegal arguments " + illegalArgs + ", available arguments: " + sourceArgs, (Element)sourceMethod));
        }
        return new FallbackMeta(fallbackSignature.substring(0, argStarted), fallbackArgs);
    }

    public String call() {
        return this.toString();
    }

    @Override
    public String toString() {
        return this.method + "(" + String.join((CharSequence)", ", this.arguments) + ")";
    }
}

