/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.annotation.processor.aop;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;

public class RetryKoraAspect
implements KoraAspect {
    private static final ClassName REACTOR_RETRY_BUILDER = ClassName.get((String)"ru.tinkoff.kora.resilient.retry", (String)"KoraRetryReactorBuilder", (String[])new String[0]);
    private static final ClassName REACTOR_RETRY = ClassName.get((String)"reactor.util.retry", (String)"Retry", (String[])new String[0]);
    private static final ClassName RETRY_EXCEPTION = ClassName.get((String)"ru.tinkoff.kora.resilient.retry", (String)"RetryExhaustedException", (String[])new String[0]);
    private static final String ANNOTATION_TYPE = "ru.tinkoff.kora.resilient.retry.annotation.Retry";
    private static final ClassName RETRY_STATE = ClassName.get((String)"ru.tinkoff.kora.resilient.retry", (String)"Retry", (String[])new String[]{"RetryState", "RetryStatus"});
    private final ProcessingEnvironment env;

    public RetryKoraAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ANNOTATION_TYPE);
    }

    public KoraAspect.ApplyResult apply(ExecutableElement method, String superCall, KoraAspect.AspectContext aspectContext) {
        CodeBlock body;
        Optional<AnnotationMirror> mirror = method.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(ANNOTATION_TYPE)).findFirst();
        String retryableName = (String)mirror.flatMap(a -> a.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("value")).map(e -> String.valueOf(((AnnotationValue)e.getValue()).getValue())).findFirst()).orElseThrow();
        if (MethodUtils.isMono((ExecutableElement)method)) {
            DeclaredType reactorBuilderType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement(REACTOR_RETRY_BUILDER.canonicalName()), new TypeMirror[0]);
            String reactorBuilderField = aspectContext.fieldFactory().constructorParam((TypeMirror)reactorBuilderType, List.of());
            DeclaredType retrierType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement(REACTOR_RETRY.canonicalName()), new TypeMirror[0]);
            String fieldRetrier = aspectContext.fieldFactory().constructorInitialized((TypeMirror)retrierType, CodeBlock.of((String)"$L.get($S)", (Object[])new Object[]{reactorBuilderField, retryableName}));
            body = this.buildBodyMono(method, superCall, fieldRetrier);
        } else if (MethodUtils.isFlux((ExecutableElement)method)) {
            DeclaredType reactorBuilderType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement(REACTOR_RETRY_BUILDER.canonicalName()), new TypeMirror[0]);
            String reactorBuilderField = aspectContext.fieldFactory().constructorParam((TypeMirror)reactorBuilderType, List.of());
            DeclaredType retrierType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement(REACTOR_RETRY.canonicalName()), new TypeMirror[0]);
            String fieldRetrier = aspectContext.fieldFactory().constructorInitialized((TypeMirror)retrierType, CodeBlock.of((String)"$L.get($S)", (Object[])new Object[]{reactorBuilderField, retryableName}));
            body = this.buildBodyFlux(method, superCall, fieldRetrier);
        } else if (MethodUtils.isFuture((ExecutableElement)method)) {
            DeclaredType managerType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement("ru.tinkoff.kora.resilient.retry.RetryManager"), new TypeMirror[0]);
            String fieldManager = aspectContext.fieldFactory().constructorParam((TypeMirror)managerType, List.of());
            DeclaredType retrierType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement("ru.tinkoff.kora.resilient.retry.Retry"), new TypeMirror[0]);
            String fieldRetrier = aspectContext.fieldFactory().constructorInitialized((TypeMirror)retrierType, CodeBlock.of((String)"$L.get($S)", (Object[])new Object[]{fieldManager, retryableName}));
            body = this.buildBodyFuture(method, superCall, fieldRetrier);
        } else {
            DeclaredType managerType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement("ru.tinkoff.kora.resilient.retry.RetryManager"), new TypeMirror[0]);
            String fieldManager = aspectContext.fieldFactory().constructorParam((TypeMirror)managerType, List.of());
            DeclaredType retrierType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement("ru.tinkoff.kora.resilient.retry.Retry"), new TypeMirror[0]);
            String fieldRetrier = aspectContext.fieldFactory().constructorInitialized((TypeMirror)retrierType, CodeBlock.of((String)"$L.get($S)", (Object[])new Object[]{fieldManager, retryableName}));
            body = this.buildBodySync(method, superCall, fieldRetrier);
        }
        return new KoraAspect.ApplyResult.MethodBody(body);
    }

    private CodeBlock buildBodySync(ExecutableElement method, String superCall, String fieldRetry) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            builder.addStatement("$L.retry(() -> $L)", new Object[]{fieldRetry, this.buildMethodCall(method, superCall)});
        } else {
            builder.addStatement("return $L.retry(() -> $L)", new Object[]{fieldRetry, this.buildMethodCall(method, superCall)});
        }
        return builder.build();
    }

    private CodeBlock buildBodyFuture(ExecutableElement method, String superCall, String fieldRetry) {
        CodeBlock.Builder builder = CodeBlock.builder();
        CodeBlock methodCall = this.buildMethodCall(method, superCall);
        builder.add("return $L.retry(() -> $L)", new Object[]{fieldRetry, methodCall});
        if (CompletableFuture.class.getCanonicalName().equals(((DeclaredType)method.getReturnType()).asElement().toString())) {
            builder.add(".toCompletableFuture()", new Object[0]);
        }
        builder.add(";\n", new Object[0]);
        return builder.build();
    }

    private CodeBlock buildBodyMono(ExecutableElement method, String superCall, String fieldRetry) {
        return CodeBlock.builder().add("return $L.retryWhen($L);\n", new Object[]{this.buildMethodCall(method, superCall), fieldRetry}).build();
    }

    private CodeBlock buildBodyFlux(ExecutableElement method, String superCall, String fieldRetry) {
        return CodeBlock.builder().add("return $L.retryWhen($L);\n", new Object[]{this.buildMethodCall(method, superCall), fieldRetry}).build();
    }

    private CodeBlock buildMethodCall(ExecutableElement method, String call) {
        return (CodeBlock)method.getParameters().stream().map(p -> CodeBlock.of((String)"$L", (Object[])new Object[]{p})).collect(CodeBlock.joining((String)", ", (String)(call + "("), (String)")"));
    }
}

