/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.annotation.processor.aop;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import ru.tinkoff.kora.annotation.processor.common.MethodUtils;
import ru.tinkoff.kora.aop.annotation.processor.KoraAspect;

public class TimeoutKoraAspect
implements KoraAspect {
    private static final String ANNOTATION_TYPE = "ru.tinkoff.kora.resilient.timeout.annotation.Timeout";
    private static final ClassName EXHAUSTED_EXCEPTION = ClassName.get((String)"ru.tinkoff.kora.resilient.timeout", (String)"TimeoutExhaustedException", (String[])new String[0]);
    private final ProcessingEnvironment env;

    public TimeoutKoraAspect(ProcessingEnvironment env) {
        this.env = env;
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ANNOTATION_TYPE);
    }

    public KoraAspect.ApplyResult apply(ExecutableElement method, String superCall, KoraAspect.AspectContext aspectContext) {
        Optional<AnnotationMirror> mirror = method.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(ANNOTATION_TYPE)).findFirst();
        String timeoutName = (String)mirror.flatMap(a -> a.getElementValues().entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals("value")).map(e -> String.valueOf(((AnnotationValue)e.getValue()).getValue())).findFirst()).orElseThrow();
        DeclaredType managerType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement("ru.tinkoff.kora.resilient.timeout.TimeoutManager"), new TypeMirror[0]);
        String fieldManager = aspectContext.fieldFactory().constructorParam((TypeMirror)managerType, List.of());
        DeclaredType metricsType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement("ru.tinkoff.kora.resilient.timeout.TimeoutMetrics"), new TypeMirror[0]);
        String fieldMetrics = aspectContext.fieldFactory().constructorParam((TypeMirror)metricsType, List.of(AnnotationSpec.builder(Nullable.class).build()));
        DeclaredType timeouterType = this.env.getTypeUtils().getDeclaredType(this.env.getElementUtils().getTypeElement("ru.tinkoff.kora.resilient.timeout.Timeout"), new TypeMirror[0]);
        String fieldTimeout = aspectContext.fieldFactory().constructorInitialized((TypeMirror)timeouterType, CodeBlock.of((String)"$L.get($S)", (Object[])new Object[]{fieldManager, timeoutName}));
        CodeBlock body = MethodUtils.isMono((ExecutableElement)method) ? this.buildBodyMono(method, superCall, timeoutName, fieldTimeout, fieldMetrics) : (MethodUtils.isFlux((ExecutableElement)method) ? this.buildBodyFlux(method, superCall, timeoutName, fieldTimeout, fieldMetrics) : (MethodUtils.isFuture((ExecutableElement)method) ? this.buildBodyFuture(method, superCall, timeoutName, fieldTimeout, fieldMetrics) : this.buildBodySync(method, superCall, fieldTimeout)));
        return new KoraAspect.ApplyResult.MethodBody(body);
    }

    private CodeBlock buildBodySync(ExecutableElement method, String superCall, String timeoutName) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        if (MethodUtils.isVoid((ExecutableElement)method)) {
            return CodeBlock.builder().add("$L.execute(() -> {\n    $L;\n    return null;\n});\n", new Object[]{timeoutName, superMethod.toString()}).build();
        }
        return CodeBlock.builder().add("return $L.execute(() -> $L);\n", new Object[]{timeoutName, superMethod.toString()}).build();
    }

    private CodeBlock buildBodyFuture(ExecutableElement method, String superCall, String timeoutName, String fieldTimeout, String fieldMetrics) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        return CodeBlock.builder().add("return $L.toCompletableFuture()\n    .orTimeout($L.timeout().toMillis(), $T.MILLISECONDS)\n    .exceptionally(e -> {\n      if (e instanceof $T ce) {\n          e = ce.getCause();\n      }\n      if(e instanceof $T) {\n        if($L != null) {\n            $L.recordTimeout($S, $L.timeout().toNanos());\n        }\n        throw new $T($S, \"Timeout exceeded \" + $L.timeout());\n      } else if(e instanceof $T ex) {\n        throw ex;\n      }\n      throw new $T(e);\n    });", new Object[]{superMethod.toString(), fieldTimeout, TimeUnit.class, CompletionException.class, TimeoutException.class, fieldMetrics, fieldMetrics, timeoutName, fieldTimeout, EXHAUSTED_EXCEPTION, timeoutName, fieldTimeout, RuntimeException.class, CompletionException.class}).build();
    }

    private CodeBlock buildBodyMono(ExecutableElement method, String superCall, String timeoutName, String fieldTimeout, String fieldMetrics) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        return CodeBlock.builder().add("return $L\n    .timeout($L.timeout())\n    .onErrorMap(e -> e instanceof $T, e -> new $T($S, \"Timeout exceeded \" + $L.timeout()))\n    .doOnError(e -> {\n        if(e instanceof $T && $L != null) {\n            $L.recordTimeout($S, $L.timeout().toNanos());\n        }\n    });\n", new Object[]{superMethod.toString(), fieldTimeout, TimeoutException.class, EXHAUSTED_EXCEPTION, timeoutName, fieldTimeout, EXHAUSTED_EXCEPTION, fieldMetrics, fieldMetrics, timeoutName, fieldTimeout}).build();
    }

    private CodeBlock buildBodyFlux(ExecutableElement method, String superCall, String timeoutName, String fieldTimeout, String fieldMetrics) {
        CodeBlock superMethod = this.buildMethodCall(method, superCall);
        return CodeBlock.builder().add("return $L\n    .timeout($L.timeout())\n    .onErrorMap(e -> e instanceof $T, e -> new $T($S, \"Timeout exceeded \" + $L.timeout()))\n    .doOnError(e -> {\n        if(e instanceof $T && $L != null) {\n            $L.recordTimeout($S, $L.timeout().toNanos());\n        }\n    });\n", new Object[]{superMethod.toString(), fieldTimeout, TimeoutException.class, EXHAUSTED_EXCEPTION, timeoutName, fieldTimeout, EXHAUSTED_EXCEPTION, fieldMetrics, fieldMetrics, timeoutName, fieldTimeout}).build();
    }

    private CodeBlock buildMethodCall(ExecutableElement method, String call) {
        return (CodeBlock)method.getParameters().stream().map(p -> CodeBlock.of((String)"$L", (Object[])new Object[]{p})).collect(CodeBlock.joining((String)", ", (String)(call + "("), (String)")"));
    }
}

