/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.timeout;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;
import ru.tinkoff.kora.resilient.timeout.$TimeoutConfig_NamedConfig_ConfigValueExtractor;

@ConfigValueExtractor
public interface TimeoutConfig {
    public static final String DEFAULT = "default";

    default public Map<String, NamedConfig> timeout() {
        return Map.of();
    }

    default public NamedConfig getNamedConfig(@Nonnull String name) {
        Objects.requireNonNull(name);
        if (this.timeout() == null) {
            throw new IllegalStateException("Timeout no configuration is provided, but either '" + name + "' or 'default' config is required");
        }
        NamedConfig defaultConfig = this.timeout().get(DEFAULT);
        NamedConfig namedConfig = this.timeout().getOrDefault(name, defaultConfig);
        if (namedConfig == null) {
            throw new IllegalStateException("Timeout no configuration is provided, but either '" + name + "' or 'default' config is required");
        }
        NamedConfig mergedConfig = TimeoutConfig.merge(namedConfig, defaultConfig);
        if (mergedConfig.duration() == null) {
            throw new IllegalStateException("Timeout 'duration' is not configured in either '" + name + "' or 'default' config");
        }
        return mergedConfig;
    }

    private static NamedConfig merge(NamedConfig namedConfig, NamedConfig defaultConfig) {
        if (defaultConfig == null) {
            return namedConfig;
        }
        return new $TimeoutConfig_NamedConfig_ConfigValueExtractor.NamedConfig_Impl(namedConfig.enabled() != null ? Boolean.TRUE.equals(namedConfig.enabled()) : defaultConfig.enabled() == null || Boolean.TRUE.equals(defaultConfig.enabled()), namedConfig.duration() == null ? defaultConfig.duration() : namedConfig.duration());
    }

    @ConfigValueExtractor
    public static interface NamedConfig {
        @Nullable
        public Boolean enabled();

        @Nullable
        public Duration duration();
    }
}

