/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.timeout;

import jakarta.annotation.Nonnull;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import ru.tinkoff.kora.application.graph.Lifecycle;

public class TimeoutExecutor
implements Lifecycle {
    private final Executor executorService;

    public TimeoutExecutor(Executor executorService) {
        this.executorService = executorService;
    }

    @Nonnull
    public Executor executor() {
        return this.executorService;
    }

    public void init() {
    }

    public void release() {
        Executor executor = this.executorService;
        if (executor instanceof ExecutorService) {
            ExecutorService es = (ExecutorService)executor;
            TimeoutExecutor.closeExecutorService(es);
        }
    }

    private static void closeExecutorService(ExecutorService executorService) {
        boolean terminated = executorService.isTerminated();
        if (!terminated) {
            executorService.shutdown();
            boolean interrupted = false;
            while (!terminated) {
                try {
                    terminated = executorService.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    if (interrupted) continue;
                    executorService.shutdownNow();
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

