/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.scheduling.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.scheduling.annotation.processor.SchedulingTrigger;

public class JdkSchedulingGenerator {
    public static ClassName scheduleAtFixedRate = ClassName.get((String)"ru.tinkoff.kora.scheduling.jdk.annotation", (String)"ScheduleAtFixedRate", (String[])new String[0]);
    public static ClassName scheduleOnce = ClassName.get((String)"ru.tinkoff.kora.scheduling.jdk.annotation", (String)"ScheduleOnce", (String[])new String[0]);
    public static ClassName scheduleWithFixedDelay = ClassName.get((String)"ru.tinkoff.kora.scheduling.jdk.annotation", (String)"ScheduleWithFixedDelay", (String[])new String[0]);
    private static final ClassName fixedDelayJobClassName = ClassName.get((String)"ru.tinkoff.kora.scheduling.jdk", (String)"FixedDelayJob", (String[])new String[0]);
    private static final ClassName fixedRateJobClassName = ClassName.get((String)"ru.tinkoff.kora.scheduling.jdk", (String)"FixedRateJob", (String[])new String[0]);
    private static final ClassName runOnceJobClassName = ClassName.get((String)"ru.tinkoff.kora.scheduling.jdk", (String)"RunOnceJob", (String[])new String[0]);
    private static final ClassName schedulingTelemetryFactoryClassName = ClassName.get((String)"ru.tinkoff.kora.scheduling.common.telemetry", (String)"SchedulingTelemetryFactory", (String[])new String[0]);
    private static final ClassName jdkSchedulingExecutor = ClassName.get((String)"ru.tinkoff.kora.scheduling.jdk", (String)"JdkSchedulingExecutor", (String[])new String[0]);
    private final Elements elements;
    private final ProcessingEnvironment processingEnv;

    public JdkSchedulingGenerator(ProcessingEnvironment processingEnv) {
        this.elements = processingEnv.getElementUtils();
        this.processingEnv = processingEnv;
    }

    public void generate(TypeElement type, Element method, TypeSpec.Builder module, SchedulingTrigger trigger) {
        ClassName triggerTypeName = ClassName.get((TypeElement)((TypeElement)trigger.triggerAnnotation().getAnnotationType().asElement()));
        if (triggerTypeName.equals((Object)scheduleAtFixedRate)) {
            this.generateScheduleAtFixedRate(type, method, module, trigger);
            return;
        }
        if (triggerTypeName.equals((Object)scheduleWithFixedDelay)) {
            this.generateScheduleWithFixedDelay(type, method, module, trigger);
            return;
        }
        if (triggerTypeName.equals((Object)scheduleOnce)) {
            this.generateScheduleOnce(type, method, module, trigger);
            return;
        }
        throw new IllegalStateException("Unknown trigger type: " + String.valueOf(trigger.triggerAnnotation().getAnnotationType()));
    }

    private void generateScheduleOnce(TypeElement type, Element method, TypeSpec.Builder module, SchedulingTrigger trigger) {
        String packageName = this.elements.getPackageOf(type).getQualifiedName().toString();
        String configName = (String)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"config");
        String configClassName = NameUtils.generatedType((Element)type, (String)(String.valueOf(method.getSimpleName()) + "_Config"));
        String jobMethodName = NameUtils.generatedType((Element)type, (String)(String.valueOf(method.getSimpleName()) + "_Job"));
        Long delay = (Long)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"delay");
        VariableElement unit = (VariableElement)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"unit");
        MethodSpec.Builder componentMethod = MethodSpec.methodBuilder((String)jobMethodName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addParameter((TypeName)schedulingTelemetryFactoryClassName, "telemetryFactory", new Modifier[0]).addParameter((TypeName)jdkSchedulingExecutor, "service", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)CommonClassNames.valueOf, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)type.asType())}), "object", new Modifier[0]).returns((TypeName)runOnceJobClassName).addAnnotation(CommonClassNames.root);
        if (configName.isEmpty()) {
            if (delay == null || delay == 0L) {
                throw new ProcessingErrorException("Either delay() or config() annotation parameter must be provided", method, trigger.triggerAnnotation());
            }
            componentMethod.addCode("var telemetry = telemetryFactory.get(null, $T.class, $S);\n", new Object[]{type, method.getSimpleName()}).addCode("var delay = $T.of($L, $T.$L);\n", new Object[]{Duration.class, delay, ChronoUnit.class, unit});
        } else {
            TypeSpec.Builder config = TypeSpec.interfaceBuilder((String)configClassName).addOriginatingElement(method).addAnnotation(AnnotationUtils.generated(JdkSchedulingGenerator.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(CommonClassNames.configValueExtractorAnnotation).addMethod(MethodSpec.methodBuilder((String)"telemetry").returns((TypeName)CommonClassNames.telemetryConfig).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
            if (delay == null || delay == 0L) {
                config.addMethod(MethodSpec.methodBuilder((String)"delay").returns(Duration.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
            } else {
                config.addMethod(MethodSpec.methodBuilder((String)"delay").returns(Duration.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addStatement("return $T.of($L, $T.$L)", new Object[]{Duration.class, delay, ChronoUnit.class, unit}).build());
            }
            module.addMethod(JdkSchedulingGenerator.configComponent(packageName, configClassName, configName));
            CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)JavaFile.builder((String)packageName, (TypeSpec)config.build()).build());
            componentMethod.addParameter((TypeName)ClassName.get((String)packageName, (String)configClassName, (String[])new String[0]), "config", new Modifier[0]);
            componentMethod.addCode("var telemetry = telemetryFactory.get(config.telemetry(), $T.class, $S);\n", new Object[]{type, method.getSimpleName()});
            componentMethod.addCode("var delay = config.delay();\n", new Object[0]);
        }
        componentMethod.addCode("return new $T(telemetry, service, () -> object.get().$N(), delay);\n", new Object[]{runOnceJobClassName, method.getSimpleName()});
        module.addMethod(componentMethod.build());
    }

    private void generateScheduleWithFixedDelay(TypeElement type, Element method, TypeSpec.Builder module, SchedulingTrigger trigger) {
        String packageName = this.elements.getPackageOf(type).getQualifiedName().toString();
        String configName = (String)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"config");
        String configClassName = NameUtils.generatedType((Element)type, (String)(String.valueOf(method.getSimpleName()) + "_Config"));
        String jobMethodName = NameUtils.generatedType((Element)type, (String)(String.valueOf(method.getSimpleName()) + "_Job"));
        Long initialDelay = (Long)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"initialDelay");
        Long delay = (Long)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"delay");
        VariableElement unit = (VariableElement)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"unit");
        MethodSpec.Builder componentMethod = MethodSpec.methodBuilder((String)jobMethodName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addParameter((TypeName)schedulingTelemetryFactoryClassName, "telemetryFactory", new Modifier[0]).addParameter((TypeName)jdkSchedulingExecutor, "service", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)CommonClassNames.valueOf, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)type.asType())}), "object", new Modifier[0]).returns((TypeName)fixedDelayJobClassName).addAnnotation(CommonClassNames.root);
        if (configName.isEmpty()) {
            if (delay == null || delay == 0L) {
                throw new ProcessingErrorException("Either delay() or config() annotation parameter must be provided", method, trigger.triggerAnnotation());
            }
            componentMethod.addCode("var telemetry = telemetryFactory.get(null, $T.class, $S);\n", new Object[]{type, method.getSimpleName()}).addCode("var initialDelay = $T.of($L, $T.$L);\n", new Object[]{Duration.class, initialDelay, ChronoUnit.class, unit}).addCode("var delay = $T.of($L, $T.$L);\n", new Object[]{Duration.class, delay, ChronoUnit.class, unit});
        } else {
            TypeSpec.Builder config = TypeSpec.interfaceBuilder((String)configClassName).addOriginatingElement(method).addAnnotation(AnnotationUtils.generated(JdkSchedulingGenerator.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(CommonClassNames.configValueExtractorAnnotation).addMethod(MethodSpec.methodBuilder((String)"telemetry").returns((TypeName)CommonClassNames.telemetryConfig).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
            componentMethod.addParameter((TypeName)ClassName.get((String)packageName, (String)configClassName, (String[])new String[0]), "config", new Modifier[0]);
            if (delay == null || delay == 0L) {
                config.addMethod(MethodSpec.methodBuilder((String)"delay").returns(Duration.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
            } else {
                config.addMethod(MethodSpec.methodBuilder((String)"delay").returns(Duration.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addStatement("return $T.of($L, $T.$L)", new Object[]{Duration.class, delay, ChronoUnit.class, unit}).build());
            }
            config.addMethod(MethodSpec.methodBuilder((String)"initialDelay").returns(Duration.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addStatement("return $T.of($L, $T.$L)", new Object[]{Duration.class, initialDelay, ChronoUnit.class, unit}).build());
            module.addMethod(JdkSchedulingGenerator.configComponent(packageName, configClassName, configName));
            CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)JavaFile.builder((String)packageName, (TypeSpec)config.build()).build());
            componentMethod.addCode("var telemetry = telemetryFactory.get(config.telemetry(), $T.class, $S);\n", new Object[]{type, method.getSimpleName()}).addCode("var initialDelay = config.initialDelay();\n", new Object[0]).addCode("var delay = config.delay();\n", new Object[0]);
        }
        componentMethod.addCode("return new $T(telemetry, service, () -> object.get().$N(), initialDelay, delay);\n", new Object[]{fixedDelayJobClassName, method.getSimpleName()});
        module.addMethod(componentMethod.build());
    }

    private void generateScheduleAtFixedRate(TypeElement type, Element method, TypeSpec.Builder module, SchedulingTrigger trigger) {
        String packageName = this.elements.getPackageOf(type).getQualifiedName().toString();
        String configName = (String)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"config");
        String configClassName = NameUtils.generatedType((Element)type, (String)(String.valueOf(method.getSimpleName()) + "_Config"));
        String jobMethodName = NameUtils.generatedType((Element)type, (String)(String.valueOf(method.getSimpleName()) + "_Job"));
        Long initialDelay = (Long)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"initialDelay");
        Long period = (Long)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"period");
        VariableElement unit = (VariableElement)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"unit");
        MethodSpec.Builder componentMethod = MethodSpec.methodBuilder((String)jobMethodName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addParameter((TypeName)schedulingTelemetryFactoryClassName, "telemetryFactory", new Modifier[0]).addParameter((TypeName)jdkSchedulingExecutor, "service", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)CommonClassNames.valueOf, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)type.asType())}), "object", new Modifier[0]).returns((TypeName)fixedRateJobClassName).addAnnotation(CommonClassNames.root);
        if (configName.isEmpty()) {
            if (period == null || period == 0L) {
                throw new ProcessingErrorException("Either period() or config() annotation parameter must be provided", method, trigger.triggerAnnotation());
            }
            componentMethod.addCode("var telemetry = telemetryFactory.get(null, $T.class, $S);\n", new Object[]{type, method.getSimpleName()}).addCode("var initialDelay = $T.of($L, $T.$L);\n", new Object[]{Duration.class, initialDelay, ChronoUnit.class, unit}).addCode("var period = $T.of($L, $T.$L);\n", new Object[]{Duration.class, period, ChronoUnit.class, unit});
        } else {
            TypeSpec.Builder config = TypeSpec.interfaceBuilder((String)configClassName).addOriginatingElement(method).addAnnotation(AnnotationUtils.generated(JdkSchedulingGenerator.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(CommonClassNames.configValueExtractorAnnotation).addMethod(MethodSpec.methodBuilder((String)"telemetry").returns((TypeName)CommonClassNames.telemetryConfig).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
            if (period == null || period == 0L) {
                config.addMethod(MethodSpec.methodBuilder((String)"period").returns(Duration.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
            } else {
                config.addMethod(MethodSpec.methodBuilder((String)"period").returns(Duration.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addStatement("return $T.of($L, $T.$L)", new Object[]{Duration.class, period, ChronoUnit.class, unit}).build());
            }
            config.addMethod(MethodSpec.methodBuilder((String)"initialDelay").returns(Duration.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addStatement("return $T.of($L, $T.$L)", new Object[]{Duration.class, initialDelay, ChronoUnit.class, unit}).build());
            module.addMethod(JdkSchedulingGenerator.configComponent(packageName, configClassName, configName));
            CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)JavaFile.builder((String)packageName, (TypeSpec)config.build()).build());
            componentMethod.addParameter((TypeName)ClassName.get((String)packageName, (String)configClassName, (String[])new String[0]), "config", new Modifier[0]);
            componentMethod.addCode("var telemetry = telemetryFactory.get(config.telemetry(), $T.class, $S);\n", new Object[]{type, method.getSimpleName()}).addCode("var initialDelay = config.initialDelay();\n", new Object[0]).addCode("var period = config.period();\n", new Object[0]);
        }
        componentMethod.addCode("return new $T(telemetry, service, () -> object.get().$N(), initialDelay, period);\n", new Object[]{fixedRateJobClassName, method.getSimpleName()});
        module.addMethod(componentMethod.build());
    }

    private static MethodSpec configComponent(String packageName, String configClassName, String configPath) {
        return MethodSpec.methodBuilder((String)configClassName).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC}).addParameter((TypeName)CommonClassNames.config, "config", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)"ru.tinkoff.kora.config.common.extractor", (String)"ConfigValueExtractor", (String[])new String[0]), (TypeName[])new TypeName[]{ClassName.get((String)packageName, (String)configClassName, (String[])new String[0])}), "extractor", new Modifier[0]).addCode("var configValue = config.get($S);\n", new Object[]{configPath}).addStatement("return $T.ofNullable(extractor.extract(configValue)).orElseThrow(() -> $T.missingValueAfterParse(configValue))", new Object[]{Optional.class, CommonClassNames.configValueExtractionException}).returns((TypeName)ClassName.get((String)packageName, (String)configClassName, (String[])new String[0])).build();
    }
}

