/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.scheduling.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.scheduling.annotation.processor.JdkSchedulingGenerator;
import ru.tinkoff.kora.scheduling.annotation.processor.QuartzSchedulingGenerator;
import ru.tinkoff.kora.scheduling.annotation.processor.SchedulerType;
import ru.tinkoff.kora.scheduling.annotation.processor.SchedulingTrigger;

public class KoraSchedulingAnnotationProcessor
extends AbstractKoraProcessor {
    private static final Map<SchedulerType, List<ClassName>> triggerTypes = Map.of(SchedulerType.JDK, List.of(JdkSchedulingGenerator.scheduleOnce, JdkSchedulingGenerator.scheduleAtFixedRate, JdkSchedulingGenerator.scheduleWithFixedDelay), SchedulerType.QUARTZ, List.of(QuartzSchedulingGenerator.scheduleWithCron, QuartzSchedulingGenerator.scheduleWithTrigger));
    private static final Set<ClassName> triggers = Set.of(JdkSchedulingGenerator.scheduleOnce, JdkSchedulingGenerator.scheduleAtFixedRate, JdkSchedulingGenerator.scheduleWithFixedDelay, QuartzSchedulingGenerator.scheduleWithCron, QuartzSchedulingGenerator.scheduleWithTrigger);
    private JdkSchedulingGenerator jdkGenerator;
    private QuartzSchedulingGenerator quartzGenerator;

    public Set<ClassName> getSupportedAnnotationClassNames() {
        return triggers;
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.jdkGenerator = new JdkSchedulingGenerator(processingEnv);
        this.quartzGenerator = new QuartzSchedulingGenerator(processingEnv);
    }

    public void process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Map<ClassName, List<AbstractKoraProcessor.AnnotatedElement>> annotatedElements) {
        TypeElement[] triggers = (TypeElement[])annotations.stream().filter(te -> {
            for (ClassName trigger : triggers) {
                if (!te.getQualifiedName().contentEquals(trigger.canonicalName())) continue;
                return true;
            }
            return false;
        }).toArray(TypeElement[]::new);
        Set<? extends Element> scheduledMethods = roundEnv.getElementsAnnotatedWithAny(triggers);
        Map<String, List<Element>> scheduledTypes = scheduledMethods.stream().collect(Collectors.groupingBy(e -> {
            TypeElement type = (TypeElement)e.getEnclosingElement();
            return type.getQualifiedName().toString();
        }));
        for (Map.Entry<String, List<Element>> entry : scheduledTypes.entrySet()) {
            List<Element> methods = entry.getValue();
            TypeElement type = (TypeElement)entry.getValue().get(0).getEnclosingElement();
            try {
                this.generateModule(type, methods);
            }
            catch (ProcessingErrorException e2) {
                e2.printError(this.processingEnv);
            }
        }
    }

    private void generateModule(TypeElement type, List<? extends Element> methods) {
        TypeSpec.Builder module = TypeSpec.interfaceBuilder((String)("$" + String.valueOf(type.getSimpleName()) + "_SchedulingModule")).addOriginatingElement((Element)type).addAnnotation(AnnotationUtils.generated(KoraSchedulingAnnotationProcessor.class)).addAnnotation(CommonClassNames.module).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Element element : methods) {
            ExecutableElement m = (ExecutableElement)element;
            SchedulingTrigger trigger = this.parseSchedulerType(element);
            switch (trigger.schedulerType()) {
                case JDK: {
                    this.jdkGenerator.generate(type, element, module, trigger);
                    break;
                }
                case QUARTZ: {
                    this.quartzGenerator.generate(type, m, module, trigger);
                }
            }
        }
        String packageName = this.elements.getPackageOf(type).getQualifiedName().toString();
        JavaFile.Builder builder = JavaFile.builder((String)packageName, (TypeSpec)module.build());
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)builder.build());
    }

    private SchedulingTrigger parseSchedulerType(Element method) {
        for (Map.Entry<SchedulerType, List<ClassName>> entry : triggerTypes.entrySet()) {
            SchedulerType schedulerType = entry.getKey();
            for (ClassName annotationType : entry.getValue()) {
                AnnotationMirror annotation = AnnotationUtils.findAnnotation((Elements)this.elements, (Element)method, (ClassName)annotationType);
                if (annotation == null) continue;
                return new SchedulingTrigger(schedulerType, annotation);
            }
        }
        throw new IllegalStateException();
    }
}

