/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.scheduling.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.annotation.processor.common.ProcessingErrorException;
import ru.tinkoff.kora.scheduling.annotation.processor.JdkSchedulingGenerator;
import ru.tinkoff.kora.scheduling.annotation.processor.SchedulingTrigger;

public class QuartzSchedulingGenerator {
    public static ClassName scheduleWithTrigger = ClassName.get((String)"ru.tinkoff.kora.scheduling.quartz", (String)"ScheduleWithTrigger", (String[])new String[0]);
    public static ClassName scheduleWithCron = ClassName.get((String)"ru.tinkoff.kora.scheduling.quartz", (String)"ScheduleWithCron", (String[])new String[0]);
    private static final ClassName koraQuartzJobClassName = ClassName.get((String)"ru.tinkoff.kora.scheduling.quartz", (String)"KoraQuartzJob", (String[])new String[0]);
    private static final ClassName schedulingTelemetryClassName = ClassName.get((String)"ru.tinkoff.kora.scheduling.common.telemetry", (String)"SchedulingTelemetry", (String[])new String[0]);
    private static final ClassName schedulingTelemetryFactoryClassName = ClassName.get((String)"ru.tinkoff.kora.scheduling.common.telemetry", (String)"SchedulingTelemetryFactory", (String[])new String[0]);
    private static final ClassName triggerClassName = ClassName.get((String)"org.quartz", (String)"Trigger", (String[])new String[0]);
    private static final ClassName schedulerClassName = ClassName.get((String)"org.quartz", (String)"Scheduler", (String[])new String[0]);
    private static final ClassName triggerBuilderClassName = ClassName.get((String)"org.quartz", (String)"TriggerBuilder", (String[])new String[0]);
    private static final ClassName cronScheduleBuilderClassName = ClassName.get((String)"org.quartz", (String)"CronScheduleBuilder", (String[])new String[0]);
    private final Elements elements;
    private final ProcessingEnvironment processingEnv;

    public QuartzSchedulingGenerator(ProcessingEnvironment processingEnv) {
        this.elements = processingEnv.getElementUtils();
        this.processingEnv = processingEnv;
    }

    public void generate(TypeElement type, ExecutableElement method, TypeSpec.Builder module, SchedulingTrigger trigger) {
        ClassName jobClassName = this.generateJobClass(type, method);
        TypeMirror typeMirror = type.asType();
        MethodSpec.Builder component = MethodSpec.methodBuilder((String)(String.valueOf(type.getSimpleName()) + "_" + String.valueOf(method.getSimpleName()) + "_Job")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)jobClassName).addParameter((TypeName)schedulingTelemetryFactoryClassName, "telemetryFactory", new Modifier[0]).addParameter(TypeName.get((TypeMirror)typeMirror), "object", new Modifier[0]);
        ClassName annotationType = ClassName.get((TypeElement)((TypeElement)trigger.triggerAnnotation().getAnnotationType().asElement()));
        if (annotationType.equals((Object)scheduleWithTrigger)) {
            AnnotationMirror tag = (AnnotationMirror)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"value");
            ParameterSpec triggerParameter = ParameterSpec.builder((TypeName)triggerClassName, (String)"trigger", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.get((AnnotationMirror)tag)).build();
            component.addParameter(triggerParameter);
            component.addCode("var telemetry = telemetryFactory.get(null, $T.class, $S);\n", new Object[]{typeMirror, method.getSimpleName().toString()});
        } else if (annotationType.equals((Object)scheduleWithCron)) {
            String identity = Optional.ofNullable((String)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"identity")).filter(Predicate.not(String::isBlank)).orElse(String.valueOf(type.getQualifiedName()) + "#" + String.valueOf(method.getSimpleName()));
            String cron = (String)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"value");
            CodeBlock cronSchedule = CodeBlock.of((String)"$S", (Object[])new Object[]{cron});
            String configPath = (String)AnnotationUtils.parseAnnotationValue((Elements)this.elements, (AnnotationMirror)trigger.triggerAnnotation(), (String)"config");
            if (configPath != null && !configPath.isBlank()) {
                ClassName configClassName = this.generateCronConfigRecord(type, method, cron);
                MethodSpec.Builder b = MethodSpec.methodBuilder((String)configClassName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)configClassName).addParameter((TypeName)CommonClassNames.config, "config", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)CommonClassNames.configValueExtractor, (TypeName[])new TypeName[]{configClassName}), "extractor", new Modifier[0]);
                if (cron != null && !cron.isBlank()) {
                    b.addStatement("var value = config.get($S)", new Object[]{configPath});
                    b.beginControlFlow("if (value instanceof $T.NullValue)", new Object[]{CommonClassNames.configValue}).addCode("return extractor.extract($>\n", new Object[0]).addCode("new $T.ObjectValue(value.origin(), $T.of($S, new $T.StringValue(value.origin(), $S)))", new Object[]{CommonClassNames.configValue, Map.class, "cron", CommonClassNames.configValue, cron}).addCode("$<\n);\n", new Object[0]).endControlFlow();
                } else {
                    b.addStatement("var value = config.get($S)", new Object[]{configPath});
                }
                b.beginControlFlow("if (value instanceof $T.StringValue str)", new Object[]{CommonClassNames.configValue}).addStatement("var cron = str.value()", new Object[0]).addCode("return extractor.extract($>\n", new Object[0]).addCode("new $T.ObjectValue(value.origin(), $T.of($S, new $T.StringValue(value.origin(), cron)))", new Object[]{CommonClassNames.configValue, Map.class, "cron", CommonClassNames.configValue}).addCode("$<\n);\n", new Object[0]).nextControlFlow("else if (value instanceof $T.ObjectValue obj)", new Object[]{CommonClassNames.configValue}).addStatement("return extractor.extract(obj)", new Object[0]).nextControlFlow("else", new Object[0]).addStatement("throw ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException.unexpectedValueType(value, $T.StringValue.class)", new Object[]{CommonClassNames.configValue}).endControlFlow();
                module.addMethod(b.build());
                component.addParameter((TypeName)configClassName, "config", new Modifier[0]);
                cronSchedule = CodeBlock.of((String)"config.cron()", (Object[])new Object[0]);
            } else if (cron == null || cron.isBlank()) {
                throw new ProcessingErrorException("Either value() or config() annotation parameter must be provided", (Element)method, trigger.triggerAnnotation());
            }
            component.addCode("var trigger = $T.newTrigger()\n  .withIdentity($S)\n  .withSchedule($T.cronSchedule($L))\n  .startAt(new $T(0))\n  .build();\n".stripIndent(), new Object[]{triggerBuilderClassName, identity, cronScheduleBuilderClassName, cronSchedule.toString(), Date.class});
            if (configPath != null && !configPath.isBlank()) {
                component.addCode("var telemetry = telemetryFactory.get(config.telemetry(), $T.class, $S);\n", new Object[]{typeMirror, method.getSimpleName().toString()});
            } else {
                component.addCode("var telemetry = telemetryFactory.get(null, $T.class, $S);\n", new Object[]{typeMirror, method.getSimpleName().toString()});
            }
        } else {
            throw new IllegalStateException();
        }
        component.addCode("return new $T(telemetry, object, trigger);\n", new Object[]{jobClassName});
        module.addMethod(component.build());
    }

    private ClassName generateCronConfigRecord(TypeElement type, ExecutableElement method, String defaultCron) {
        String configRecordName = NameUtils.getOuterClassesAsPrefix((Element)method) + "CronConfig";
        String packageName = this.elements.getPackageOf(type).getQualifiedName().toString();
        TypeSpec.Builder config = TypeSpec.interfaceBuilder((String)configRecordName).addOriginatingElement((Element)method).addAnnotation(AnnotationUtils.generated(JdkSchedulingGenerator.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(CommonClassNames.configValueExtractorAnnotation).addMethod(MethodSpec.methodBuilder((String)"telemetry").returns((TypeName)CommonClassNames.telemetryConfig).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
        if (defaultCron != null && !defaultCron.isBlank()) {
            config.addMethod(MethodSpec.methodBuilder((String)"cron").returns(String.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addStatement("return $S", new Object[]{defaultCron}).build());
        } else {
            config.addMethod(MethodSpec.methodBuilder((String)"cron").returns(String.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
        }
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)JavaFile.builder((String)packageName, (TypeSpec)config.build()).build());
        return ClassName.get((String)packageName, (String)configRecordName, (String[])new String[0]);
    }

    private ClassName generateJobClass(TypeElement type, ExecutableElement method) {
        String className = NameUtils.generatedType((Element)type, (String)(String.valueOf(method.getSimpleName()) + "_Job"));
        String packageName = this.elements.getPackageOf(type).getQualifiedName().toString();
        TypeMirror typeMirror = type.asType();
        CodeBlock callJob = method.getParameters().isEmpty() ? CodeBlock.of((String)"ctx -> object.$L()", (Object[])new Object[]{method.getSimpleName()}) : CodeBlock.of((String)"object::$L", (Object[])new Object[]{method.getSimpleName()});
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)className).addOriginatingElement((Element)method).addAnnotation(AnnotationUtils.generated(QuartzSchedulingGenerator.class)).superclass((TypeName)koraQuartzJobClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField(TypeName.get((TypeMirror)typeMirror), "object", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)schedulingTelemetryClassName, "telemetry", new Modifier[0]).addParameter(TypeName.get((TypeMirror)typeMirror), "object", new Modifier[0]).addParameter((TypeName)triggerClassName, "trigger", new Modifier[0]).addCode("super(telemetry, $L, trigger);\n", new Object[]{callJob}).addCode("this.object = object;\n", new Object[0]).build());
        ClassName quartzDisallowConcurrentExecution = ClassName.get((String)"org.quartz", (String)"DisallowConcurrentExecution", (String[])new String[0]);
        ClassName koraDisallowConcurrentExecution = ClassName.get((String)"ru.tinkoff.kora.scheduling.quartz", (String)"DisallowConcurrentExecution", (String[])new String[0]);
        if (AnnotationUtils.isAnnotationPresent((Element)type, (ClassName)quartzDisallowConcurrentExecution) || AnnotationUtils.isAnnotationPresent((Element)method, (ClassName)koraDisallowConcurrentExecution)) {
            typeSpec.addAnnotation(quartzDisallowConcurrentExecution);
        }
        ClassName quartzPersistJobData = ClassName.get((String)"org.quartz", (String)"PersistJobDataAfterExecution", (String[])new String[0]);
        ClassName koraPersistJobData = ClassName.get((String)"ru.tinkoff.kora.scheduling.quartz", (String)"PersistJobDataAfterExecution", (String[])new String[0]);
        if (AnnotationUtils.isAnnotationPresent((Element)type, (ClassName)quartzPersistJobData) || AnnotationUtils.isAnnotationPresent((Element)method, (ClassName)koraPersistJobData)) {
            typeSpec.addAnnotation(quartzPersistJobData);
        }
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec.build()).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)javaFile);
        return ClassName.get((String)packageName, (String)className, (String[])new String[0]);
    }
}

