/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.scheduling.common.telemetry;

import jakarta.annotation.Nullable;
import java.util.Objects;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingLogger;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingMetrics;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingTelemetry;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingTracer;

public final class DefaultSchedulingTelemetry
implements SchedulingTelemetry {
    @Nullable
    private final SchedulingMetrics metrics;
    @Nullable
    private final SchedulingTracer tracer;
    @Nullable
    private final SchedulingLogger logger;
    private final Class<?> jobClass;
    private final String jobMethod;

    public DefaultSchedulingTelemetry(Class<?> jobClass, String jobMethod, @Nullable SchedulingMetrics metrics, @Nullable SchedulingTracer tracer, @Nullable SchedulingLogger logger) {
        this.metrics = metrics;
        this.tracer = tracer;
        this.logger = logger;
        this.jobClass = Objects.requireNonNull(jobClass);
        this.jobMethod = Objects.requireNonNull(jobMethod);
    }

    @Override
    public Class<?> jobClass() {
        return this.jobClass;
    }

    @Override
    public String jobMethod() {
        return this.jobMethod;
    }

    @Override
    public SchedulingTelemetry.SchedulingTelemetryContext get(Context ctx) {
        SchedulingTracer.SchedulingSpan span;
        SchedulingMetrics metrics = this.metrics;
        SchedulingLogger logger = this.logger;
        SchedulingTracer tracer = this.tracer;
        if (metrics == null && logger == null && tracer == null) {
            return t -> {};
        }
        SchedulingTracer.SchedulingSpan schedulingSpan = span = tracer == null ? null : tracer.createSpan(ctx);
        if (logger != null) {
            logger.logJobStart();
        }
        return new DefaultTelemetryContext(metrics, span, logger);
    }

    private static class DefaultTelemetryContext
    implements SchedulingTelemetry.SchedulingTelemetryContext {
        private final long start = System.nanoTime();
        @Nullable
        private final SchedulingMetrics metrics;
        @Nullable
        private final SchedulingTracer.SchedulingSpan span;
        @Nullable
        private final SchedulingLogger logger;

        private DefaultTelemetryContext(@Nullable SchedulingMetrics metrics, @Nullable SchedulingTracer.SchedulingSpan span, @Nullable SchedulingLogger logger) {
            this.metrics = metrics;
            this.span = span;
            this.logger = logger;
        }

        @Override
        public void close(@Nullable Throwable exception) {
            long end = System.nanoTime();
            long duration = end - this.start;
            if (this.metrics != null) {
                this.metrics.record(duration, exception);
            }
            if (this.logger != null) {
                this.logger.logJobFinish(duration, exception);
            }
            if (this.span != null) {
                this.span.close(exception);
            }
        }
    }
}

