/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.scheduling.common.telemetry;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.scheduling.common.telemetry.DefaultSchedulingTelemetry;
import ru.tinkoff.kora.scheduling.common.telemetry.JobTelemetryConfig;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingLogger;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingLoggerFactory;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingMetrics;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingMetricsFactory;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingTelemetry;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingTelemetryFactory;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingTracer;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingTracerFactory;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class DefaultSchedulingTelemetryFactory
implements SchedulingTelemetryFactory {
    private final TelemetryConfig config;
    @Nullable
    private final SchedulingMetricsFactory metrics;
    @Nullable
    private final SchedulingTracerFactory tracer;
    @Nullable
    private final SchedulingLoggerFactory logger;

    public DefaultSchedulingTelemetryFactory(TelemetryConfig config, @Nullable SchedulingMetricsFactory metrics, @Nullable SchedulingTracerFactory tracer, @Nullable SchedulingLoggerFactory logger) {
        this.config = config;
        this.metrics = metrics;
        this.tracer = tracer;
        this.logger = logger;
    }

    @Override
    public SchedulingTelemetry get(@Nullable TelemetryConfig jobTelemetryConfig, Class<?> jobClass, String jobMethod) {
        JobTelemetryConfig config = new JobTelemetryConfig(this.config, jobTelemetryConfig);
        SchedulingMetrics metrics = this.metrics == null ? null : this.metrics.get(config.metrics(), jobClass, jobMethod);
        SchedulingTracer tracer = this.tracer == null ? null : this.tracer.get(config.tracing(), jobClass, jobMethod);
        SchedulingLogger logger = this.logger == null ? null : this.logger.get(config.logging(), jobClass, jobMethod);
        return new DefaultSchedulingTelemetry(jobClass, jobMethod, metrics, tracer, logger);
    }
}

