/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.scheduling.common.telemetry;

import jakarta.annotation.Nullable;
import java.util.Objects;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public final class JobTelemetryConfig
implements TelemetryConfig {
    private final OperationLogConfig logging;
    private final OperationMetricConfig metrics;
    private final OperationTracingConfig tracing;

    public JobTelemetryConfig(TelemetryConfig config, @Nullable TelemetryConfig job) {
        this.logging = new OperationLogConfig(config.logging(), job == null ? null : job.logging());
        this.metrics = new OperationMetricConfig(config.metrics(), job == null ? null : job.metrics());
        this.tracing = new OperationTracingConfig(config.tracing(), job == null ? null : job.tracing());
    }

    public TelemetryConfig.LogConfig logging() {
        return this.logging;
    }

    public TelemetryConfig.TracingConfig tracing() {
        return this.tracing;
    }

    public TelemetryConfig.MetricsConfig metrics() {
        return this.metrics;
    }

    private static class OperationLogConfig
    implements TelemetryConfig.LogConfig {
        private final TelemetryConfig.LogConfig client;
        @Nullable
        private final TelemetryConfig.LogConfig job;

        private OperationLogConfig(TelemetryConfig.LogConfig client, @Nullable TelemetryConfig.LogConfig job) {
            this.client = Objects.requireNonNull(client);
            this.job = job;
        }

        @Nullable
        public Boolean enabled() {
            if (this.job != null && this.job.enabled() != null) {
                return this.job.enabled();
            }
            return this.client.enabled();
        }
    }

    private static class OperationMetricConfig
    implements TelemetryConfig.MetricsConfig {
        private final TelemetryConfig.MetricsConfig client;
        @Nullable
        private final TelemetryConfig.MetricsConfig job;

        private OperationMetricConfig(TelemetryConfig.MetricsConfig client, @Nullable TelemetryConfig.MetricsConfig job) {
            this.client = Objects.requireNonNull(client);
            this.job = job;
        }

        @Nullable
        public Boolean enabled() {
            if (this.job != null && this.job.enabled() != null) {
                return this.job.enabled();
            }
            return this.client.enabled();
        }

        public double[] slo() {
            if (this.job != null && this.job.slo() != null) {
                return this.job.slo();
            }
            return this.client.slo();
        }

        public double[] slo(TelemetryConfig.MetricsConfig.OpentelemetrySpec spec) {
            if (this.job != null && this.job.slo(spec) != null) {
                return this.job.slo(spec);
            }
            return this.client.slo(spec);
        }
    }

    private static class OperationTracingConfig
    implements TelemetryConfig.TracingConfig {
        private final TelemetryConfig.TracingConfig client;
        @Nullable
        private final TelemetryConfig.TracingConfig job;

        private OperationTracingConfig(TelemetryConfig.TracingConfig client, @Nullable TelemetryConfig.TracingConfig job) {
            this.client = Objects.requireNonNull(client);
            this.job = job;
        }

        @Nullable
        public Boolean enabled() {
            if (this.job != null && this.job.enabled() != null) {
                return this.job.enabled();
            }
            return this.client.enabled();
        }
    }
}

