/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.scheduling.jdk;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.common.util.TimeUtils;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingTelemetry;
import ru.tinkoff.kora.scheduling.jdk.JdkSchedulingExecutor;

public abstract class AbstractJob
implements Lifecycle {
    private final Logger logger;
    private final SchedulingTelemetry telemetry;
    private final JdkSchedulingExecutor service;
    private final Runnable command;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile ScheduledFuture<?> scheduledFuture;

    public AbstractJob(SchedulingTelemetry telemetry, JdkSchedulingExecutor service, Runnable command) {
        this.telemetry = telemetry;
        this.service = service;
        this.command = command;
        this.logger = LoggerFactory.getLogger((Class)telemetry.jobClass());
    }

    public final void init() {
        if (this.started.compareAndSet(false, true)) {
            this.logger.debug("Scheduled Job '{}#{}' starting...", (Object)this.telemetry.jobClass().getCanonicalName(), (Object)this.telemetry.jobMethod());
            long started = TimeUtils.started();
            this.scheduledFuture = this.schedule(this.service, this::runJob);
            this.logger.info("Started Scheduled Job '{}#{}' started in {}", new Object[]{this.telemetry.jobClass().getCanonicalName(), this.telemetry.jobMethod(), TimeUtils.tookForLogging((long)started)});
        }
    }

    private void runJob() {
        MDC.clear();
        Context.clear();
        Context ctx = Context.current();
        SchedulingTelemetry.SchedulingTelemetryContext telemetryCtx = this.telemetry.get(ctx);
        try {
            this.command.run();
            telemetryCtx.close(null);
        }
        catch (Exception e) {
            this.logger.warn("Uncaught exception while running job: {}#{}", new Object[]{this.telemetry.jobClass().getCanonicalName(), this.telemetry.jobMethod(), e});
            telemetryCtx.close((Throwable)e);
        }
    }

    protected abstract ScheduledFuture<?> schedule(JdkSchedulingExecutor var1, Runnable var2);

    public final void release() {
        if (this.started.compareAndSet(true, false)) {
            this.logger.debug("Scheduled Job '{}#{}' stopping...", (Object)this.telemetry.jobClass().getCanonicalName(), (Object)this.telemetry.jobMethod());
            long started = TimeUtils.started();
            ScheduledFuture<?> f = this.scheduledFuture;
            this.scheduledFuture = null;
            f.cancel(true);
            this.logger.info("Scheduled Job '{}#{}' stopped in {}", new Object[]{this.telemetry.jobClass().getCanonicalName(), this.telemetry.jobMethod(), TimeUtils.tookForLogging((long)started)});
        }
    }
}

