/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.scheduling.jdk;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.common.util.TimeUtils;
import ru.tinkoff.kora.scheduling.jdk.JdkSchedulingExecutor;
import ru.tinkoff.kora.scheduling.jdk.ScheduledExecutorServiceConfig;

public final class DefaultJdkSchedulingExecutor
implements Lifecycle,
JdkSchedulingExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJdkSchedulingExecutor.class);
    private static final AtomicReferenceFieldUpdater<DefaultJdkSchedulingExecutor, ScheduledThreadPoolExecutor> SERVICE = AtomicReferenceFieldUpdater.newUpdater(DefaultJdkSchedulingExecutor.class, ScheduledThreadPoolExecutor.class, "service");
    private final ScheduledExecutorServiceConfig config;
    private volatile ScheduledThreadPoolExecutor service;

    public DefaultJdkSchedulingExecutor(ScheduledExecutorServiceConfig config) {
        this.config = config;
    }

    public void init() {
        logger.debug("JdkSchedulingExecutor starting...");
        long started = System.nanoTime();
        AtomicInteger counter = new AtomicInteger();
        ScheduledThreadPoolExecutor service = new ScheduledThreadPoolExecutor(0, r -> {
            String name = "kora-scheduling-" + counter.incrementAndGet();
            Thread t = new Thread(r, name);
            t.setDaemon(false);
            return t;
        });
        service.setMaximumPoolSize(this.config.threads());
        service.setKeepAliveTime(1L, TimeUnit.MINUTES);
        service.allowCoreThreadTimeOut(true);
        service.setRemoveOnCancelPolicy(true);
        if (!SERVICE.compareAndSet(this, null, service)) {
            service.shutdownNow();
        }
        logger.info("JdkSchedulingExecutor started in {}", (Object)TimeUtils.tookForLogging((long)started));
    }

    public void release() throws InterruptedException {
        ScheduledThreadPoolExecutor service = SERVICE.getAndSet(this, null);
        if (service != null) {
            logger.debug("JdkSchedulingExecutor stopping...");
            long started = System.nanoTime();
            service.shutdownNow();
            service.awaitTermination(10L, TimeUnit.SECONDS);
            logger.info("JdkSchedulingExecutor stopped in {}", (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable job, long initialDelay, long delay, TimeUnit timeUnit) {
        logger.debug("Schedule with fixed delay: initialDelay={}, delay={}, unit={}, job={}", new Object[]{initialDelay, delay, timeUnit, job});
        return this.service.scheduleWithFixedDelay(job, initialDelay, delay, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable job, long initialDelay, long period, TimeUnit timeUnit) {
        logger.debug("Schedule at fixed rate: initialDelay={}, period={}, unit={}, job={}", new Object[]{initialDelay, period, timeUnit, job});
        return this.service.scheduleAtFixedRate(job, initialDelay, period, timeUnit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable job, long delay, TimeUnit timeUnit) {
        logger.debug("Schedule at fixed rate: delay={}, unit={}, job={}", new Object[]{delay, timeUnit, job});
        return this.service.schedule(job, delay, timeUnit);
    }
}

