/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.scheduling.jdk;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import ru.tinkoff.kora.scheduling.common.telemetry.SchedulingTelemetry;
import ru.tinkoff.kora.scheduling.jdk.AbstractJob;
import ru.tinkoff.kora.scheduling.jdk.JdkSchedulingExecutor;

public final class RunOnceJob
extends AbstractJob {
    private final Duration delay;

    public RunOnceJob(SchedulingTelemetry schedulingTelemetry, JdkSchedulingExecutor service, Runnable command, Duration delay) {
        super(schedulingTelemetry, service, command);
        this.delay = Objects.requireNonNull(delay);
    }

    @Override
    protected ScheduledFuture<?> schedule(JdkSchedulingExecutor service, Runnable command) {
        long delay = this.delay.toMillis();
        return service.schedule(command, delay, TimeUnit.MILLISECONDS);
    }
}

