/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.annotation.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.w3c.dom.Node;
import ru.tinkoff.kora.annotation.processor.common.AnnotationUtils;
import ru.tinkoff.kora.annotation.processor.common.CommonClassNames;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.annotation.processor.common.NameUtils;
import ru.tinkoff.kora.annotation.processor.common.TagUtils;
import ru.tinkoff.kora.soap.client.annotation.processor.SoapClasses;
import ru.tinkoff.kora.soap.client.annotation.processor.WebServiceClientAnnotationProcessor;

public class SoapClientImplGenerator {
    private static final ClassName SYNCHRONOUS_SINK = ClassName.get((String)"reactor.core.publisher", (String)"SynchronousSink", (String[])new String[0]);
    private static final ClassName SOAP_CONFIG = ClassName.get((String)"ru.tinkoff.kora.soap.client.common", (String)"SoapServiceConfig", (String[])new String[0]);
    private static final ClassName HTTP_CLIENT = ClassName.get((String)"ru.tinkoff.kora.http.client.common", (String)"HttpClient", (String[])new String[0]);
    private static final ClassName SOAP_TELEMETRY = ClassName.get((String)"ru.tinkoff.kora.soap.client.common.telemetry", (String)"SoapClientTelemetryFactory", (String[])new String[0]);
    private final ProcessingEnvironment processingEnv;

    public SoapClientImplGenerator(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public TypeSpec generateModule(Element element, SoapClasses soapClasses) {
        AnnotationMirror webService = this.findAnnotation(element, soapClasses.webServiceType());
        String serviceName = this.findAnnotationValue(webService, "name").toString();
        if (serviceName.isEmpty()) {
            serviceName = this.findAnnotationValue(webService, "serviceName").toString();
        }
        if (serviceName.isEmpty()) {
            serviceName = this.findAnnotationValue(webService, "portName").toString();
        }
        if (serviceName.isEmpty()) {
            serviceName = element.getSimpleName().toString();
        }
        String configPath = "soapClient." + serviceName;
        String moduleName = NameUtils.generatedType((Element)element, (String)"SoapClientModule");
        ParameterizedTypeName extractorClass = ParameterizedTypeName.get((ClassName)CommonClassNames.configValueExtractor, (TypeName[])new TypeName[]{SOAP_CONFIG});
        TypeName elementType = ClassName.get((TypeMirror)element.asType());
        String methodPrefix = serviceName.substring(0, 1).toLowerCase() + serviceName.substring(1);
        TypeSpec.Builder type = TypeSpec.interfaceBuilder((String)moduleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", "$S", new Object[]{WebServiceClientAnnotationProcessor.class.getCanonicalName()}).build()).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.module).build()).addOriginatingElement(element).addMethod(MethodSpec.methodBuilder((String)(methodPrefix + "_SoapConfig")).addAnnotation(TagUtils.makeAnnotationSpec(Set.of(elementType.toString()))).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)SOAP_CONFIG).addAnnotation(CommonClassNames.defaultComponent).addParameter(ParameterSpec.builder((TypeName)CommonClassNames.config, (String)"config", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)extractorClass, (String)"extractor", (Modifier[])new Modifier[0]).build()).addStatement("var value = config.get($S)", new Object[]{configPath}).addStatement("var parsed = extractor.extract(value)", new Object[0]).beginControlFlow("if (parsed == null)", new Object[0]).addStatement("throw $T.missingValueAfterParse(value)", new Object[]{CommonClassNames.configValueExtractionException}).endControlFlow().addStatement("return parsed", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)(methodPrefix + "_SoapClientImpl")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns(elementType).addAnnotation(CommonClassNames.defaultComponent).addParameter(ParameterSpec.builder((TypeName)HTTP_CLIENT, (String)"httpClient", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)SOAP_TELEMETRY, (String)"telemetry", (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder((TypeName)SOAP_CONFIG, (String)"config", (Modifier[])new Modifier[0]).addAnnotation(TagUtils.makeAnnotationSpec(Set.of(elementType.toString()))).build()).beginControlFlow("try", new Object[0]).addStatement("return new $L(httpClient, telemetry, config)", new Object[]{NameUtils.generatedType((Element)element, (String)"SoapClientImpl")}).nextControlFlow("catch (Exception e)", new Object[0]).addStatement("throw new $T(e)", new Object[]{IllegalStateException.class}).endControlFlow().build());
        return type.build();
    }

    public TypeSpec generate(Element service, SoapClasses soapClasses) {
        AnnotationMirror webService;
        String serviceName;
        ArrayList<TypeName> jaxbClasses = new ArrayList<TypeName>();
        jaxbClasses.add(soapClasses.soapEnvelopeObjectFactory());
        AnnotationMirror xmlSeeAlso = this.findAnnotation(service, soapClasses.xmlSeeAlsoType());
        if (xmlSeeAlso != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> valuesEntry : xmlSeeAlso.getElementValues().entrySet()) {
                if (!valuesEntry.getKey().getSimpleName().contentEquals("value")) continue;
                List annotationValues = (List)valuesEntry.getValue().getValue();
                for (Object i : annotationValues) {
                    AnnotationValue annotationValue = (AnnotationValue)i;
                    TypeMirror value = (TypeMirror)annotationValue.getValue();
                    jaxbClasses.add(TypeName.get((TypeMirror)value));
                }
            }
        }
        if ((serviceName = this.findAnnotationValue(webService = this.findAnnotation(service, soapClasses.webServiceType()), "name").toString()).isEmpty()) {
            serviceName = this.findAnnotationValue(webService, "serviceName").toString();
        }
        if (serviceName.isEmpty()) {
            serviceName = this.findAnnotationValue(webService, "portName").toString();
        }
        if (serviceName.isEmpty()) {
            serviceName = service.getSimpleName().toString();
        }
        String targetNamespace = this.findAnnotationValue(webService, "targetNamespace").toString();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)NameUtils.generatedType((Element)service, (String)"SoapClientImpl")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)CommonClassNames.koraGenerated).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{WebServiceClientAnnotationProcessor.class.getCanonicalName()})).build()).addField((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{soapClasses.soapEnvelopeTypeName(), soapClasses.soapEnvelopeTypeName()}), "envelopeProcessor", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(soapClasses.jaxbContextTypeName(), "jaxb", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(soapClasses.httpClientTypeName(), "httpClient", new Modifier[0]).addParameter(soapClasses.soapClientTelemetryFactory(), "telemetry", new Modifier[0]).addParameter(soapClasses.soapServiceConfig(), "config", new Modifier[0]).addCode("this(httpClient, telemetry, config, $T.identity());\n", new Object[]{Function.class}).addException(soapClasses.jaxbExceptionTypeName()).build()).addSuperinterface(service.asType());
        CodeBlock.Builder jaxbClassesCode = CodeBlock.builder();
        for (int i = 0; i < jaxbClasses.size(); ++i) {
            jaxbClassesCode.add("$T.class", new Object[]{jaxbClasses.get(i)});
            if (i >= jaxbClasses.size() - 1) continue;
            jaxbClassesCode.add(", ", new Object[0]);
        }
        List<ExecutableElement> webMethods = service.getEnclosedElements().stream().filter(element -> element instanceof ExecutableElement).map(ExecutableElement.class::cast).filter(method -> this.findAnnotation((Element)method, soapClasses.webMethodType()) != null).toList();
        this.addRequestClasses(soapClasses, builder, jaxbClassesCode, targetNamespace, webMethods);
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(soapClasses.httpClientTypeName(), "httpClient", new Modifier[0]).addParameter(soapClasses.soapClientTelemetryFactory(), "telemetry", new Modifier[0]).addParameter(soapClasses.soapServiceConfig(), "config", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{soapClasses.soapEnvelopeTypeName(), soapClasses.soapEnvelopeTypeName()}), "envelopeProcessor", new Modifier[0]).addCode("this.jaxb = $T.newInstance($L);\n", new Object[]{soapClasses.jaxbContextTypeName(), jaxbClassesCode.build()}).addCode("this.envelopeProcessor = envelopeProcessor;\n", new Object[0]).addException(soapClasses.jaxbExceptionTypeName());
        for (ExecutableElement method2 : webMethods) {
            AnnotationMirror webMethod = this.findAnnotation(method2, soapClasses.webMethodType());
            Object soapAction = this.findAnnotationValue(webMethod, "action").toString();
            soapAction = ((String)soapAction).isEmpty() ? null : "\"" + (String)soapAction + "\"";
            String operationName = this.findAnnotationValue(webMethod, "operationName").toString();
            if (operationName.isEmpty()) {
                operationName = method2.getSimpleName().toString();
            }
            String executorFieldName = operationName + "RequestExecutor";
            constructorBuilder.addCode("this.$L = new $T(httpClient, telemetry, new $T(jaxb), $S, config, $S, $S);\n", new Object[]{executorFieldName, soapClasses.soapRequestExecutor(), soapClasses.xmlToolsType(), serviceName, operationName, soapAction});
            builder.addField(soapClasses.soapRequestExecutor(), executorFieldName, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            MethodSpec.Builder m = MethodSpec.overriding((ExecutableElement)method2);
            this.addMapRequest(m, method2, soapClasses);
            m.addCode("var __response = this.$L.call(__requestEnvelope);\n", new Object[]{executorFieldName});
            this.addMapResponse(m, method2, soapClasses, false);
            builder.addMethod(m.build());
            TypeMirror monoParam = method2.getReturnType().getKind() == TypeKind.VOID ? this.processingEnv.getElementUtils().getTypeElement("java.lang.Void").asType() : method2.getReturnType();
            ParameterizedTypeName reactiveReturnType = ParameterizedTypeName.get((ClassName)ClassName.get(CompletionStage.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)monoParam)});
            MethodSpec.Builder reactiveM = MethodSpec.methodBuilder((String)(method2.getSimpleName() + "Async")).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)reactiveReturnType);
            for (VariableElement variableElement : method2.getParameters()) {
                reactiveM.addParameter(TypeName.get((TypeMirror)variableElement.asType()), variableElement.getSimpleName().toString(), new Modifier[0]);
            }
            this.addMapRequest(reactiveM, method2, soapClasses);
            reactiveM.addCode("var __future = new $T<$T>();\n", new Object[]{CompletableFuture.class, monoParam});
            reactiveM.addCode("this.$L.callAsync(__requestEnvelope)\n", new Object[]{executorFieldName});
            reactiveM.addCode("  .whenComplete((__response, __throwable) -> {$>$>\n", new Object[]{soapClasses.soapResult(), ParameterizedTypeName.get((ClassName)SYNCHRONOUS_SINK, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)monoParam)})});
            reactiveM.addCode("if (__throwable != null) {\n", new Object[0]);
            reactiveM.addCode("  __future.completeExceptionally(__throwable);\n", new Object[0]);
            reactiveM.addCode("  return;\n", new Object[0]);
            reactiveM.addCode("}\n", new Object[0]);
            this.addMapResponse(reactiveM, method2, soapClasses, true);
            reactiveM.addCode("$<$<\n});\n", new Object[0]);
            reactiveM.addCode("return __future;\n", new Object[0]);
            builder.addMethod(reactiveM.build());
        }
        builder.addMethod(constructorBuilder.build());
        return builder.build();
    }

    private void addRequestClasses(SoapClasses soapClasses, TypeSpec.Builder builder, CodeBlock.Builder jaxbClassesCode, String targetNamespace, List<ExecutableElement> webMethods) {
        for (ExecutableElement method : webMethods) {
            if (!this.isRpcBuilding(method, soapClasses)) continue;
            AnnotationMirror webMethod = this.findAnnotation(method, soapClasses.webMethodType());
            String operationName = this.findAnnotationValue(webMethod, "operationName").toString();
            if (operationName.isEmpty()) {
                operationName = method.getSimpleName().toString();
            }
            String requestClassName = operationName + "Request";
            jaxbClassesCode.add(", $L.class", new Object[]{requestClassName});
            TypeSpec.Builder b = TypeSpec.classBuilder((String)requestClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(AnnotationSpec.builder((ClassName)soapClasses.xmlAccessorTypeClassName()).addMember("value", "$T.NONE", new Object[]{soapClasses.xmlAccessTypeClassName()}).build()).addAnnotation(AnnotationSpec.builder((ClassName)soapClasses.xmlRootElementClassName()).addMember("namespace", "$S", new Object[]{targetNamespace}).addMember("name", "$S", new Object[]{operationName}).build());
            for (VariableElement variableElement : method.getParameters()) {
                AnnotationMirror webParam = this.findAnnotation(variableElement, soapClasses.webParamType());
                if ("OUT".equals(this.findAnnotationValue(webParam, "mode").toString())) continue;
                TypeMirror type = variableElement.asType();
                if (this.processingEnv.getTypeUtils().isAssignable(type, soapClasses.holderTypeErasure())) {
                    type = ((DeclaredType)type).getTypeArguments().get(0);
                }
                b.addField(FieldSpec.builder((TypeName)TypeName.get((TypeMirror)type), (String)variableElement.getSimpleName().toString(), (Modifier[])new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)soapClasses.xmlElementClassName()).addMember("name", "$S", new Object[]{this.findAnnotationValue(webParam, "partName").toString()}).build()).build());
            }
            builder.addType(b.build());
        }
    }

    private void addMapRequest(MethodSpec.Builder m, ExecutableElement method, SoapClasses soapClasses) {
        AnnotationMirror requestWrapper = this.findAnnotation(method, soapClasses.requestWrapperType());
        if (requestWrapper != null) {
            Object wrapperClass = this.findAnnotationValue(requestWrapper, "className");
            m.addCode("var __requestWrapper = new $L();\n", new Object[]{wrapperClass});
            for (VariableElement variableElement : method.getParameters()) {
                AnnotationMirror webParam = this.findAnnotation(variableElement, soapClasses.webParamType());
                String string = (String)this.findAnnotationValue(webParam, "name");
                if (this.processingEnv.getTypeUtils().isAssignable(variableElement.asType(), this.processingEnv.getTypeUtils().erasure(soapClasses.holderTypeErasure()))) {
                    m.addCode("__requestWrapper.set$L($L.value);\n", new Object[]{CommonUtils.capitalize((String)string), variableElement});
                    continue;
                }
                m.addCode("__requestWrapper.set$L($L);\n", new Object[]{CommonUtils.capitalize((String)string), variableElement});
            }
            m.addCode("var __requestEnvelope = this.envelopeProcessor.apply(new $L(__requestWrapper));\n", new Object[]{soapClasses.soapEnvelopeTypeName()});
        } else if (this.isRpcBuilding(method, soapClasses)) {
            AnnotationMirror webMethod = this.findAnnotation(method, soapClasses.webMethodType());
            String operationName = this.findAnnotationValue(webMethod, "operationName").toString();
            if (operationName.isEmpty()) {
                operationName = method.getSimpleName().toString();
            }
            String string = operationName + "Request";
            m.addCode("var __requestWrapper = new $L();\n", new Object[]{string});
            for (VariableElement variableElement : method.getParameters()) {
                AnnotationMirror webParam = this.findAnnotation(variableElement, soapClasses.webParamType());
                if ("OUT".equals(this.findAnnotationValue(webParam, "mode").toString())) continue;
                m.addCode("__requestWrapper.$L = $L;\n", new Object[]{variableElement, variableElement});
            }
            m.addCode("var __requestEnvelope = this.envelopeProcessor.apply(new $L(__requestWrapper));\n", new Object[]{soapClasses.soapEnvelopeTypeName()});
        } else {
            assert (method.getParameters().size() == 1);
            m.addCode("var __requestEnvelope = this.envelopeProcessor.apply(new $L($L));\n", new Object[]{soapClasses.soapEnvelopeTypeName(), method.getParameters().get(0)});
        }
    }

    private boolean isRpcBuilding(ExecutableElement method, SoapClasses soapClasses) {
        AnnotationMirror soapBinding = this.findAnnotation(method.getEnclosingElement(), soapClasses.soapBindingType());
        return soapBinding != null && this.findAnnotationValue(soapBinding, "style").toString().equals("RPC");
    }

    private void addMapResponse(MethodSpec.Builder m, ExecutableElement method, SoapClasses soapClasses, boolean isReactive) {
        m.addCode("if (__response instanceof $T __failure) {$>\n", new Object[]{soapClasses.soapResultFailure()});
        m.addCode("var __fault = __failure.fault();\n", new Object[0]);
        if (!method.getThrownTypes().isEmpty()) {
            m.beginControlFlow("if (__fault.getDetail() != null && __fault.getDetail().getAny() != null && __fault.getDetail().getAny().size() > 0)", new Object[0]);
            m.addCode("var __detail = __fault.getDetail().getAny().get(0);\n", new Object[0]);
            for (TypeMirror typeMirror : method.getThrownTypes()) {
                AnnotationMirror annotationMirror = this.findAnnotation(this.processingEnv.getTypeUtils().asElement(typeMirror), soapClasses.webFaultType());
                if (annotationMirror == null) continue;
                TypeMirror detailType = this.processingEnv.getTypeUtils().asElement(typeMirror).getEnclosedElements().stream().filter(getFaultInfo -> getFaultInfo.getKind() == ElementKind.METHOD).filter(getFaultInfo -> getFaultInfo.getSimpleName().contentEquals("getFaultInfo")).map(ExecutableElement.class::cast).map(ExecutableElement::getReturnType).findFirst().get();
                m.addCode("if (__detail instanceof $T __error) {\n", new Object[]{detailType});
                if (isReactive) {
                    m.addCode("  __future.completeExceptionally(new $T(__failure.faultMessage(), __error));\n", new Object[]{typeMirror});
                    m.addCode("  return;\n", new Object[]{typeMirror});
                } else {
                    m.addCode("  throw new $T(__failure.faultMessage(), __error);\n", new Object[]{typeMirror});
                }
                m.addCode("} else ", new Object[0]);
            }
            if (isReactive) {
                m.addCode("{\n", new Object[0]);
                m.addCode("  __future.completeExceptionally(new $T(__failure.faultMessage(), __fault));\n", new Object[]{soapClasses.soapFaultException()});
                m.addCode("  return;\n}\n", new Object[0]);
            } else {
                m.addCode("\n  throw new $T(__failure.faultMessage(), __fault);\n", new Object[]{soapClasses.soapFaultException()});
            }
            m.endControlFlow();
        }
        if (isReactive) {
            m.addCode("__future.completeExceptionally(new $T(__failure.faultMessage(), __fault));\n", new Object[]{soapClasses.soapFaultException()});
            m.addCode("return;$<\n}\n", new Object[0]);
        } else {
            m.addCode("throw new $T(__failure.faultMessage(), __fault);$<\n}\n", new Object[]{soapClasses.soapFaultException()});
        }
        m.addCode("var __success = ($T) __response;\n", new Object[]{soapClasses.soapResultSuccess()});
        AnnotationMirror responseWrapper = this.findAnnotation(method, soapClasses.responseWrapperType());
        if (responseWrapper != null) {
            String string = (String)this.findAnnotationValue(responseWrapper, "className");
            AnnotationMirror annotationMirror = this.findAnnotation(method, soapClasses.webResultType());
            m.addCode("var __responseBodyWrapper = ($L) __success.body();\n", new Object[]{string});
            if (annotationMirror != null) {
                String webResultName = (String)this.findAnnotationValue(annotationMirror, "name");
                if (isReactive) {
                    m.addCode("__future.complete(__responseBodyWrapper.get$L());\n", new Object[]{CommonUtils.capitalize((String)webResultName)});
                } else {
                    m.addCode("return __responseBodyWrapper.get$L();\n", new Object[]{CommonUtils.capitalize((String)webResultName)});
                }
            } else {
                for (VariableElement variableElement : method.getParameters()) {
                    AnnotationMirror webParam = this.findAnnotation(variableElement, soapClasses.webParamType());
                    String mode = (String)this.findAnnotationValue(webParam, "mode");
                    if ("IN".equals(mode)) continue;
                    Object webParamName = this.findAnnotationValue(webParam, "name");
                    m.addCode("$L.value = __responseBodyWrapper.get$L();\n", new Object[]{variableElement, CommonUtils.capitalize((String)webParamName.toString())});
                    if (!isReactive) continue;
                    m.addCode("__future.complete(null);\n", new Object[0]);
                }
            }
        } else if (method.getReturnType().getKind() == TypeKind.VOID) {
            if (isReactive) {
                m.addCode("__future.complete(null);\n", new Object[0]);
            }
            if (this.isRpcBuilding(method, soapClasses)) {
                m.addCode("var __document = ($T) __success.body();\n", new Object[]{Node.class});
                m.addCode("for (var __i = 0; __i < __document.getChildNodes().getLength(); __i++) {$>\n", new Object[]{Node.class});
                m.addCode("var __child = __document.getChildNodes().item(__i);\n", new Object[0]);
                m.addCode("var __childName = __child.getLocalName();\n", new Object[0]);
                m.addCode("try {$>\n", new Object[0]);
                m.addCode("switch (__childName) {$>\n", new Object[0]);
                for (VariableElement variableElement : method.getParameters()) {
                    AnnotationMirror webParam = this.findAnnotation(variableElement, soapClasses.webParamType());
                    if ("IN".equals(this.findAnnotationValue(webParam, "mode").toString())) continue;
                    TypeMirror typeMirror = variableElement.asType();
                    if (!this.processingEnv.getTypeUtils().isAssignable(typeMirror, soapClasses.holderTypeErasure())) continue;
                    TypeMirror partType = ((DeclaredType)typeMirror).getTypeArguments().get(0);
                    String partName = this.findAnnotationValue(webParam, "partName").toString();
                    m.addCode("case $S:\n", new Object[]{partName});
                    m.addCode("  $L.value = this.jaxb.createUnmarshaller().unmarshal(__child, $T.class)\n    .getValue();\n", new Object[]{variableElement, partType});
                    m.addCode("  break;\n", new Object[0]);
                }
                m.addCode("default: break;\n", new Object[0]);
                m.addCode("$<\n}\n", new Object[0]);
                m.addCode("$<\n} catch ($T __jaxbException) {$>\n", new Object[]{soapClasses.jaxbExceptionTypeName()});
                m.addCode("throw new $T(__jaxbException);\n", new Object[]{soapClasses.soapException()});
                m.addCode("$<\n}\n", new Object[0]);
                m.addCode("$<\n}\n", new Object[0]);
            }
        } else if (isReactive) {
            m.addCode("__future.complete(($T) __success.body());\n", new Object[]{method.getReturnType()});
        } else {
            m.addCode("return ($T) __success.body();\n", new Object[]{method.getReturnType()});
        }
    }

    @Nullable
    private AnnotationMirror findAnnotation(Element element, ClassName annotationType) {
        return AnnotationUtils.findAnnotation((Element)element, (ClassName)annotationType);
    }

    @Nullable
    private <T> T findAnnotationValue(AnnotationMirror annotationMirror, String name) {
        return (T)AnnotationUtils.parseAnnotationValue((Elements)this.processingEnv.getElementUtils(), (AnnotationMirror)annotationMirror, (String)name);
    }
}

