/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.annotation.processor;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.soap.client.annotation.processor.SoapClasses;
import ru.tinkoff.kora.soap.client.annotation.processor.SoapClientImplGenerator;

public class WebServiceClientAnnotationProcessor
extends AbstractKoraProcessor {
    private SoapClientImplGenerator generator;

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of("jakarta.jws.WebService", "javax.jws.WebService");
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.generator = new SoapClientImplGenerator(processingEnv);
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> webServices;
        TypeElement jakartaWebService = this.elements.getTypeElement("jakarta.jws.WebService");
        TypeElement javaxWebService = this.elements.getTypeElement("javax.jws.WebService");
        if (jakartaWebService != null) {
            SoapClasses.JakartaClasses jakartaClasses = new SoapClasses.JakartaClasses(this.types, this.elements);
            webServices = roundEnv.getElementsAnnotatedWith(jakartaWebService);
            for (Element element : webServices) {
                try {
                    this.processService(element, jakartaClasses);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (javaxWebService != null) {
            SoapClasses.JavaxClasses javaxClasses = new SoapClasses.JavaxClasses(this.types, this.elements);
            webServices = roundEnv.getElementsAnnotatedWith(javaxWebService);
            for (Element element : webServices) {
                try {
                    this.processService(element, javaxClasses);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }

    private void processService(Element service, SoapClasses soapClasses) throws IOException {
        TypeSpec typeSpec = this.generator.generate(service, soapClasses);
        JavaFile typeJavaFile = JavaFile.builder((String)this.elements.getPackageOf(service).getQualifiedName().toString(), (TypeSpec)typeSpec).build();
        TypeSpec moduleSpec = this.generator.generateModule(service, soapClasses);
        JavaFile moduleJavaFile = JavaFile.builder((String)this.elements.getPackageOf(service).getQualifiedName().toString(), (TypeSpec)moduleSpec).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)typeJavaFile);
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)moduleJavaFile);
    }
}

