/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.annotation.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import ru.tinkoff.kora.annotation.processor.common.AbstractKoraProcessor;
import ru.tinkoff.kora.annotation.processor.common.CommonUtils;
import ru.tinkoff.kora.soap.client.annotation.processor.SoapClasses;
import ru.tinkoff.kora.soap.client.annotation.processor.SoapClientImplGenerator;

public class WebServiceClientAnnotationProcessor
extends AbstractKoraProcessor {
    private SoapClientImplGenerator generator;
    private static final ClassName JAKARTA_WEB_SERVICE = new SoapClasses.JakartaClasses().webServiceType();
    private static final ClassName JAVAX_WEB_SERVICE = new SoapClasses.JavaxClasses().webServiceType();

    public Set<ClassName> getSupportedAnnotationClassNames() {
        return Set.of(JAKARTA_WEB_SERVICE, JAVAX_WEB_SERVICE);
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.generator = new SoapClientImplGenerator(processingEnv);
    }

    public void process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Map<ClassName, List<AbstractKoraProcessor.AnnotatedElement>> annotatedElements) {
        Element service;
        for (AbstractKoraProcessor.AnnotatedElement annotated : annotatedElements.getOrDefault(JAKARTA_WEB_SERVICE, List.of())) {
            SoapClasses.JakartaClasses jakartaClasses = new SoapClasses.JakartaClasses();
            service = annotated.element();
            this.processService(service, jakartaClasses);
        }
        for (AbstractKoraProcessor.AnnotatedElement annotated : annotatedElements.getOrDefault(JAVAX_WEB_SERVICE, List.of())) {
            SoapClasses.JavaxClasses javaxClasses = new SoapClasses.JavaxClasses();
            service = annotated.element();
            this.processService(service, javaxClasses);
        }
    }

    private void processService(Element service, SoapClasses soapClasses) {
        TypeSpec typeSpec = this.generator.generate(service, soapClasses);
        JavaFile typeJavaFile = JavaFile.builder((String)this.elements.getPackageOf(service).getQualifiedName().toString(), (TypeSpec)typeSpec).build();
        TypeSpec moduleSpec = this.generator.generateModule(service, soapClasses);
        JavaFile moduleJavaFile = JavaFile.builder((String)this.elements.getPackageOf(service).getQualifiedName().toString(), (TypeSpec)moduleSpec).build();
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)typeJavaFile);
        CommonUtils.safeWriteTo((ProcessingEnvironment)this.processingEnv, (JavaFile)moduleJavaFile);
    }
}

